/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.ArrayList;
import java.util.List;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record BannedBlock(String reason, Component text, boolean systemLock) {
    public static final List<BanPredicate> TESTS = new ArrayList<BanPredicate>();
    public static final BannedBlock ALWAYS_ON = new BannedBlock(null, null, true);
    public static final BannedBlock ALREADY_MORPHED = new BannedBlock("You have already been turned into this block.", (Component)Component.translatable((String)"blockomorph.bannedBlock.same"));

    public BannedBlock(String reason, Component text) {
        this(reason, text, false);
    }

    @Nullable
    public static BannedBlock isBannedBlock(BlockState state, @Nullable PlayerAccessor player, Source source) {
        for (BanPredicate predicate : TESTS) {
            BannedBlock reason = predicate.checkBanned(state, player, source);
            if (reason == null) continue;
            if (reason == ALWAYS_ON) {
                return null;
            }
            return reason;
        }
        return null;
    }

    static {
        TESTS.add((state, player, source) -> {
            if (state.isAir() && (source != Source.NETWORK || player != null && player.getTnt() == null)) {
                return ALWAYS_ON;
            }
            return null;
        });
        TESTS.add((state, player, source) -> {
            if (player != null && source == Source.NETWORK && player.getTnt() != null) {
                return new BannedBlock("No access to morph when TNT is lit!", (Component)Component.translatable((String)"blockomorph.bannedBlock.tnt"));
            }
            return null;
        });
        TESTS.add((state, player, source) -> {
            if (state.getBlock().defaultDestroyTime() < 0.0f && Config.getInstance().getValue("offUnbreakableBlocks", Boolean.class).booleanValue()) {
                return new BannedBlock("Unbreakable blocks not allowed!", (Component)Component.translatable((String)"blockomorph.bannedBlock.unbreakable"));
            }
            return null;
        });
        TESTS.add((state, player, source) -> {
            if ((!state.isSolid() || state.getRenderShape() == RenderShape.INVISIBLE) && Config.getInstance().getValue("solidBlocksOnly", Boolean.class).booleanValue()) {
                return new BannedBlock("Not solid blocks not allowed!", (Component)Component.translatable((String)"blockomorph.bannedBlock.solid"));
            }
            return null;
        });
        TESTS.add((state, player, source) -> {
            String name = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
            Config cfg = Config.getInstance();
            Config.Mode mode = cfg.getValue("listMode", Config.Mode.class);
            switch (mode) {
                case WHITELIST: {
                    if (cfg.getValue("allowedBlocks", List.class).contains(name)) break;
                    return new BannedBlock("Block " + name + " not allowed because it not in whitelist!", (Component)Component.translatable((String)"blockomorph.bannedBlock.whitelist"));
                }
                case BLACKLIST: {
                    if (!cfg.getValue("bannedBlocks", List.class).contains(name)) break;
                    return new BannedBlock("Block " + name + " not allowed because it in blacklist!", (Component)Component.translatable((String)"blockomorph.bannedBlock.blacklist"));
                }
            }
            return null;
        });
    }

    @FunctionalInterface
    public static interface BanPredicate {
        public BannedBlock checkBanned(BlockState var1, @Nullable PlayerAccessor var2, Source var3);
    }

    public static enum Source {
        NETWORK,
        COMMAND,
        SYSTEM;

    }
}

