/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.Objects;
import java.util.function.Consumer;
import net.blockomorph.network.ClientBoundMorphUpdatePacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class BlockInPlayer2 {
    private final InPlayerBlockPos offset;
    private final BlockPos pos;
    private final Player player;
    private BlockState blockState;
    private BlockEntity blockEntity;
    private BlockEntityTicker blockEntityTicker;
    private ModelData data = ModelData.EMPTY;

    public BlockInPlayer2(PlayerAccessor pl, InPlayerBlockPos pos, BlockState state, Consumer<BlockInPlayer2> preInit) {
        this.offset = pos;
        this.pos = pos.boundedBlockPos(pl.player());
        if (this.pos == null) {
            throw new IllegalArgumentException("Null BlockPos in BlockInPlayer! Player section: " + String.valueOf(BlockPosBounds.getChunkPosForPlayer(pl.player())) + " Level: " + String.valueOf(pl.player().level()));
        }
        this.player = pl.player();
        this.blockState = state;
        preInit.accept(this);
        this.initBlockEntity();
        this.initTicker();
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public InPlayerBlockPos getOffset() {
        return this.offset;
    }

    protected boolean shouldShowFluidState() {
        return Config.getInstance().getValue("liquidsInBlocks", Boolean.class);
    }

    public boolean shouldDoFluidAction() {
        return this.blockState.getBlock() instanceof LiquidBlock || !this.blockState.getFluidState().isEmpty() && this.shouldShowFluidState();
    }

    @Nullable
    public Throwable loadNBT(CompoundTag tg) {
        if (this.blockEntity != null) {
            try {
                this.blockEntity.loadWithComponents(tg, (HolderLookup.Provider)this.player.level().registryAccess());
            }
            catch (Throwable e) {
                return e;
            }
        }
        return null;
    }

    public BlockInPlayer2 handleClientTag(CompoundTag tg, ClientBoundMorphUpdatePacket pkt) {
        if (this.blockEntity != null) {
            try {
                this.blockEntity.onDataPacket(pkt.getListener().getConnection(), ClientboundBlockEntityDataPacket.create((BlockEntity)this.blockEntity, (ent, access) -> tg), (HolderLookup.Provider)this.player.registryAccess());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public void onPlace(BlockState newState, BlockState oldState, boolean update) {
        if (!this.player.level().isClientSide) {
            newState.onPlace(this.player.level(), this.pos, oldState, update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockInPlayer2 changeBlockState(BlockState state, boolean update) {
        BlockState old = this.blockState;
        this.blockState = state;
        if (!this.player.level().isClientSide) {
            try {
                old.onRemove(this.player.level(), this.pos, state, update);
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while removing block in morphed player on pos: " + String.valueOf(this.offset) + " for block: " + String.valueOf(old) + " on player: " + this.player.getName().getString(), (Throwable)e);
            }
            finally {
                if (this.needRemoveBlockEntity(old, state)) {
                    this.clearBlockEntity();
                }
            }
        } else if (this.needRemoveBlockEntity(old, state)) {
            this.clearBlockEntity();
        }
        this.onPlace(state, old, update);
        if (state.hasBlockEntity()) {
            if (this.blockEntity == null) {
                this.initBlockEntity();
            } else {
                this.blockEntity.setBlockState(state);
            }
        }
        this.initTicker();
        return this;
    }

    public void clearBlockEntity() {
        this.blockEntity = null;
        this.blockEntityTicker = null;
    }

    private void initBlockEntity() {
        Block block = this.blockState.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock ent = (EntityBlock)block;
            this.blockEntity = ent.newBlockEntity(this.pos, this.blockState);
            if (this.blockEntity != null) {
                this.blockEntity.setLevel(this.player.level());
                this.blockEntity.onLoad();
            }
        }
    }

    private void initTicker() {
        Block block = this.blockState.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock ent = (EntityBlock)block;
            if (this.blockEntity != null) {
                this.blockEntityTicker = ent.getTicker(this.player.level(), this.blockState, this.blockEntity.getType());
            }
        }
    }

    public void connectModelData(ModelData data) {
        this.data = Objects.requireNonNullElse(data, ModelData.EMPTY);
    }

    public ModelData getModelData() {
        return this.data;
    }

    public void tick() {
        if (this.blockEntity != null && this.blockEntityTicker != null) {
            try {
                this.blockEntityTicker.tick(this.player.level(), this.pos, this.blockState, this.blockEntity);
            }
            catch (Exception e) {
                this.blockEntityTicker = null;
                MorphUtils.LOGGER.error("An unexpected exception occurred while ticking a block entity in a transformed player with username " + this.player.getName().getString() + ": ", (Throwable)e);
            }
        }
    }

    public void animateTick(RandomSource randomSource, Block marker, Consumer<BlockState> needSpawnFluidDrip) {
        FluidState fluidState;
        if (this.player.level().isClientSide) {
            this.blockState.getBlock().animateTick(this.blockState, this.player.level(), this.pos, randomSource);
        }
        if (this.shouldDoFluidAction() && !(fluidState = this.blockState.getFluidState()).isEmpty()) {
            fluidState.animateTick(this.player.level(), this.pos, randomSource);
            needSpawnFluidDrip.accept(PlayerAccessor.of(this.player).getBlockState(this.offset.offset(0, -1, 0)));
        }
        if (this.blockState.getBlock() == marker) {
            Vec3 real = MorphUtils.getCetneredRealBlockPos(PlayerAccessor.of(this.player), this.offset);
            this.player.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, this.blockState), real.x, real.y, real.z, 0.0, 0.0, 0.0);
        }
    }

    private boolean needRemoveBlockEntity(BlockState old, BlockState newState) {
        return old.hasBlockEntity() && (!old.is(newState.getBlock()) || !newState.hasBlockEntity());
    }
}

