/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.VertexConsumerWrapper;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.blockomorph.utils.accessors.LevelRendererAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class MorphedPlayerRenderer {
    private final Minecraft mc = Minecraft.getInstance();
    private final BlockRenderDispatcher blockRenderDispatcher = this.mc.getBlockRenderer();
    private final EntityRenderDispatcher entityDispatcher = this.mc.getEntityRenderDispatcher();
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher = this.mc.getBlockEntityRenderDispatcher();
    private final MultiBufferSource crumblBuffer = this.mc.renderBuffers().crumblingBufferSource();
    private final RandomSource RANDOM = RandomSource.create();

    public boolean render(boolean translucent, AbstractClientPlayer player, float anim, float partialticks, PoseStack posestack, MultiBufferSource buffer, int light, Consumer<Float> shadow) {
        if (player instanceof PlayerAccessor) {
            PlayerAccessor pl = (PlayerAccessor)player;
            if (pl.isFullActive()) {
                shadow.accept(Float.valueOf(0.0f));
                posestack.pushPose();
                this.adjustMatrixForPlayer(posestack, pl, player);
                this.renderBlock(translucent, player, posestack, buffer, pl);
                this.renderBlockEntity(player, partialticks, posestack, buffer, pl);
                this.renderBreak(player, posestack, buffer, pl);
                this.renderFrame(posestack, buffer, pl);
                posestack.popPose();
                return true;
            }
            if (pl.getTnt() != null && !translucent) {
                this.renderTnt(player, anim, partialticks, posestack, buffer, light, pl);
                return true;
            }
        }
        return false;
    }

    private void renderTnt(AbstractClientPlayer player, float anim, float partialticks, PoseStack posestack, MultiBufferSource buffer, int light, PlayerAccessor pl) {
        PrimedTnt tnt = pl.getTnt();
        EntityRenderer rend = this.entityDispatcher.getRenderer((Entity)pl.getTnt());
        try {
            rend.render((Entity)tnt, anim, partialticks, posestack, buffer, light);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void adjustMatrixForPlayer(PoseStack poseStack, PlayerAccessor pl, AbstractClientPlayer player) {
        InPlayerBlockPos minpos = pl.minPos();
        AABB hitbox = player.getBoundingBox();
        Vec3 playerCenter = player.position();
        double offsetX = hitbox.minX - (playerCenter.x + (double)minpos.getX());
        double offsetZ = hitbox.minZ - (playerCenter.z + (double)minpos.getZ());
        poseStack.translate(offsetX, 0.0, offsetZ);
    }

    private BlockPos getPosForOffset(BlockInPlayer2 ctr) {
        return ctr.getPos();
    }

    public void renderBlock(boolean translucent, AbstractClientPlayer player, PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        for (Map.Entry<InPlayerBlockPos, BlockInPlayer2> entry : pl.getBlocksData2().entrySet()) {
            BlockInPlayer2 bl = entry.getValue();
            BlockState st = bl.getBlockState();
            InPlayerBlockPos pos = entry.getKey();
            posestack.pushPose();
            posestack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            if (st.getRenderShape() == RenderShape.MODEL) {
                this.renderBlock(translucent, player, st, posestack, buffer, bl, bl.getModelData());
            }
            if (bl.shouldDoFluidAction()) {
                this.renderLiquid(translucent, bl, posestack, buffer, pl);
            }
            posestack.popPose();
        }
    }

    private void renderBlock(boolean translucent, AbstractClientPlayer player, BlockState blockstate, PoseStack posestack, MultiBufferSource buffer, BlockInPlayer2 block, ModelData data) {
        Level level = player.level();
        BakedModel model = this.blockRenderDispatcher.getBlockModel(blockstate);
        BlockPos offset = this.getPosForOffset(block);
        ModelData modeldata = model.getModelData((BlockAndTintGetter)level, block.getPos(), blockstate, data);
        for (RenderType renderType : model.getRenderTypes(blockstate, this.RANDOM, modeldata)) {
            if (translucent != (renderType == RenderType.translucent())) {
                return;
            }
            VertexConsumer vertex = buffer.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType));
            this.blockRenderDispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, blockstate, offset, posestack, vertex, true, this.RANDOM, blockstate.getSeed(offset), OverlayTexture.NO_OVERLAY, modeldata, renderType);
        }
    }

    private void renderLiquid(boolean translucent, BlockInPlayer2 block, final PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        FluidState fluidState = block.getBlockState().getFluidState();
        if (!fluidState.isEmpty()) {
            BlockPos pos = block.getPos();
            RenderType renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState);
            if (renderType == RenderType.translucent()) {
                renderType = RenderType.translucentMovingBlock();
            }
            if (translucent != (renderType == RenderType.translucentMovingBlock())) {
                return;
            }
            final float xOffset = pos.getX() & 0xF;
            final float yOffset = pos.getY() & 0xF;
            final float zOffset = pos.getZ() & 0xF;
            VertexConsumerWrapper vertexConsumer = new VertexConsumerWrapper(this, buffer.getBuffer(renderType)){

                @Override
                public VertexConsumer addVertex(float x, float y, float z) {
                    Vector3f realPos = posestack.last().pose().transformPosition(x - xOffset, y - yOffset, z - zOffset, new Vector3f());
                    return super.addVertex(realPos.x(), realPos.y(), realPos.z());
                }
            };
            ClientLevelAccessor acc = ClientLevelAccessor.of(pl.player().level());
            try {
                acc.lockExternalMorphedBlockGetter(true);
                this.blockRenderDispatcher.renderLiquid(pos, (BlockAndTintGetter)pl.player().level(), (VertexConsumer)vertexConsumer, block.getBlockState(), fluidState);
                acc.lockExternalMorphedBlockGetter(false);
            }
            catch (ReportedException reportedException) {
                // empty catch block
            }
        }
    }

    private void renderBlockEntity(AbstractClientPlayer player, float partialticks, PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        for (Map.Entry<InPlayerBlockPos, BlockInPlayer2> entry : pl.getBlocksData2().entrySet()) {
            InPlayerBlockPos pos = entry.getKey();
            posestack.pushPose();
            posestack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            this.renderBlockEntity(entry.getValue(), player, partialticks, posestack, buffer, this.getRenderLight(player, this.getPosForOffset(entry.getValue())), pl);
            posestack.popPose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBlockEntity(BlockInPlayer2 data, AbstractClientPlayer player, float partialticks, PoseStack posestack, MultiBufferSource buffer, int light, PlayerAccessor pl) {
        BlockEntity blockEntity = data.getBlockEntity();
        if (blockEntity != null) {
            posestack.pushPose();
            try {
                BlockEntityRenderer renderer = this.blockEntityRenderDispatcher.getRenderer(blockEntity);
                if (renderer != null) {
                    MultiBufferSource src = buffer;
                    int k = this.getBrakeProgress(pl, blockEntity.getBlockPos());
                    if (k > -1 && k < 10) {
                        PoseStack.Pose posestack$pose = posestack.last();
                        SheetedDecalTextureGenerator vertexconsumer = new SheetedDecalTextureGenerator(this.crumblBuffer.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(k)), posestack$pose, 1.0f);
                        src = arg_0 -> MorphedPlayerRenderer.lambda$renderBlockEntity$0(buffer, (VertexConsumer)vertexconsumer, arg_0);
                    }
                    ClientLevelAccessor acc = ClientLevelAccessor.of(blockEntity.getLevel());
                    acc.setSpecialRenderingMode(true);
                    renderer.render(blockEntity, partialticks, posestack, src, light, OverlayTexture.NO_OVERLAY);
                    acc.setSpecialRenderingMode(false);
                }
            }
            catch (Exception exception) {
            }
            finally {
                posestack.popPose();
            }
        }
    }

    private int getRenderLight(AbstractClientPlayer entity, BlockPos blockPos) {
        Level lv = entity.level();
        return LightTexture.pack((int)lv.getBrightness(LightLayer.BLOCK, blockPos), (int)lv.getBrightness(LightLayer.SKY, blockPos));
    }

    private void renderBreak(AbstractClientPlayer player, PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        for (BlockInPlayer2 block : pl.getBlocksData2().values()) {
            BlockState state = block.getBlockState();
            if (state.getRenderShape() != RenderShape.MODEL) continue;
            int k = this.getBrakeProgress(pl, block.getPos());
            posestack.pushPose();
            InPlayerBlockPos offset = block.getOffset();
            posestack.translate((float)offset.getX(), (float)offset.getY(), (float)offset.getZ());
            this.renderBreak(k, state, player, posestack, buffer, block.getModelData(), block);
            posestack.popPose();
        }
    }

    private int getBrakeProgress(PlayerAccessor pl, BlockPos bounded) {
        if (Config.getInstance().getValue("hitReaction", Config.HitReaction.class) != Config.HitReaction.BRAKING) {
            Player player = pl.player();
            float percentage = player.getHealth() / player.getMaxHealth();
            if ((double)percentage < 0.03) {
                return 9;
            }
            int k = Mth.ceil((float)(percentage * 10.0f));
            return 9 - k;
        }
        return MorphedPlayerRenderer.getBrakeProgress(bounded);
    }

    public static int getBrakeProgress(BlockPos bounded) {
        BlockDestructionProgress progress;
        LevelRendererAccessor acc = LevelRendererAccessor.of(Minecraft.getInstance().levelRenderer);
        SortedSet pos = (SortedSet)acc.getBrakingBlocks().get(bounded.asLong());
        if (pos != null && (progress = (BlockDestructionProgress)pos.last()) != null) {
            return progress.getProgress();
        }
        return -1;
    }

    private void renderBreak(int k, BlockState blockstate, AbstractClientPlayer player, PoseStack posestack, MultiBufferSource buffer, ModelData data, BlockInPlayer2 block) {
        posestack.pushPose();
        PoseStack.Pose posestack$pose1 = posestack.last();
        if (k > -1 && k < 10) {
            SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(this.crumblBuffer.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(k)), posestack$pose1, 1.0f);
            BlockPos offset = this.getPosForOffset(block);
            this.blockRenderDispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)player.level(), this.blockRenderDispatcher.getBlockModel(blockstate), blockstate, offset, posestack, (VertexConsumer)vertexconsumer1, false, this.RANDOM, blockstate.getSeed(offset), OverlayTexture.NO_OVERLAY, data, null);
        }
        posestack.popPose();
    }

    private void renderFrame(PoseStack posestack, MultiBufferSource buffer, PlayerAccessor pl) {
        MorphedPlayerHitResult hit = this.shouldRenderFrame(pl);
        if (hit != null) {
            posestack.pushPose();
            VoxelShape shape = pl.getRenderShape(hit.getOffset(), (Player)this.mc.player);
            if (shape == null) {
                posestack.popPose();
                return;
            }
            LevelRendererAccessor.of(this.mc.levelRenderer).renderBlockHitbox(posestack, buffer.getBuffer(RenderType.lines()), shape, 0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, 0.4f);
            posestack.popPose();
        }
    }

    private MorphedPlayerHitResult shouldRenderFrame(PlayerAccessor pl) {
        HitResult hitResult = this.mc.hitResult;
        if (hitResult instanceof MorphedPlayerHitResult) {
            MorphedPlayerHitResult hit = (MorphedPlayerHitResult)hitResult;
            if (!this.mc.options.hideGui && hit.getPlayer() == pl) {
                if (this.mc.player.isSpectator()) {
                    return MorphUtils.canOpenMenuIn(hit.getPlayer(), hit.getOffset()) ? hit : null;
                }
                if (this.mc.gameMode.getPlayerMode() == GameType.ADVENTURE) {
                    return MorphUtils.isAdventureCanBreak(hit.getPlayer(), (Player)this.mc.player, hit.getOffset()) ? hit : null;
                }
                return hit;
            }
        }
        return null;
    }

    private static /* synthetic */ VertexConsumer lambda$renderBlockEntity$0(MultiBufferSource buffer, VertexConsumer vertexconsumer, RenderType p_234298_) {
        VertexConsumer vertexconsumer2 = buffer.getBuffer(p_234298_);
        return p_234298_.affectsCrumbling() ? VertexMultiConsumer.create((VertexConsumer)vertexconsumer, (VertexConsumer)vertexconsumer2) : vertexconsumer2;
    }
}

