/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import net.blockomorph.utils.PlayerAccessor;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MovementCalculator {
    private final Player player;
    private final PlayerAccessor pl;
    private final Level level;
    private final Direction lookDirection;
    private final boolean error;

    public MovementCalculator(PlayerAccessor playerAccessor) {
        this.player = (Player)playerAccessor;
        this.level = this.player.level();
        this.lookDirection = this.player.getDirection();
        this.error = this.lookDirection == Direction.DOWN || this.lookDirection == Direction.UP;
        this.pl = playerAccessor;
    }

    public void calculateEnterCorrection(Vec3 originalMovement) {
        double d0 = 1.0100000000000002E-5;
        if (this.error || originalMovement.x == 0.0 && originalMovement.z == 0.0) {
            return;
        }
        AABB main = null;
        Vec3 movement = new Vec3(d0 * (double)this.lookDirection.getStepX(), 0.0, d0 * (double)this.lookDirection.getStepZ());
        for (VoxelShape shp : this.level.getCollisions((Entity)this.player, this.player.getBoundingBox().move(movement))) {
            for (AABB aabb : shp.toAabbs()) {
                if (!this.player.getBoundingBox().move(movement).intersects(aabb) || main != null && !this.isCloser(aabb, main, originalMovement)) continue;
                main = aabb;
            }
        }
        if (main == null) {
            return;
        }
        Vec3 offset = this.getHitBoxOffset(main, originalMovement);
        if (this.level.noCollision((Entity)this.player, this.player.getBoundingBox().move(offset).move(movement)) && this.isGoodPath(main, originalMovement)) {
            this.player.setPos(offset.x + this.player.getX(), this.player.getY(), offset.z + this.player.getZ());
        }
    }

    private boolean isGoodPath(AABB b, Vec3 m) {
        Direction dir = this.lookDirection;
        AABB playerBox = this.player.getBoundingBox();
        if (dir == Direction.NORTH) {
            if (m.x > 0.0) {
                return playerBox.minX + m.x > b.maxX;
            }
            return playerBox.maxX + m.x < b.minX;
        }
        if (dir == Direction.SOUTH) {
            if (m.x < 0.0) {
                return playerBox.maxX + m.x < b.minX;
            }
            return playerBox.minX + m.x > b.maxX;
        }
        if (dir == Direction.WEST) {
            if (m.z > 0.0) {
                return playerBox.minZ + m.z > b.maxZ;
            }
            return playerBox.maxZ + m.z < b.minZ;
        }
        if (dir == Direction.EAST) {
            if (m.z < 0.0) {
                return playerBox.maxZ + m.z < b.minZ;
            }
            return playerBox.minZ + m.z > b.maxZ;
        }
        throw new IllegalArgumentException("Wrong side: " + String.valueOf(dir));
    }

    private boolean isCloser(AABB a, AABB b, Vec3 m) {
        Direction dir = this.lookDirection;
        boolean flag = false;
        if (dir == Direction.NORTH) {
            boolean bl = flag = a.maxX < b.maxX;
            if (m.x > 0.0) {
                flag = !flag;
            }
        } else if (dir == Direction.SOUTH) {
            boolean bl = flag = a.minX > b.minX;
            if (m.x < 0.0) {
                flag = !flag;
            }
        } else if (dir == Direction.WEST) {
            boolean bl = flag = a.maxZ < b.maxZ;
            if (m.z > 0.0) {
                flag = !flag;
            }
        } else if (dir == Direction.EAST) {
            boolean bl = flag = a.minZ > b.minZ;
            if (m.z < 0.0) {
                flag = !flag;
            }
        }
        return flag;
    }

    private Vec3 getHitBoxOffset(AABB main, Vec3 m) {
        Direction dir = this.lookDirection;
        AABB playerBox = this.player.getBoundingBox();
        if (dir == Direction.NORTH) {
            if (m.x > 0.0) {
                return new Vec3(main.maxX - playerBox.minX, 0.0, 0.0);
            }
            return new Vec3(main.minX - playerBox.maxX, 0.0, 0.0);
        }
        if (dir == Direction.SOUTH) {
            if (m.x < 0.0) {
                return new Vec3(main.minX - playerBox.maxX, 0.0, 0.0);
            }
            return new Vec3(main.maxX - playerBox.minX, 0.0, 0.0);
        }
        if (dir == Direction.WEST) {
            if (m.z > 0.0) {
                return new Vec3(0.0, 0.0, main.maxZ - playerBox.minZ);
            }
            return new Vec3(0.0, 0.0, main.minZ - playerBox.maxZ);
        }
        if (dir == Direction.EAST) {
            if (m.z < 0.0) {
                return new Vec3(0.0, 0.0, main.minZ - playerBox.maxZ);
            }
            return new Vec3(0.0, 0.0, main.maxZ - playerBox.minZ);
        }
        throw new IllegalArgumentException("Wrong side: " + String.valueOf(dir));
    }
}

