/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.List;
import java.util.Map;
import net.blockomorph.network.ClientBoundMorphUpdatePacket;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.HitBoxCalculator;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.tnt.TntHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.Nullable;

public interface PlayerAccessor {
    public BannedBlock applyBlockMorph(BlockState var1, CompoundTag var2, BannedBlock.Source var3);

    public void sendAllContentToPlayer(ServerPlayer var1);

    public boolean isActive();

    public boolean isFullActive();

    public VoxelShape getShape(InPlayerBlockPos var1, @Nullable Vec3 var2);

    public VoxelShape getRenderShape(InPlayerBlockPos var1, Player var2);

    public int getBiggestProgress();

    public InPlayerBlockPos minPos();

    public InPlayerBlockPos maxPos();

    public PrimedTnt getTnt();

    public TntHandler getTntHandler();

    public HitBoxCalculator getHitBoxHandler();

    public void setTnt();

    public BlockState getBlockState(InPlayerBlockPos var1);

    public boolean setBlockState(InPlayerBlockPos var1, BlockState var2, boolean var3);

    public BlockEntity getBlockEntity(InPlayerBlockPos var1);

    public CompoundTag getTag(InPlayerBlockPos var1);

    public void loadBlockData(CompoundTag var1, @Nullable ClientBoundMorphUpdatePacket var2, boolean var3);

    public Map<InPlayerBlockPos, BlockInPlayer2> getBlocksData2();

    public void getBlocksData2InArea(AABB var1, TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3> var2);

    public CompoundTag saveBlockData(boolean var1);

    public void prepareSync(InPlayerBlockPos var1);

    public void prepareSync(InPlayerBlockPos var1, BlockEventData var2);

    public void sendNearby(Packet<?> var1);

    public boolean isOnLoadingBlocks();

    public void setOnLoadingBlocks(boolean var1);

    public void breakingModeStart(boolean var1);

    public boolean isBreaking();

    public boolean isUnContextedBreaking();

    public List<InPlayerBlockPos> getUpdates();

    default public Player player() {
        return (Player)this;
    }

    public static PlayerAccessor of(Player pl) {
        return (PlayerAccessor)pl;
    }
}

