/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.blockomorph.command.EnumArgument;
import net.blockomorph.screens.config.ConfigRenderer;
import net.blockomorph.screens.config.renderers.EnumConfigRenderer;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class EnumConfig<T extends Enum<T>>
extends ConfigInstance<T> {
    private static EnumConfigRenderer RENDERER;
    private final Class<T> classType;

    public EnumConfig(String name, T initialValue, boolean canOperatorModify, @Nullable Component tip) {
        super(name, initialValue, canOperatorModify, tip);
        this.classType = ((Enum)this.value).getDeclaringClass();
    }

    public Class<T> getEnumClass() {
        return this.classType;
    }

    @Override
    public void readFromStorage(JsonElement option) {
        this.parseFromUser(option.getAsString());
    }

    @Override
    public JsonElement getDataForStorage() {
        return new JsonPrimitive(((Enum)this.value).name());
    }

    @Override
    public void parseFromUser(String input) {
        try {
            this.value = Enum.valueOf(this.classType, input);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid option value for option: " + this.getName() + ", value: " + input);
        }
    }

    @Override
    public void readFromNetwork(FriendlyByteBuf buf) {
        this.value = buf.readEnum(this.classType);
    }

    @Override
    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.value);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> buildArgument(LiteralArgumentBuilder<CommandSourceStack> optionNameArgument, CommandBuildContext context, Commands.CommandSelection environment) {
        return (LiteralArgumentBuilder)optionNameArgument.then(Commands.argument((String)"value", EnumArgument.enumArg(this.classType)).executes(args -> {
            this.value = EnumArgument.getEnum((CommandContext<CommandSourceStack>)args, "value", this.classType);
            Config.getInstance().writeAndSend();
            ((CommandSourceStack)args.getSource()).sendSuccess(() -> Component.translatable((String)"blockomorph.commands.option_change.default", (Object[])new Object[]{this.name, ((Enum)this.value).toString()}), true);
            return 1;
        }));
    }

    @Override
    public ConfigRenderer<?> getRenderer() {
        if (RENDERER == null) {
            RENDERER = new EnumConfigRenderer();
        }
        return RENDERER;
    }
}

