/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import net.blockomorph.network.ClientBoundBlockPosBoundPacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.PlayerMorphedSection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class BlockPosBounds {
    private static File FILE;
    public static final int MAX_PLAYER_CHUNKS = 1875000;
    private static final RandomSource random;
    public static final HashMap<PlayerMorphedSection, Player> CACHE;
    public static final HashMap<PlayerMorphedSection, Player> CLIENT_CACHE;
    private static final HashMap<UUID, PlayerMorphedSection> BOUNDS;
    private static final HashMap<UUID, PlayerMorphedSection> CLIENT_BOUNDS;

    public static void boundPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            UUID uuid = player.getUUID();
            if (!BOUNDS.containsKey(uuid)) {
                PlayerMorphedSection pos = BlockPosBounds.getChunkPos();
                BOUNDS.put(uuid, pos);
                BlockPosBounds.save();
            }
            CACHE.put(BOUNDS.get(uuid), player);
        }
    }

    private static PlayerMorphedSection getChunkPos() {
        int z;
        int x;
        PlayerMorphedSection pos;
        while (BOUNDS.containsValue(pos = new PlayerMorphedSection(x = random.nextInt(1875000), z = random.nextInt(1875000)))) {
        }
        return pos;
    }

    @Nullable
    public static PlayerMorphedSection getChunkPosForPlayer(Player player) {
        if (player.level().isClientSide) {
            return CLIENT_BOUNDS.get(player.getUUID());
        }
        return BOUNDS.get(player.getUUID());
    }

    public static PlayerMorphedSection getPlayerSectionPos(BlockPos bounded) {
        int blockZ = bounded.getZ();
        int blockX = bounded.getX();
        int shiftedZ = blockZ;
        int shiftedX = blockX - 60000000;
        int sectorZ = shiftedZ / 32;
        int sectorX = shiftedX / 32;
        return new PlayerMorphedSection(sectorX, sectorZ);
    }

    @Nullable
    public static Player getPlayerByChunkPos(PlayerMorphedSection pos, @Nullable Boolean client) {
        HashMap<PlayerMorphedSection, Player> cash = client != null ? (client != false ? CLIENT_CACHE : CACHE) : (Config.getServer() == null ? CLIENT_CACHE : CACHE);
        Player pl = cash.get(pos);
        if (pl == null) {
            return null;
        }
        if (pl.isRemoved()) {
            cash.remove(pos);
            pl = null;
        }
        return pl;
    }

    private static void initFile() {
        if (Config.getServer() != null) {
            FILE = new File(Config.getServer().getWorldPath(new LevelResource("data")).toFile(), "blockomorph.dat");
        }
    }

    public static void load() {
        CompoundTag tg;
        BlockPosBounds.initFile();
        if (FILE == null || !FILE.exists()) {
            return;
        }
        try {
            tg = NbtIo.readCompressed((Path)FILE.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (IOException ex) {
            MorphUtils.LOGGER.error("Unable to read PLAYER-BLOCKPOS mappings.", (Throwable)ex);
            return;
        }
        for (String key : tg.getAllKeys()) {
            BOUNDS.put(UUID.fromString(key), new PlayerMorphedSection(tg.getLong(key)));
        }
    }

    private static void save() {
        if (FILE == null) {
            return;
        }
        CompoundTag tg = new CompoundTag();
        BOUNDS.forEach((uuid, chunkPos) -> tg.putLong(uuid.toString(), chunkPos.toLong()));
        try {
            NbtIo.writeCompressed((CompoundTag)tg, (Path)FILE.toPath());
        }
        catch (IOException ex) {
            MorphUtils.LOGGER.error("Unable to save PLAYER-BLOCKPOS mappings.", (Throwable)ex);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        MinecraftServer sv = event.getLevel().getServer();
        if (sv != null && !sv.isDedicatedServer()) {
            BOUNDS.clear();
            CACHE.clear();
            Config.setServer(null);
        }
        CLIENT_BOUNDS.clear();
        CLIENT_CACHE.clear();
    }

    public static void onJoin(Player entity) {
        BlockPosBounds.boundPlayer(entity);
        PlayerMorphedSection pos = BlockPosBounds.getChunkPosForPlayer(entity);
        if (pos != null) {
            MorphUtils.sendPlayer(new ClientBoundBlockPosBoundPacket(pos, entity, false), (ServerPlayer)entity);
        }
    }

    public static void handleBlockPosBound(ClientBoundBlockPosBoundPacket packet) {
        if (packet.delete) {
            Player old = CLIENT_CACHE.remove(packet.pos);
            if (old != null) {
                CLIENT_BOUNDS.remove(old.getUUID());
            }
        } else {
            Player pl = packet.getPlayer();
            if (pl != null) {
                CLIENT_BOUNDS.put(pl.getUUID(), packet.pos);
                CLIENT_CACHE.put(packet.pos, pl);
            }
        }
    }

    static {
        random = RandomSource.create();
        CACHE = new HashMap();
        CLIENT_CACHE = new HashMap();
        BOUNDS = new HashMap();
        CLIENT_BOUNDS = new HashMap();
    }
}

