/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.hit;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.ClipContextAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriConsumer;

public class PlayerHitResult {
    public static final Predicate<Entity> NOT_MORPHED_PLAYER = entity -> {
        PlayerAccessor pl;
        return !(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive();
    };
    private static final AABB CUBE = Shapes.block().bounds();

    @Nullable
    public static MorphedPlayerHitResult calculateMorphedPlayerHitResult(Level lv, @Nullable Entity looker, Vec3 eyePosition, Vec3 reachVector, ClipContext.Block mode, ClipContext.Fluid fluidMode) {
        AABB areaBetweenAndReachEnd = new AABB(eyePosition, reachVector);
        List entities = lv.getEntities(looker, areaBetweenAndReachEnd);
        AtomicReference result = new AtomicReference();
        AtomicReference<Double> distanceToPartOfBlock = new AtomicReference<Double>((Double)Double.MAX_VALUE);
        for (Entity entity : entities) {
            PlayerAccessor mob;
            if (!(entity instanceof PlayerAccessor) || !(mob = (PlayerAccessor)entity).isFullActive()) continue;
            mob.getBlocksData2InArea(areaBetweenAndReachEnd, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, Vec3>)((TriConsumer)(offset, block, offsetPosInWorld) -> {
                for (AABB partBlockShape : PlayerHitResult.getBoxesList(lv, offsetPosInWorld, block, mode, fluidMode, looker)) {
                    Vec3 res;
                    double dist;
                    Optional partHitResult = partBlockShape.clip(eyePosition, reachVector);
                    if (!partHitResult.isPresent() || !((dist = eyePosition.distanceTo(res = (Vec3)partHitResult.get())) < (Double)distanceToPartOfBlock.get()) && !PlayerHitResult.isMainBlock((MorphedPlayerHitResult)((Object)((Object)result.get())), res, offsetPosInWorld)) continue;
                    distanceToPartOfBlock.set(dist);
                    Direction dir = PlayerHitResult.calculateHitDirection(res, partBlockShape);
                    if (dir == null) continue;
                    Vec3 inBlockOffset = new Vec3(res.x() - offsetPosInWorld.x, res.y() - offsetPosInWorld.y, res.z() - offsetPosInWorld.z);
                    result.set(MorphedPlayerHitResult.of(mob, offset, dir, inBlockOffset.x == (double)((int)inBlockOffset.x) || inBlockOffset.y == (double)((int)inBlockOffset.y) || inBlockOffset.z == (double)((int)inBlockOffset.z), inBlockOffset, res));
                }
            }));
        }
        return (MorphedPlayerHitResult)((Object)result.get());
    }

    private static List<AABB> getBoxesList(Level lv, Vec3 offsetPosInWorld, BlockInPlayer2 block, ClipContext.Block mode, ClipContext.Fluid fluidMode, @Nullable Entity looker) {
        VoxelShape blockShape = mode.get(block.getBlockState(), (BlockGetter)lv, block.getPos(), looker != null ? CollisionContext.of((Entity)looker) : CollisionContext.empty());
        blockShape = blockShape.move(offsetPosInWorld.x, offsetPosInWorld.y, offsetPosInWorld.z);
        ArrayList<AABB> boxes = new ArrayList<AABB>(blockShape.toAabbs());
        FluidState fluidState = block.getBlockState().getFluidState();
        if (block.shouldDoFluidAction() && fluidMode.canPick(fluidState)) {
            VoxelShape fluidShape = fluidState.getShape((BlockGetter)lv, block.getPos());
            fluidShape = fluidShape.move(offsetPosInWorld.x, offsetPosInWorld.y, offsetPosInWorld.z);
            boxes.addAll(fluidShape.toAabbs());
        }
        return boxes;
    }

    private static boolean isMainBlock(MorphedPlayerHitResult oldHit, Vec3 newVec, Vec3 newBlockOffsetInWorld) {
        return oldHit != null && oldHit.getRealLocation().equals((Object)newVec) && PlayerHitResult.containsAABB(CUBE.move(newBlockOffsetInWorld), newVec);
    }

    private static Direction calculateHitDirection(Vec3 hitVec, AABB boundingBox) {
        double xDist = Math.min(Math.abs(hitVec.x - boundingBox.minX), Math.abs(hitVec.x - boundingBox.maxX));
        double yDist = Math.min(Math.abs(hitVec.y - boundingBox.minY), Math.abs(hitVec.y - boundingBox.maxY));
        double zDist = Math.min(Math.abs(hitVec.z - boundingBox.minZ), Math.abs(hitVec.z - boundingBox.maxZ));
        if (xDist < yDist && xDist < zDist) {
            return hitVec.x < boundingBox.getCenter().x ? Direction.WEST : Direction.EAST;
        }
        if (yDist < xDist && yDist < zDist) {
            return hitVec.y < boundingBox.getCenter().y ? Direction.DOWN : Direction.UP;
        }
        return hitVec.z < boundingBox.getCenter().z ? Direction.NORTH : Direction.SOUTH;
    }

    private static boolean containsAABB(AABB ab, Vec3 tr) {
        double tolerance = 1.0E-7;
        double d = tr.x;
        double e = tr.y;
        double f = tr.z;
        return d >= ab.minX - tolerance && d <= ab.maxX + tolerance && e >= ab.minY - tolerance && e <= ab.maxY + tolerance && f >= ab.minZ - tolerance && f <= ab.maxZ + tolerance;
    }

    public static void checkHitResult(Vec3 oldHitPos, ClipContext ctx, Consumer<MorphedPlayerHitResult> ifGood) {
        EntityCollisionContext context;
        Entity looker;
        CollisionContext collisionContext = ClipContextAccessor.of(ctx).getContext();
        if (collisionContext instanceof EntityCollisionContext && (looker = (context = (EntityCollisionContext)collisionContext).getEntity()) != null) {
            Vec3 start = ctx.getFrom();
            MorphedPlayerHitResult hit = PlayerHitResult.calculateMorphedPlayerHitResult(looker.level(), looker, start, ctx.getTo(), ClipContextAccessor.of(ctx).getMode(), ClipContextAccessor.of(ctx).getFluidMode());
            if (hit != null && start.distanceTo(hit.getRealLocation()) < start.distanceTo(oldHitPos)) {
                ifGood.accept(hit);
            }
        }
    }
}

