/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.List;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphedBlockEntityProblemReporter;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.SavedBlock;
import net.blockomorph.utils.accessors.BlockAccessor;
import net.blockomorph.utils.config.Config;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class BlockmorphCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blockmorph").requires(s -> s.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(arguments -> {
            SavedBlock block = BlockmorphCommand.getBlockForPos((CommandContext<class_2168>)arguments);
            return BlockmorphCommand.morphMany((class_2168)arguments.getSource(), block.getState(), class_2186.method_9312((CommandContext)arguments, (String)"targets"), block.getTag());
        }))).executes(arguments -> {
            SavedBlock block = BlockmorphCommand.getBlockForPos((CommandContext<class_2168>)arguments);
            return BlockmorphCommand.morphSingle((class_2168)arguments.getSource(), block.getState(), ((class_2168)arguments.getSource()).method_9207(), block.getTag());
        }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(arguments -> BlockmorphCommand.morphMany((class_2168)arguments.getSource(), class_2257.method_9655((CommandContext)arguments, (String)"block").method_9494(), class_2186.method_9312((CommandContext)arguments, (String)"targets"), BlockAccessor.of(class_2257.method_9655((CommandContext)arguments, (String)"block")).getTag())))).executes(arguments -> BlockmorphCommand.morphSingle((class_2168)arguments.getSource(), class_2257.method_9655((CommandContext)arguments, (String)"block").method_9494(), ((class_2168)arguments.getSource()).method_9207(), BlockAccessor.of(class_2257.method_9655((CommandContext)arguments, (String)"block")).getTag()))));
    }

    private static SavedBlock getBlockForPos(CommandContext<class_2168> arguments) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_9696(arguments, (String)"pos");
        class_3218 level = ((class_2168)arguments.getSource()).method_9225();
        class_2680 blockState = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        class_2487 tag = null;
        if (blockEntity != null) {
            MorphedBlockEntityProblemReporter problemReporter = new MorphedBlockEntityProblemReporter(20, 1000);
            class_11362 output = class_11362.method_71459((class_8942)problemReporter, (class_7225.class_7874)level.method_30349());
            blockEntity.method_71400((class_11372)output);
            tag = output.method_71475();
            List<String> problems = problemReporter.getProblemsIfNotEmpty();
            if (problems != null) {
                problems.forEach(problem -> ((class_2168)arguments.getSource()).method_9213((class_2561)class_2561.method_43470((String)problem)));
            }
        }
        return new SavedBlock(blockState, tag, null);
    }

    private static int morphMany(class_2168 stack, class_2680 blockstate, Collection<class_3222> players, class_2487 tag) throws CommandSyntaxException {
        if (BlockmorphCommand.checkConfig(stack)) {
            return 0;
        }
        BannedBlock global = BannedBlock.isBannedBlock(blockstate, null, BannedBlock.Source.COMMAND);
        if (global != null) {
            stack.method_9213(global.text());
            return 0;
        }
        int success = 0;
        for (class_3222 entity : players) {
            PlayerAccessor pl;
            BannedBlock reason;
            if (!(entity instanceof PlayerAccessor) || (reason = (pl = (PlayerAccessor)entity).applyBlockMorph(blockstate, tag, BannedBlock.Source.COMMAND)) != null) continue;
            ++success;
        }
        if (success == 0) {
            throw class_2186.field_9856.create();
        }
        int result = success;
        stack.method_9226(() -> class_2561.method_43469((String)"blockomorph.morphCommand.many", (Object[])new Object[]{result, blockstate.method_26204().method_9518()}), true);
        return players.size();
    }

    private static int morphSingle(class_2168 stack, class_2680 blockstate, class_3222 player, class_2487 tag) {
        if (BlockmorphCommand.checkConfig(stack)) {
            return 0;
        }
        BannedBlock reason = PlayerAccessor.of((class_1657)player).applyBlockMorph(blockstate, tag, BannedBlock.Source.COMMAND);
        if (reason != null) {
            stack.method_9213(reason.text());
            return 0;
        }
        stack.method_9226(() -> class_2561.method_43469((String)"blockomorph.morphCommand.single", (Object[])new Object[]{blockstate.method_26204().method_9518()}), true);
        return 1;
    }

    private static boolean checkConfig(class_2168 stack) {
        if (Config.getInstance() == null) {
            stack.method_9213((class_2561)class_2561.method_43470((String)"Config not loaded, something works like that... :/"));
            return true;
        }
        return false;
    }
}

