/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.blockomorph.network.ClientBoundApplyBlockMorphPacket;
import net.blockomorph.network.ClientBoundMorphUpdatePacket;
import net.blockomorph.network.ClientBoundServerBlockEntityTagPacket;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.HitBoxCalculator;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.MovementCalculator;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.render.MorphedRenderStateExtractor;
import net.blockomorph.utils.tnt.TntHandler;
import net.minecraft.class_10209;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11890;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1541;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1919;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2623;
import net.minecraft.class_2626;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3726;
import net.minecraft.class_4050;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_11890
implements PlayerAccessor {
    @Shadow
    @Final
    private class_1656 field_7503;
    private final TntHandler TNT_HANDLER = new TntHandler(this);
    private final HitBoxCalculator HITBOX_HANDLER = new HitBoxCalculator(this);
    private final ConcurrentHashMap<InPlayerBlockPos, BlockInPlayer2> blocksData = new ConcurrentHashMap();
    private final Map<InPlayerBlockPos, BlockInPlayer2> unmodifiableBlocksData = Collections.unmodifiableMap(this.blocksData);
    private final List<InPlayerBlockPos> updates = new CopyOnWriteArrayList<InPlayerBlockPos>();
    private final ConcurrentHashMap<InPlayerBlockPos, class_1919> blocksEventsToTick = new ConcurrentHashMap();
    private boolean onLoadingBlocks;
    private boolean breakingMode;
    private boolean unContextedBreakingMode;

    @Shadow
    protected abstract boolean method_52558(class_4050 var1);

    @Override
    public boolean setBlockState(InPlayerBlockPos pos, class_2680 state, int flags) {
        if (state.method_26204() == class_2246.field_10124 && this.isBreaking() && InPlayerBlockPos.ZERO.equals(pos)) {
            this.setBlockState(pos, class_2246.field_10243.method_9564(), flags);
        } else {
            BlockInPlayer2 old;
            if (pos == null || !pos.isValid() || (old = this.blocksData.get(pos)) != null && old.getBlockState() == state) {
                return false;
            }
            if (state.method_26204() == class_2246.field_10124) {
                BlockInPlayer2 block = this.blocksData.get(pos);
                if (block != null) {
                    block.changeBlockState(state, flags);
                }
                this.blocksData.remove(pos);
            } else if (this.blocksData.containsKey(pos)) {
                this.blocksData.get(pos).changeBlockState(state, flags);
            } else {
                BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
                block.checkUpdates(flags, class_2246.field_10124.method_9564());
                block.onPlace(state, class_2246.field_10124.method_9564(), flags);
            }
        }
        this.HITBOX_HANDLER.recalculatePositions();
        this.method_18382();
        return true;
    }

    @Override
    @Nullable
    public class_2586 getBlockEntity(InPlayerBlockPos pos) {
        if (this.blocksData == null) {
            return null;
        }
        BlockInPlayer2 bl = this.blocksData.get(pos);
        if (bl != null) {
            return bl.getBlockEntity();
        }
        return null;
    }

    @Override
    public class_2487 getTag(InPlayerBlockPos pos) {
        BlockInPlayer2 ent = this.blocksData.get(pos);
        if (ent != null && ent.getBlockEntity() != null) {
            return ent.getBlockEntity().method_38244((class_7225.class_7874)this.method_73183().method_30349());
        }
        return new class_2487();
    }

    @Override
    public class_2680 getBlockState(InPlayerBlockPos pos) {
        if (this.blocksData == null) {
            return class_2246.field_10124.method_9564();
        }
        BlockInPlayer2 bl = this.blocksData.get(pos);
        if (bl != null) {
            return bl.getBlockState();
        }
        return class_2246.field_10124.method_9564();
    }

    @Override
    public Map<InPlayerBlockPos, BlockInPlayer2> getBlocksData2() {
        return this.unmodifiableBlocksData;
    }

    @Override
    public void getBlocksData2InArea(class_238 box, TriConsumer<InPlayerBlockPos, BlockInPlayer2, class_243> action) {
        if (action != null && box != null && this.method_5829().method_994(box)) {
            class_243 realPos = MorphUtils.getRealBlockPos((PlayerAccessor)this, InPlayerBlockPos.ZERO);
            int minX = class_3532.method_15357((double)(box.field_1323 - realPos.field_1352));
            int minY = class_3532.method_15357((double)(box.field_1322 - realPos.field_1351));
            int minZ = class_3532.method_15357((double)(box.field_1321 - realPos.field_1350));
            int maxX = class_3532.method_15357((double)(box.field_1320 - realPos.field_1352));
            int maxY = class_3532.method_15357((double)(box.field_1325 - realPos.field_1351));
            int maxZ = class_3532.method_15357((double)(box.field_1324 - realPos.field_1350));
            for (int x = Math.max(-14, minX); x <= Math.min(14, maxX); ++x) {
                for (int y = Math.max(0, minY); y <= Math.min(30, maxY); ++y) {
                    for (int z = Math.max(-14, minZ); z <= Math.min(14, maxZ); ++z) {
                        InPlayerBlockPos pos = InPlayerBlockPos.get(x, y, z);
                        BlockInPlayer2 block = this.blocksData.get(pos);
                        if (block == null) continue;
                        action.accept((Object)pos, (Object)block, (Object)realPos.method_1019(new class_243((double)x, (double)y, (double)z)));
                    }
                }
            }
        }
    }

    @Override
    public void prepareSync(InPlayerBlockPos pos) {
        if (!this.method_73183().method_8608() && !this.updates.contains(pos)) {
            this.updates.add(pos);
        }
    }

    @Override
    public void prepareSync(InPlayerBlockPos pos, class_1919 data) {
        if (!this.method_73183().method_8608() && !this.blocksEventsToTick.containsKey(pos)) {
            this.blocksEventsToTick.put(pos, data);
        }
    }

    @Override
    public void breakingModeStart(boolean yes) {
        this.unContextedBreakingMode = yes;
        if (Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue() || !yes) {
            this.breakingMode = yes;
        }
    }

    @Override
    public boolean isUnContextedBreaking() {
        return this.unContextedBreakingMode;
    }

    @Override
    public boolean isBreaking() {
        return this.breakingMode;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(class_11368 valueInput, CallbackInfo ci) {
        Optional old = valueInput.method_71426("BlockMorph", class_2487.field_25128);
        if (old.isPresent()) {
            this.oldDataHandle((class_2487)old.get());
        } else {
            Optional data = valueInput.method_71426("BlockoMorph", class_2487.field_25128);
            data.ifPresent(tag -> this.loadBlockData((class_2487)tag, null, true));
        }
    }

    @Override
    public void loadBlockData(class_2487 blockomorph, @Nullable ClientBoundMorphUpdatePacket client, boolean first) {
        if (first) {
            this.blocksData.clear();
        }
        for (String key : blockomorph.method_10541()) {
            InPlayerBlockPos pos = InPlayerBlockPos.parseBlockPos(key);
            if (pos == null) continue;
            class_2487 tg = (class_2487)blockomorph.method_10562(key).orElseThrow();
            class_2680 state = class_2512.method_10681((class_7871)this.method_73183().method_45448(class_7924.field_41254), (class_2487)tg.method_10562("BlockState").orElseGet(class_2487::new));
            class_2487 tags = tg.method_10562("BlockEntityTag").orElseGet(class_2487::new);
            BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
            if (client != null) {
                block.handleClientTag(tags, client);
                continue;
            }
            block.loadNBT(tags);
        }
        this.HITBOX_HANDLER.recalculatePositions();
        this.method_18382();
    }

    @Override
    public class_2487 saveBlockData(boolean client) {
        class_2487 blocks = new class_2487();
        this.blocksData.forEach((pos, data) -> {
            try {
                class_2487 tg = new class_2487();
                tg.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)data.getBlockState()));
                class_2586 ent = data.getBlockEntity();
                class_2487 blockTag = new class_2487();
                if (ent != null) {
                    class_2487 servTag = ent.method_38244((class_7225.class_7874)this.method_73183().method_30349());
                    blockTag = client ? ent.method_16887((class_7225.class_7874)this.method_73183().method_30349()) : servTag;
                }
                tg.method_10566("BlockEntityTag", (class_2520)blockTag);
                blocks.method_10566(pos.string(), (class_2520)tg);
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while saving morphed player data on pos: " + String.valueOf(pos) + " for block: " + String.valueOf(data.getBlockState()) + " on player: " + this.method_5477().getString(), (Throwable)e);
            }
        });
        return blocks;
    }

    @Override
    public boolean isOnLoadingBlocks() {
        return this.onLoadingBlocks;
    }

    @Override
    public void setOnLoadingBlocks(boolean yes) {
        this.onLoadingBlocks = yes;
    }

    private void oldDataHandle(class_2487 tag) {
        if (!this.method_73183().method_8608()) {
            class_2680 state = class_2512.method_10681((class_7871)this.method_73183().method_45448(class_7924.field_41254), (class_2487)tag.method_10562("BlockState").orElseGet(class_2487::new));
            class_2487 tags = tag.method_10562("Tags").orElseGet(class_2487::new);
            InPlayerBlockPos pos = InPlayerBlockPos.ZERO;
            BlockInPlayer2 block = new BlockInPlayer2(this, pos, state, blockInPlayer -> this.blocksData.put(pos, (BlockInPlayer2)blockInPlayer));
            block.loadNBT(tags);
            this.HITBOX_HANDLER.recalculatePositions();
            this.method_18382();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(class_11372 valueOutput, CallbackInfo ci) {
        class_2487 tg = this.saveBlockData(false);
        if (!tg.method_33133()) {
            valueOutput.method_71468("BlockoMorph", class_2487.field_25128, (Object)tg);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void attack(class_1297 entity, CallbackInfo ci) {
        PlayerAccessor pl;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand) {
            return;
        }
        if (entity instanceof PlayerAccessor && (pl = (PlayerAccessor)entity).isActive()) {
            ci.cancel();
        }
    }

    @Inject(method={"updatePlayerPose"}, at={@At(value="HEAD")}, cancellable=true)
    public void updatePose(CallbackInfo ci) {
        this.method_18398().ifPresent(pos -> {
            if (InPlayerBlockPos.isMorphedPlayerX(pos.method_10263()) && !this.method_52558(class_4050.field_18079)) {
                this.method_18380(class_4050.field_18078);
                ci.cancel();
            }
        });
    }

    @Override
    public void sendNearby(class_2596<? super class_2602> packet) {
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 lv = (class_3218)class_19372;
            class_3215 cache = lv.method_14178();
            cache.method_18751((class_1297)this.player(), packet);
        }
    }

    @Override
    public List<InPlayerBlockPos> getUpdates() {
        return Collections.unmodifiableList(this.updates);
    }

    private void runUpdates() {
        if (this.updates.isEmpty()) {
            return;
        }
        this.updates.forEach(realPos -> {
            BlockInPlayer2 block = this.blocksData.get(realPos);
            if (block == null) {
                class_2338 pos = realPos.boundedBlockPos(this.player());
                if (pos != null) {
                    this.sendNearby((class_2596<? super class_2602>)new class_2626(pos, class_2246.field_10124.method_9564()));
                }
            } else {
                this.sendBockData(block);
            }
        });
        this.updates.clear();
    }

    private void sendBockData(BlockInPlayer2 block) {
        this.sendNearby((class_2596<? super class_2602>)new class_2626(block.getPos(), block.getBlockState()));
        class_2586 ent = block.getBlockEntity();
        if (ent != null) {
            try {
                if (ent.method_38235() != null) {
                    this.sendNearby((class_2596<? super class_2602>)ent.method_38235());
                }
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while sending morphed player data on pos: " + String.valueOf(block.getOffset()) + " for block: " + String.valueOf(block.getBlockState()) + " on player: " + this.method_5477().getString(), (Throwable)e);
            }
        }
    }

    private void runUpdatesBlockEvents() {
        if (this.blocksEventsToTick.isEmpty()) {
            return;
        }
        this.blocksEventsToTick.forEach((realPos, data) -> {
            BlockInPlayer2 block = this.blocksData.get(realPos);
            if (block != null) {
                block.getBlockState().method_26177(this.method_73183(), data.comp_60(), data.comp_62(), data.comp_63());
                this.sendNearby((class_2596<? super class_2602>)new class_2623(data.comp_60(), data.comp_61(), data.comp_62(), data.comp_63()));
            }
        });
        this.blocksEventsToTick.clear();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    public void tick(CallbackInfo ci) {
        if (!this.method_73183().method_8608()) {
            this.runUpdates();
            this.runUpdatesBlockEvents();
        }
        if (this.isFullActive()) {
            class_3695 profiler = class_10209.method_64146();
            profiler.method_15396("blockInMorphedPlayerTick");
            for (BlockInPlayer2 block : this.blocksData.values()) {
                block.tick();
            }
            profiler.method_15407();
        }
        this.TNT_HANDLER.tick();
        this.fluidCollisionUpdate();
    }

    private void fluidCollisionUpdate() {
        class_2248 class_22482;
        class_2680 state = this.getBlockState(InPlayerBlockPos.ZERO);
        if (!this.field_7503.field_7479 && (class_22482 = state.method_26204()) instanceof class_2404) {
            class_2404 block = (class_2404)class_22482;
            if (this.method_73183().method_8320(this.method_24515()).method_26204() == block) {
                class_243 movement = this.method_18798();
                this.method_18800(movement.field_1352, Math.min(1.8, movement.field_1351 + 0.3), movement.field_1350);
                this.method_38785();
            }
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void causeFallDamage(double d, float f, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1937 class_19372;
        if (this.isActive() && (class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 lv = (class_3218)class_19372;
            cir.cancel();
            if (!(this.getBlockState(InPlayerBlockPos.ZERO).method_26204() instanceof class_2199)) {
                return;
            }
            int i = class_3532.method_15384((double)(d - 1.0));
            if (i < 0) {
                return;
            }
            Predicate predicate = class_1301.field_6156.and(class_1301.field_6157);
            class_1282 damageSource22 = this.method_48923().method_48810((class_1297)this);
            float h = Math.min(class_3532.method_15375((float)((float)i * 2.0f)), 40);
            this.method_73183().method_8333((class_1297)this, this.method_5829(), predicate).forEach(entity -> entity.method_64397(lv, damageSource22, h));
        }
    }

    @Override
    @Nullable
    public BannedBlock applyBlockMorph(class_2680 state, class_2487 tag, BannedBlock.Source source) {
        InPlayerBlockPos pos2;
        BannedBlock mess = BannedBlock.isBannedBlock(state, this, source);
        if (mess != null) {
            return mess;
        }
        class_2680 old = this.getBlockState(InPlayerBlockPos.ZERO);
        boolean flag = state.equals((Object)old);
        if (tag == null && flag) {
            return BannedBlock.ALREADY_MORPHED;
        }
        MorphUtils.sendPlayer(new ClientBoundApplyBlockMorphPacket(state, this), (class_3222)this.player());
        this.onLoadingBlocks = true;
        for (InPlayerBlockPos pos2 : this.blocksData.keySet()) {
            if (pos2.equals(InPlayerBlockPos.ZERO)) continue;
            this.setBlockState(pos2, class_2246.field_10124.method_9564(), 3);
            this.updates.add(pos2);
        }
        this.setBlockState(InPlayerBlockPos.ZERO, state, 3);
        BlockInPlayer2 block = this.blocksData.get(InPlayerBlockPos.ZERO);
        if (block != null && tag != null) {
            List<String> errs = block.loadNBT(tag);
            class_3222 serverPlayer = (class_3222)this.player();
            if (errs != null) {
                MorphUtils.sendPlayer(ClientBoundServerBlockEntityTagPacket.createForError(errs, true), serverPlayer);
            } else {
                class_2487 newTag = this.getTag(InPlayerBlockPos.ZERO);
                if (!newTag.equals((Object)tag)) {
                    MorphUtils.sendPlayer(ClientBoundServerBlockEntityTagPacket.createForError(List.of(), false), serverPlayer);
                }
            }
        }
        if ((pos2 = InPlayerBlockPos.ZERO.boundedBlockPos(this.player())) != null) {
            state.method_26204().method_9567(this.method_73183(), (class_2338)pos2, state, (class_1309)this, new class_1799((class_1935)state.method_26204().method_8389(), 1));
        }
        this.updates.add(InPlayerBlockPos.ZERO);
        this.runUpdates();
        this.onLoadingBlocks = false;
        if (!this.method_73183().method_8608()) {
            this.TNT_HANDLER.stopRunning();
        }
        return null;
    }

    @Override
    public void sendAllContentToPlayer(class_3222 target) {
        class_2487 blocks = this.saveBlockData(true);
        class_2487 buffer = new class_2487();
        ArrayList<ClientBoundMorphUpdatePacket> packets = new ArrayList<ClientBoundMorphUpdatePacket>();
        boolean first = true;
        for (String key : blocks.method_10541()) {
            class_2487 block = blocks.method_68568(key);
            if (block.method_33133()) continue;
            buffer.method_10566(key, (class_2520)block);
            if (buffer.method_47988() <= 524288) continue;
            buffer.method_10551(key);
            packets.add(new ClientBoundMorphUpdatePacket(this, buffer, first));
            first = false;
            buffer = new class_2487();
            buffer.method_10566(key, (class_2520)block);
        }
        packets.add(new ClientBoundMorphUpdatePacket(this, buffer, first));
        for (ClientBoundMorphUpdatePacket packet : packets) {
            MorphUtils.sendPlayer(packet, target);
        }
    }

    @Override
    public class_1541 getTnt() {
        return this.TNT_HANDLER.getTnt();
    }

    @Override
    public void setTnt() {
        this.TNT_HANDLER.runTnt();
    }

    @Override
    public TntHandler getTntHandler() {
        return this.TNT_HANDLER;
    }

    @Override
    public boolean isActive() {
        return this.getBlockState(InPlayerBlockPos.ZERO).method_26204() != class_2246.field_10124;
    }

    @Override
    public boolean isFullActive() {
        return this.isActive() && this.TNT_HANDLER.getTnt() == null;
    }

    @Override
    public InPlayerBlockPos minPos() {
        return this.HITBOX_HANDLER.getMinPos();
    }

    @Override
    public InPlayerBlockPos maxPos() {
        return this.HITBOX_HANDLER.getMaxPos();
    }

    @Override
    public int getBiggestProgress() {
        if (this.blocksData != null) {
            int progress = -1;
            for (BlockInPlayer2 block : this.blocksData.values()) {
                int k = MorphedRenderStateExtractor.getBrakeProgress(block.getPos());
                if (k <= progress) continue;
                progress = k;
            }
            return progress;
        }
        return -1;
    }

    @Override
    public HitBoxCalculator getHitBoxHandler() {
        return this.HITBOX_HANDLER;
    }

    @Override
    public class_265 getShape(InPlayerBlockPos offset, @Nullable class_243 realPos) {
        BlockInPlayer2 block = this.getBlocksData2().get(offset);
        if (block == null) {
            return class_259.method_1073();
        }
        class_265 shp = block.getBlockState().method_26194((class_1922)this.method_73183(), block.getPos(), class_3726.method_16195((class_1297)this));
        class_243 rl = realPos != null ? realPos : MorphUtils.getRealBlockPos((PlayerAccessor)this, offset);
        return shp.method_1096(rl.field_1352, rl.field_1351, rl.field_1350);
    }

    @Override
    public class_265 getRenderShape(InPlayerBlockPos pos, class_1657 collisser) {
        BlockInPlayer2 block = this.getBlocksData2().get(pos);
        if (block == null) {
            return class_259.method_1073();
        }
        class_2680 state = block.getBlockState();
        class_265 shape = state.method_26172((class_1922)this.method_73183(), block.getPos(), class_3726.method_16195((class_1297)collisser));
        return shape.method_1096((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getDeathSound(CallbackInfoReturnable<class_3414> cir) {
        if (this.isActive()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getHurtSound(class_1282 damage, CallbackInfoReturnable<class_3414> cir) {
        if (this.isActive()) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getFallSounds"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getFallSounds(CallbackInfoReturnable<class_1309.class_6823> cir) {
        if (this.isActive()) {
            cir.setReturnValue((Object)new class_1309.class_6823(class_3417.field_42593, class_3417.field_42593));
        }
    }

    @Inject(method={"maybeBackOffFromEdge"}, at={@At(value="RETURN")}, cancellable=true)
    public void fixMovement(class_243 originalVector, class_1313 moverType, CallbackInfoReturnable<class_243> cir) {
        if (this.isActive() && (moverType == class_1313.field_6305 || moverType == class_1313.field_6308)) {
            MovementCalculator calculator = new MovementCalculator(this);
            calculator.calculateEnterCorrection(originalVector);
        }
    }

    public PlayerMixin() {
        super(null, null);
    }
}

