/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.blockomorph.screens.AbstractScreen;
import net.blockomorph.screens.morph.BlocksManager;
import net.blockomorph.screens.morph.ConfigSyncListener;
import net.blockomorph.screens.morph.TabManager;
import net.blockomorph.screens.morphConfig.MorphConfigScreen;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.SavedBlock;
import net.blockomorph.utils.SavedBlockManager;
import net.minecraft.class_1113;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7706;

public abstract class AbstractMorphScreen
extends AbstractScreen
implements ConfigSyncListener {
    private static final class_2960 SEARCH_BAR = GuiUtils.res("textures/screens/searchbar.png");
    private static final class_2960 MODE_TABS = GuiUtils.res("textures/screens/exit_tabs.png");
    public static final SavedBlockManager SAVED_BLOCK_MANAGER = new SavedBlockManager(MorphUtils.getGameDir());
    protected static final int BLOCK_FRAME_SIZE = 36;
    public final TabManager TAB_MANAGER;
    public final BlocksManager BLOCKS_MANAGER;
    protected PlayerAccessor player;
    protected MorphScreenOptions options;
    protected boolean ignoreSearchBoxInput;

    protected AbstractMorphScreen(MorphScreenOptions options) {
        super("morph_screen", null);
        this.options = options;
        this.player = PlayerAccessor.of((class_1657)GuiUtils.MC.field_1724);
        this.BLOCKS_MANAGER = new BlocksManager(this);
        this.TAB_MANAGER = new TabManager(this, options.useAllowedTab(), options.useSavedBlocksTab());
    }

    protected void setUseUpperTabs(boolean yes) {
        this.options = new MorphScreenOptions(this.options.useAllowedTab, this.options.useSavedBlocksTab, yes);
    }

    protected abstract void initAdditional(Consumer<class_339> var1);

    protected abstract void renderFrame(SavedBlock var1, int var2, int var3);

    protected abstract class_1113 onClickOnBlock(SavedBlock var1, int var2, class_1761 var3, int var4);

    protected void renderTooltip() {
        SavedBlock block = this.BLOCKS_MANAGER.getBlockAtPosition(this.gui.getMouseX(), this.gui.getMouseY());
        if (block != null) {
            class_5250 name = block.getName() == null ? block.getState().method_26204().method_9518() : class_2561.method_43470((String)block.getName());
            this.gui.renderTooltip((class_2561)name, this.gui.getMouseX(), this.gui.getMouseY());
        }
    }

    public void method_25393() {
        this.player = PlayerAccessor.of((class_1657)GuiUtils.MC.field_1724);
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public PlayerAccessor getPlayer() {
        return this.player;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float tick) {
        super.method_25394(guiGraphics, mouseX, mouseY, tick);
        this.renderContent();
        this.renderTooltip();
    }

    private void renderContent() {
        this.TAB_MANAGER.renderTabs(this.gui);
        this.BLOCKS_MANAGER.render(this.gui, this::renderFrame);
    }

    @Override
    public void renderMenu() {
        super.renderMenu();
        if (this.options.useUpperTabs()) {
            this.gui.blit(MODE_TABS, this.leftPos + 4, this.topPos - 19, 0.0f, 0.0f, 80, 22, 80, 46);
        }
        if (this.TAB_MANAGER.hasSearchBar()) {
            this.gui.blitMonoImage(SEARCH_BAR, this.leftPos + 90, this.topPos - 19, 80, 23);
        }
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        double x = mouseButtonEvent.comp_4798();
        double y = mouseButtonEvent.comp_4799();
        int type = mouseButtonEvent.method_74245();
        if (type == 0) {
            if (this.TAB_MANAGER.mouseClicked(x, y)) {
                return true;
            }
            if (this.BLOCKS_MANAGER.mouseClicked(x, y, this::onClickOnBlock)) {
                return true;
            }
            if (this.options.useUpperTabs && x > (double)(this.leftPos + 4) && x < (double)(this.leftPos + 4 + 41) && y > (double)(this.topPos - 19) && y < (double)(this.topPos - 19 + 22)) {
                GuiUtils.MC.method_1507((class_437)new MorphConfigScreen());
                return true;
            }
        }
        return super.method_25402(mouseButtonEvent, doubleClick);
    }

    public boolean method_25403(class_11909 mouseButtonEvent, double mouseXOffset, double mouseYOffset) {
        if (this.BLOCKS_MANAGER.scrollerManager.mouseDragged(mouseButtonEvent.comp_4799())) {
            return true;
        }
        return super.method_25403(mouseButtonEvent, mouseXOffset, mouseYOffset);
    }

    public boolean method_25406(class_11909 mouseButtonEvent) {
        if (mouseButtonEvent.method_74245() == 0) {
            if (this.TAB_MANAGER.mouseClicked(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799())) {
                return true;
            }
            this.BLOCKS_MANAGER.scrollerManager.disableScrollWork();
        }
        return super.method_25406(mouseButtonEvent);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double yScrolled) {
        if (this.BLOCKS_MANAGER.scrollerManager.mouseScrolled(yScrolled)) {
            return true;
        }
        return super.mouseScrolled(x, y, yScrolled);
    }

    public AbstractMorphScreen ignoreInitInput() {
        this.ignoreSearchBoxInput = true;
        return this;
    }

    public boolean method_25400(class_11905 characterEvent) {
        if (this.ignoreSearchBoxInput) {
            this.ignoreSearchBoxInput = false;
            return false;
        }
        if (this.TAB_MANAGER.getSearchBox().method_25400(characterEvent)) {
            return true;
        }
        return super.method_25400(characterEvent);
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == 256) {
            this.method_25419();
        } else if (this.TAB_MANAGER.getSearchBox().method_25404(keyEvent)) {
            return true;
        }
        return super.method_25404(keyEvent);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.initAdditional(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.TAB_MANAGER.init(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        ArrayList<class_1761> tabs = new ArrayList<class_1761>(this.TAB_MANAGER.CONTENT_TABS);
        tabs.addAll(this.TAB_MANAGER.SPECIAL_TABS);
        if (!tabs.contains(TabManager.selectedTab)) {
            TabManager.selectedTab = class_7706.method_47328();
        }
        this.TAB_MANAGER.selectTab(TabManager.getSelectedTab());
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        ScrollerManager<SavedBlock> manager = this.BLOCKS_MANAGER.scrollerManager;
        float scroll = manager.getScrollerOffset();
        String value = this.TAB_MANAGER.getSearchBox().method_1882();
        super.method_25410(minecraft, width, height);
        this.TAB_MANAGER.getSearchBox().method_1852(value);
        this.BLOCKS_MANAGER.searchBlocks(value);
        manager.setScrollOffset(scroll);
        manager.refreshList();
    }

    @Override
    public void onConfigSynced() {
        this.BLOCKS_MANAGER.updateAllowedBlocks();
    }

    public record MorphScreenOptions(boolean useAllowedTab, boolean useSavedBlocksTab, boolean useUpperTabs) {
        public static MorphScreenOptions ALL = new MorphScreenOptions(true, true, true);
        public static MorphScreenOptions CONFIG = new MorphScreenOptions(false, true, false);
        public static MorphScreenOptions OFF = new MorphScreenOptions(false, false, false);
    }

    @FunctionalInterface
    public static interface OnRenderingFrame {
        public void render(SavedBlock var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface OnBlockClick {
        public class_1113 click(SavedBlock var1, int var2, class_1761 var3, int var4);
    }
}

