/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import java.util.List;
import java.util.function.Consumer;
import net.blockomorph.network.ServerBoundBlockMorphPacket;
import net.blockomorph.screens.morph.AbstractMorphScreen;
import net.blockomorph.screens.morph.TabManager;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.SpriteImageButton;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.SavedBlock;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2530;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;

public class MorphScreen
extends AbstractMorphScreen {
    private static final class_2960 UNMORPH_BUTTON_SPRITE = GuiUtils.res("textures/screens/unmorph_but.png");
    private static final class_2960 FUSE_BUTTON_SPRITE = GuiUtils.res("textures/screens/flame_but.png");
    private static final class_2960 LOCK_FRAME = GuiUtils.res("textures/screens/sel_lock.png");
    private static final class_2960 SELECTED_FRAME = GuiUtils.res("textures/screens/selected.png");
    private SpriteImageButton fuseButton;

    public MorphScreen(boolean useAllowTab, boolean useSavedTab) {
        super(new AbstractMorphScreen.MorphScreenOptions(useAllowTab, useSavedTab, false));
    }

    @Override
    protected void initAdditional(Consumer<class_339> action) {
        action.accept((class_339)new SpriteImageButton(this.leftPos + 10, this.topPos + this.imageHeight + 1, 26, 26, UNMORPH_BUTTON_SPRITE, button -> MorphUtils.sendServer(ServerBoundBlockMorphPacket.create(class_2246.field_10124.method_9564(), null)), () -> this.player.isFullActive(), true));
        this.fuseButton = new SpriteImageButton(this.leftPos - 28, this.topPos + this.imageHeight + 1, 26, 26, FUSE_BUTTON_SPRITE, button -> MorphUtils.sendServer(ServerBoundBlockMorphPacket.fuse()), () -> this.player.getTnt() == null, true);
        action.accept((class_339)this.fuseButton);
        this.fuseButtonVisibilityCheck();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.checkSavedTab();
        this.setUseUpperTabs(MorphUtils.getScreenAccess((class_1657)this.player.player()).config);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float tick) {
        super.method_25394(guiGraphics, mouseX, mouseY, tick);
        this.fuseButtonVisibilityCheck();
    }

    private void fuseButtonVisibilityCheck() {
        this.fuseButton.field_22764 = this.player.getBlockState(InPlayerBlockPos.ZERO).method_26204() instanceof class_2530;
    }

    @Nullable
    private BannedBlock isBannedBlock(SavedBlock block) {
        if (!(MorphUtils.getScreenAccess((class_1657)this.player.player()).config || block.getTag() == null && block.getState().method_26204().method_9564().equals((Object)block.getState()))) {
            return new BannedBlock("You cannot morph into configured block!", (class_2561)class_2561.method_43471((String)"blockomorph.bannedBlock.configured"));
        }
        return BannedBlock.isBannedBlock(block.getState(), this.player, BannedBlock.Source.NETWORK);
    }

    @Override
    public void onConfigSynced() {
        super.onConfigSynced();
        this.checkSavedTab();
        this.setUseUpperTabs(MorphUtils.getScreenAccess((class_1657)this.player.player()).config);
    }

    @Override
    public void onOperatorRightsChanged() {
        this.onConfigSynced();
    }

    private void checkSavedTab() {
        if (this.options.useSavedBlocksTab()) {
            class_1761 savedBlocks = TabManager.getTabFromKey((class_5321<class_1761>)class_7706.field_40199);
            if (!MorphUtils.getScreenAccess((class_1657)this.player.player()).config) {
                this.TAB_MANAGER.SPECIAL_TABS.remove(savedBlocks);
                if (TabManager.getSelectedTab() == savedBlocks) {
                    this.TAB_MANAGER.selectTab(class_7706.method_47328());
                }
            } else if (!this.TAB_MANAGER.SPECIAL_TABS.contains(savedBlocks)) {
                this.TAB_MANAGER.SPECIAL_TABS.add(2, savedBlocks);
            }
        }
    }

    @Override
    protected class_1113 onClickOnBlock(SavedBlock block, int number, class_1761 selectedTab, int page) {
        if (this.isBannedBlock(block) == null) {
            MorphUtils.sendServer(ServerBoundBlockMorphPacket.create(block.getState(), block.getTag()));
            return GuiUtils.getClickSound();
        }
        return null;
    }

    @Override
    protected void renderFrame(SavedBlock block, int x, int y) {
        class_2680 state = block.getState();
        BannedBlock ban = this.isBannedBlock(block);
        if (ban != null) {
            this.gui.blitMonoImage(LOCK_FRAME, x, y, 36, 36);
            return;
        }
        class_2680 playerState = this.player.getBlockState(InPlayerBlockPos.ZERO);
        class_2487 tg = this.player.getTag(InPlayerBlockPos.ZERO);
        if (state.equals((Object)playerState) && (block.getTag() == null || tg.equals((Object)block.getTag()))) {
            this.gui.blitMonoImage(SELECTED_FRAME, x, y, 36, 36);
        }
    }

    @Override
    protected void renderTooltip() {
        SavedBlock block = this.BLOCKS_MANAGER.getBlockAtPosition(this.gui.getMouseX(), this.gui.getMouseY());
        if (block != null) {
            BannedBlock ban = this.isBannedBlock(block);
            if (ban != null) {
                class_5250 name = block.getName() == null ? block.getState().method_26204().method_9518() : class_2561.method_43470((String)block.getName());
                List<class_5250> hints = List.of(name, class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + ban.text().getString())));
                this.gui.renderTooltip(hints, this.gui.getMouseX(), this.gui.getMouseY());
            } else {
                super.renderTooltip();
            }
        }
    }
}

