/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.blockomorph.screens.morph.AbstractMorphScreen;
import net.blockomorph.screens.morph.BlocksManager;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ListenerEditBox;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.SavedBlock;
import net.minecraft.class_1124;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class TabManager {
    protected static final class_1761 ALLOWED_TAB = class_1761.method_47307((class_1761.class_7915)class_1761.class_7915.field_41049, (int)0).method_47321((class_2561)class_2561.method_43471((String)"blockomorph.gui.morphScreen.allowed_tab")).method_47320(() -> new class_1799((class_1935)class_1802.field_8137)).method_47324();
    private static final class_2960 TABS_SPRITE = GuiUtils.res("textures/screens/block_selector_tabs.png");
    protected final AbstractMorphScreen parentScreen;
    protected final List<class_1761> CONTENT_TABS;
    protected final List<class_1761> SPECIAL_TABS;
    protected static class_1761 selectedTab = class_7706.method_47328();
    protected static int tabPage = 0;
    protected final int pageCount;
    protected class_342 searchBox;
    protected final boolean needAllowedTab;

    public TabManager(AbstractMorphScreen screen, boolean useAllowedTab, boolean useSavedBlocksTab) {
        this.parentScreen = screen;
        this.needAllowedTab = useAllowedTab;
        AbstractMorphScreen.SAVED_BLOCK_MANAGER.load();
        this.initTabs();
        ArrayList<class_1761> list = new ArrayList<class_1761>();
        list.add(class_7706.method_47344());
        list.add(TabManager.getTabFromKey((class_5321<class_1761>)class_7706.field_41063));
        if (useSavedBlocksTab) {
            list.add(TabManager.getTabFromKey((class_5321<class_1761>)class_7706.field_40199));
        }
        this.SPECIAL_TABS = list;
        this.CONTENT_TABS = screen.BLOCKS_MANAGER.sortTabsIfItemsIsBlocks();
        this.putAllowedTabIfNeed();
        this.pageCount = (int)Math.ceil((double)this.CONTENT_TABS.size() / 10.0);
    }

    public void renderTabs(GuiUtils gui) {
        this.searchBox.field_22764 = this.hasSearchBar();
        this.renderTabsInGui(gui);
        class_1761 tab = this.getTabAtPosition(gui.getMouseX(), gui.getMouseY());
        if (tab != null) {
            gui.renderTooltip(tab.method_7737(), gui.getMouseX(), gui.getMouseY());
        }
        if (selectedTab.method_7754()) {
            gui.drawString(selectedTab.method_7737(), this.parentScreen.getLeftPos() + 8, this.parentScreen.getTopPos() + 6, 0x404040, false);
        }
        if (this.pageCount > 1) {
            class_5250 pageCounter = class_2561.method_43470((String)String.format("%d / %d", tabPage + 1, this.pageCount));
            gui.drawString((class_2561)pageCounter, this.parentScreen.getLeftPos() + this.parentScreen.imageLength / 2 - gui.getFont().method_27525((class_5348)pageCounter) / 2, this.parentScreen.getTopPos() - 34, -1, true);
        }
    }

    public boolean hasSearchBar() {
        return selectedTab == class_7706.method_47344() || selectedTab == ALLOWED_TAB || selectedTab == TabManager.getTabFromKey((class_5321<class_1761>)class_7706.field_40199);
    }

    public class_342 getSearchBox() {
        return this.searchBox;
    }

    public static class_1761 getSelectedTab() {
        return selectedTab;
    }

    public static int getTabPage() {
        return tabPage;
    }

    public void init(Consumer<class_339> action) {
        if (this.pageCount > 1) {
            int leftPos = this.parentScreen.getLeftPos();
            int topPos = this.parentScreen.getTopPos();
            action.accept((class_339)class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), b -> this.setPage(false)).method_46433(leftPos - 22, topPos - 22).method_46437(20, 20).method_46431());
            action.accept((class_339)class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), b -> this.setPage(true)).method_46433(leftPos + this.parentScreen.imageLength, topPos - 22).method_46437(20, 20).method_46431());
        }
        this.searchBox = new ListenerEditBox(this.parentScreen.method_64506(), this.parentScreen.getLeftPos() + 99, this.parentScreen.getTopPos() - 10, 70, 12, (class_2561)class_2561.method_43471((String)"itemGroup.search"), this.parentScreen.BLOCKS_MANAGER::searchBlocks, null);
        this.searchBox.method_1880(Short.MAX_VALUE);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(0xFFFFFF);
        action.accept((class_339)this.searchBox);
    }

    public boolean mouseClicked(double x, double y) {
        class_1761 tab = this.getTabAtPosition(x, y);
        if (tab != null) {
            return this.selectTab(tab);
        }
        return false;
    }

    public boolean selectTab(class_1761 tab) {
        List<SavedBlock> list = BlocksManager.ALL_TAB_CONTENTS.get(TabManager.getKeyFromTab(tab));
        if (list != null) {
            boolean flag;
            class_1761 old = selectedTab;
            selectedTab = tab;
            ScrollerManager<SavedBlock> manager = this.parentScreen.BLOCKS_MANAGER.scrollerManager;
            if (old != tab) {
                manager.setScrollOffset(0.0f);
            }
            manager.setMainList(list);
            manager.refreshList();
            this.searchBox.method_1852("");
            this.searchBox.field_22764 = flag = this.hasSearchBar();
            this.searchBox.method_1856(!flag);
            this.searchBox.method_25365(flag);
            return true;
        }
        return false;
    }

    private void initTabs() {
        class_746 player = (class_746)this.parentScreen.getPlayer();
        if (class_7706.method_47330((class_7699)player.field_3944.method_45735(), (boolean)true, (class_7225.class_7874)player.method_73183().method_30349())) {
            class_1124 sessionSearchTrees = player.field_3944.method_60347();
            List list = List.copyOf(class_7706.method_47344().method_47313());
            sessionSearchTrees.method_60357((class_7225.class_7874)player.method_73183().method_30349(), list);
            sessionSearchTrees.method_60355(list);
        }
    }

    private void setPage(boolean up) {
        tabPage = up ? Math.min(tabPage + 1, this.pageCount - 1) : Math.max(tabPage - 1, 0);
    }

    protected boolean isSelected(boolean special, int i) {
        return (special ? this.SPECIAL_TABS : this.CONTENT_TABS).get(i) == selectedTab;
    }

    protected void putAllowedTabIfNeed() {
        List<SavedBlock> blocks = BlocksManager.ALL_TAB_CONTENTS.get(TabManager.getKeyFromTab(ALLOWED_TAB));
        if (blocks != null) {
            if (!this.needAllowedTab) {
                this.SPECIAL_TABS.remove(ALLOWED_TAB);
            } else {
                List<SavedBlock> filteredBlocks = blocks.stream().filter(savedBlock -> {
                    BannedBlock reason = BannedBlock.isBannedBlock(savedBlock.getState(), this.parentScreen.player, BannedBlock.Source.SYSTEM);
                    return reason == null || reason.systemLock();
                }).toList();
                if (filteredBlocks.size() != BlocksManager.ALL_BLOCKS.size()) {
                    if (!this.SPECIAL_TABS.contains(ALLOWED_TAB)) {
                        this.SPECIAL_TABS.add(ALLOWED_TAB);
                    }
                } else {
                    this.SPECIAL_TABS.remove(ALLOWED_TAB);
                }
            }
        }
    }

    protected void renderTabsInGui(GuiUtils gui) {
        this.renderContentTabs(gui);
        this.renderSpecialTabs(gui);
    }

    protected void renderSpecialTabs(GuiUtils gui) {
        for (int i = 0; i < this.SPECIAL_TABS.size(); ++i) {
            int tabXSpecial = this.parentScreen.getLeftPos() + this.parentScreen.imageLength - 38 - i * 32;
            gui.blit(TABS_SPRITE, tabXSpecial, this.getTabY(-1), this.isSelected(true, i) ? 28.0f : 0.0f, 0.0f, 28, 32, 64, 88);
            this.renderItemInTab(gui, null, i, -1);
        }
    }

    protected void renderContentTabs(GuiUtils gui) {
        int count = 0;
        for (int i = tabPage * 10; i < tabPage * 10 + 10 && i < this.CONTENT_TABS.size(); ++i) {
            boolean isRight = count >= 5;
            int tabXSpecial = this.parentScreen.getLeftPos() + (isRight ? this.parentScreen.imageLength - 4 : -28);
            gui.blit(TABS_SPRITE, tabXSpecial, this.getTabY(count), isRight ? 32.0f : 0.0f, this.isSelected(false, i) ? 60.0f : 32.0f, 32, 28, 64, 88);
            this.renderItemInTab(gui, isRight, i, count);
            ++count;
        }
    }

    protected void renderItemInTab(GuiUtils gui, @Nullable Boolean isRight, int listIndex, int offsetIndex) {
        boolean isDown;
        boolean bl = isDown = isRight == null;
        float tabX = isDown ? (float)(this.parentScreen.getLeftPos() + this.parentScreen.imageLength - 37 - listIndex * 32 + 5) : (float)(this.parentScreen.getLeftPos() + (isRight != false ? this.parentScreen.imageLength + 2 : -19));
        int tabY = this.getTabY(offsetIndex) + (isDown ? 7 : 5);
        class_1799 itemstack = (isDown ? this.SPECIAL_TABS : this.CONTENT_TABS).get(listIndex).method_7747();
        gui.renderItem(itemstack, tabX, tabY, 1.0f, 100.0f);
    }

    protected class_1761 getTabAtPosition(double x, double y) {
        int i;
        int leftPos = this.parentScreen.getLeftPos();
        int imageWidth = this.parentScreen.imageLength;
        int tabYSpecial = this.getTabY(-1);
        for (i = 0; i < this.SPECIAL_TABS.size(); ++i) {
            int tabXSpecial = leftPos + imageWidth - 38 - i * 32;
            if (!(x > (double)tabXSpecial) || !(x < (double)(tabXSpecial + 28)) || !(y > (double)tabYSpecial) || !(y < (double)(tabYSpecial + 32))) continue;
            return this.SPECIAL_TABS.get(i);
        }
        for (i = 0; i < 10; ++i) {
            int tabX = leftPos;
            int tabY = this.getTabY(i);
            tabX = i < 5 ? (tabX -= 28) : (tabX += imageWidth - 4);
            if (!(x > (double)tabX) || !(x < (double)(tabX + 32)) || !(y > (double)tabY) || !(y < (double)(tabY + 28)) || 10 * tabPage + i >= this.CONTENT_TABS.size()) continue;
            return this.CONTENT_TABS.get(10 * tabPage + i);
        }
        return null;
    }

    public static class_1761 getTabFromKey(class_5321<class_1761> name) {
        return (class_1761)class_7923.field_44687.method_31140(name);
    }

    public static class_5321<class_1761> getKeyFromTab(class_1761 tab) {
        if (tab == ALLOWED_TAB) {
            return BlocksManager.ALLOWED_TAB_KEY;
        }
        return (class_5321)class_7923.field_44687.method_29113((Object)tab).orElseThrow();
    }

    protected int getTabY(int i) {
        if (i < 0) {
            return this.parentScreen.getTopPos() + this.parentScreen.imageHeight - 4;
        }
        if (i > 4) {
            i -= 5;
        }
        return this.parentScreen.getTopPos() + 3 + i * 32;
    }
}

