/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig;

import net.blockomorph.network.ServerBoundBlockMorphPacket;
import net.blockomorph.screens.AbstractScreen;
import net.blockomorph.screens.morph.AbstractMorphScreen;
import net.blockomorph.screens.morph.ConfigSyncListener;
import net.blockomorph.screens.morph.MorphScreen;
import net.blockomorph.screens.morphConfig.nbtEditor.PlayerBlockEntityNbtEditor;
import net.blockomorph.screens.morphConfig.propertiesWidget.BlockStatePropsRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ListenerEditBox;
import net.blockomorph.screens.utils.SpriteImageButton;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.SavedBlock;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class MorphConfigScreen
extends AbstractScreen
implements ConfigSyncListener {
    private static final class_2960 EXIT_TABS_SPRITE = GuiUtils.res("textures/screens/exit_tabs.png");
    private static final class_2960 SAVE_BUTTON_SPRITE = GuiUtils.res("textures/screens/save_but.png");
    private static final class_2960 DELETE_BUTTON_SPRITE = GuiUtils.res("textures/screens/edit_bucket.png");
    private static final class_2960 NBT_BUTTON_SPRITE = GuiUtils.res("textures/screens/nbt_but.png");
    private BlockStatePropsRenderer propertiesRenderer;
    protected PlayerAccessor player;
    private class_342 saveBox;
    private SpriteImageButton saveButton;
    private SpriteImageButton deleteButton;
    private boolean needUpperTabs;

    public MorphConfigScreen() {
        super("morph_config_screen", null);
        this.player = PlayerAccessor.of((class_1657)GuiUtils.MC.field_1724);
        AbstractMorphScreen.SAVED_BLOCK_MANAGER.load();
    }

    @Override
    public void onConfigSynced() {
        if (BannedBlock.isBannedBlock(this.getState(), this.player, BannedBlock.Source.NETWORK) != null) {
            this.method_25419();
            return;
        }
        Config.ScreenAccess access = MorphUtils.getScreenAccess(this.player.player());
        if (!access.config) {
            this.method_25419();
        } else {
            this.needUpperTabs = access.morph;
        }
    }

    @Override
    public void onOperatorRightsChanged() {
        this.onConfigSynced();
    }

    public void method_25393() {
        this.player = PlayerAccessor.of((class_1657)GuiUtils.MC.field_1724);
    }

    private class_2680 getState() {
        return this.player.getBlockState(InPlayerBlockPos.ZERO);
    }

    @Nullable
    private class_2586 getBE() {
        return this.player.getBlockEntity(InPlayerBlockPos.ZERO);
    }

    private class_2487 getTag() {
        class_2487 tag = new class_2487();
        if (this.getBE() != null) {
            tag = this.getBE().method_58692((class_7225.class_7874)this.player.player().method_56673());
        }
        return tag;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float tick) {
        super.method_25394(guiGraphics, mouseX, mouseY, tick);
        this.gui.renderBlockInGui(this.getState(), this.getBE(), this.leftPos + 71, this.topPos + 64, 36.0f);
        this.gui.renderAdditionalOnBlock(this.getState(), (float)this.leftPos + 37.5f, (float)this.topPos + 40.5f, 55.0f);
        this.propertiesRenderer.render(this.gui);
        if (GuiUtils.isMouseOver(this.leftPos + 15, this.topPos + 18, this.leftPos + 75, this.topPos + 79, mouseX, mouseY)) {
            this.gui.renderTooltip((class_2561)this.getState().method_26204().method_9518(), mouseX, mouseY);
        }
    }

    private void renderStrings() {
        Object blockName = this.getState().method_26204().method_9518().getString();
        if (this.field_22793.method_1727((String)blockName) > 81) {
            blockName = this.field_22793.method_27523((String)blockName, 77) + "...";
        }
        int color = 0x404040;
        this.gui.drawString((class_2561)class_2561.method_43470((String)blockName), this.leftPos + 6, this.topPos + 6, color, false);
        this.gui.drawCenteredString((class_2561)class_2561.method_43470((String)"BlockState"), this.leftPos + 126, this.topPos + 15, color, false);
        this.gui.drawString((class_2561)class_2561.method_43471((String)"blockomorph.gui.morphConfigScreen.save"), this.leftPos + 9, this.topPos + 128, color, false);
        this.gui.drawCenteredString((class_2561)class_2561.method_43471((String)"blockomorph.gui.morphConfigScreen.extended"), this.leftPos + 44, this.topPos + 87, color, false);
    }

    @Override
    public void renderMenu() {
        super.renderMenu();
        if (this.needUpperTabs) {
            this.gui.blit(EXIT_TABS_SPRITE, this.leftPos + 4, this.topPos - 19, 0.0f, 23.0f, 80, 22, 80, 46);
        }
        this.renderStrings();
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        if (this.needUpperTabs && GuiUtils.isMouseOver(this.leftPos + 41, this.topPos - 19, this.leftPos + 84, this.topPos + 3, mouseX, mouseY)) {
            GuiUtils.MC.method_1507((class_437)new MorphScreen(true, true));
            return true;
        }
        if (this.propertiesRenderer.mouseClicked(mouseX, mouseY, mouseButtonEvent.method_74245())) {
            return true;
        }
        return super.method_25402(mouseButtonEvent, doubleClick);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double yWheelOffset) {
        if (this.propertiesRenderer.mouseScrolled(mouseX, mouseY, yWheelOffset)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, yWheelOffset);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.propertiesRenderer = new BlockStatePropsRenderer(this.leftPos + 93, this.topPos + 24, 5, this::getState, newState -> MorphUtils.sendServer(ServerBoundBlockMorphPacket.create(newState, null)));
        class_342 old = this.saveBox;
        this.saveBox = new ListenerEditBox(this.field_22793, this.leftPos + 7, this.topPos + 137, 129, 19, (class_2561)class_2561.method_43471((String)"blockomorph.gui.morphConfigScreen.save"), value -> this.checkSaveButtons(), ListenerEditBox.EDITBOX_BORDER_SPRITE);
        this.saveBox.method_1880(500);
        this.method_37063((class_364)this.saveBox);
        this.saveButton = new SpriteImageButton(this.leftPos + 142, this.topPos + 133, 26, 26, SAVE_BUTTON_SPRITE, button -> {
            AbstractMorphScreen.SAVED_BLOCK_MANAGER.add(new SavedBlock(this.getState(), this.getTag(), this.saveBox.method_1882()));
            this.checkSaveButtons();
        }, null, true);
        this.method_37063((class_364)this.saveButton);
        this.deleteButton = new SpriteImageButton(this.leftPos + 142, this.topPos + 133, 26, 26, DELETE_BUTTON_SPRITE, button -> {
            AbstractMorphScreen.SAVED_BLOCK_MANAGER.delete(this.saveBox.method_1882());
            this.checkSaveButtons();
        }, null, false);
        SpriteImageButton nbtButton = new SpriteImageButton(this.leftPos + 31, this.topPos + 95, 26, 26, NBT_BUTTON_SPRITE, but -> GuiUtils.MC.method_1507((class_437)new PlayerBlockEntityNbtEditor(this)), () -> this.getState().method_26204() instanceof class_2343, true);
        this.method_37063((class_364)nbtButton);
        this.method_37063((class_364)this.deleteButton);
        this.suggestSavedBlock(old);
        this.needUpperTabs = MorphUtils.getScreenAccess((class_1657)this.player.player()).morph;
    }

    private void suggestSavedBlock(class_342 old) {
        if (old == null) {
            class_2680 state = this.getState();
            class_2487 tag = this.getTag();
            for (SavedBlock block : AbstractMorphScreen.SAVED_BLOCK_MANAGER.get().values()) {
                if (!block.getState().equals((Object)state) || !block.getTag().equals((Object)tag)) continue;
                this.saveBox.method_1852(block.getName());
                break;
            }
        } else {
            this.saveBox.method_1852(old.method_1882());
        }
        this.checkSaveButtons();
    }

    private void checkSaveButtons() {
        String saveBoxContent = this.saveBox.method_1882();
        if (saveBoxContent.isEmpty()) {
            this.diactiveSave();
            return;
        }
        SavedBlock savedBlock = AbstractMorphScreen.SAVED_BLOCK_MANAGER.get().get(saveBoxContent);
        if (savedBlock == null) {
            this.saveButton.field_22764 = true;
            this.deleteButton.field_22764 = false;
        } else if (savedBlock.getState().equals((Object)this.getState()) && savedBlock.getTag().equals((Object)this.getTag())) {
            this.saveButton.field_22764 = false;
            this.deleteButton.field_22764 = true;
        } else {
            this.diactiveSave();
            return;
        }
        this.saveButton.field_22763 = true;
    }

    private void diactiveSave() {
        this.saveButton.field_22763 = false;
        this.saveButton.field_22764 = true;
        this.deleteButton.field_22764 = false;
    }
}

