/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.blockomorph.screens.overlay.BlockHeartOverlay;
import net.blockomorph.screens.overlay.Overlay;
import net.blockomorph.screens.overlay.PlayerCrackOverlay;
import net.blockomorph.screens.utils.DynamicSizeItemStackRenderState;
import net.blockomorph.screens.utils.GuiBlockRenderState;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.class_1041;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11245;
import net.minecraft.class_11256;
import net.minecraft.class_11540;
import net.minecraft.class_11566;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_768;
import net.minecraft.class_776;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_9275;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GuiUtils {
    public static final class_2338 AIR = new class_2338(0, 500, 0);
    public static final class_310 MC = class_310.method_1551();
    public static final List<Overlay> OVERLAYS = new ArrayList<Overlay>();
    public static final class_776 blockRenderer = MC.method_1541();
    public static final class_824 blockEntityRenderer = MC.method_31975();
    public static final Vector3f DIFFUSE_LIGHT_START;
    public static final Vector3f DIFFUSE_LIGHT_END;
    private class_332 GUI;
    private int mouseX;
    private int mouseY;
    private float tick;
    private class_327 font;

    public static class_2960 res(String path) {
        return MorphUtils.res(path);
    }

    public static class_2960 vanillaRes(String path) {
        return MorphUtils.vanillaRes(path);
    }

    public void setGuiGraphics(class_332 gui, class_327 font, int mouseX, int mouseY, float tick) {
        this.GUI = gui;
        this.font = font;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tick = tick;
    }

    public class_332 getGuiGraphics() {
        return this.GUI;
    }

    public class_327 getFont() {
        return this.font;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public float getTick() {
        return this.tick;
    }

    public void blit(class_2960 resourceLocation, int x, int y, float u, float v, int uvMaxX, int uvMaxY, int maxX, int maxY) {
        this.GUI.method_25290(class_10799.field_56883, resourceLocation, x, y, u, v, uvMaxX, uvMaxY, maxX, maxY);
    }

    public void blitMonoImage(class_2960 resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.blit(resourceLocation, x, y, 0.0f, 0.0f, maxSizeX, maxSizeY, maxSizeX, maxSizeY);
    }

    public void renderTooltip(class_2561 text, int mouseX, int mouseY) {
        this.renderTooltip(List.of(text), mouseX, mouseY);
    }

    public void renderTooltip(List<class_2561> texts, int mouseX, int mouseY) {
        this.GUI.method_51434(this.font, texts, mouseX, mouseY);
    }

    public void renderSprite(class_2960 resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.GUI.method_52706(class_10799.field_56883, resourceLocation, x, y, maxSizeX, maxSizeY);
    }

    public void renderFromSpriteClass(class_1058 sprite, int x, int y, int maxSizeX, int maxSizeY, int color) {
        this.GUI.method_52710(class_10799.field_56883, sprite, x, y, maxSizeX, maxSizeY, color);
    }

    public void drawString(class_2561 text, int x, int y, int color, boolean useShadow) {
        if (class_9848.method_61320((int)color) == 0) {
            color = 0xFF000000 | color;
        }
        this.GUI.method_51439(this.font, text, x, y, color, useShadow);
    }

    public void drawCenteredString(class_2561 text, int xCenter, int y, int color, boolean useShadow) {
        int x = xCenter - this.font.method_1727(text.getString()) / 2;
        this.drawString(text, x, y, color, useShadow);
    }

    public void drawCenteredStringWithAdditional(class_2561 text, int xCenter, int y, int color, boolean useShadow, BiConsumer<Integer, Integer> additional) {
        int length = this.font.method_1727(text.getString());
        int x = xCenter - length / 2;
        additional.accept(x, length);
        this.drawString(text, x, y, color, useShadow);
    }

    public void fill(int x, int y, int endX, int endY, int color) {
        this.GUI.method_25294(x, y, endX, endY, color);
    }

    public void blurScreen(int width, int height, int alpha) {
        this.fill(0, 0, width, height, class_9848.method_61324((int)alpha, (int)77, (int)77, (int)77));
    }

    public void enableScrissors(int x, int y, int endX, int endY) {
        this.GUI.method_44379(x, y, endX, endY);
    }

    public void disableScrissors() {
        this.GUI.method_44380();
    }

    public void renderItem(class_1799 item, float x, float y, float scale, float ignored) {
        if (scale == 1.0f) {
            scale = 16.0f;
        }
        DynamicSizeItemStackRenderState trackingItemStackRenderState = new DynamicSizeItemStackRenderState(scale);
        MC.method_65386().method_65598((class_10444)trackingItemStackRenderState, item, class_811.field_4317, (class_1937)GuiUtils.MC.field_1687, (class_11566)GuiUtils.MC.field_1724, 0);
        this.GUI.field_59826.method_70920(new class_11245(item.method_7909().method_63680().toString(), new Matrix3x2f((Matrix3x2fc)this.GUI.method_51448()), (class_11540)trackingItemStackRenderState, (int)x, (int)y, this.GUI.field_44659.method_70863()));
    }

    public void renderInDepthIfNeededAfterBlockRendering(Runnable rendering) {
        rendering.run();
    }

    public static void renderOverlay(class_332 gui, float delta) {
        GuiUtils guiUtils = new GuiUtils();
        guiUtils.setGuiGraphics(gui, GuiUtils.MC.field_1772, -100, -100, delta);
        class_1041 window = class_310.method_1551().method_22683();
        if (GuiUtils.MC.field_1687 != null) {
            OVERLAYS.forEach(overlay -> overlay.render(guiUtils, window.method_4486(), window.method_4502()));
        }
    }

    public void renderBlockInGui(class_2680 blockState, @Nullable class_2586 blockEntity, float x, float y, float scale) {
        this.GUI.field_59826.method_70922((class_11256)new GuiBlockRenderState(blockState, blockEntity, (int)x, (int)y, scale, this.tick, this.GUI.field_44659.method_70863()));
    }

    public void renderAdditionalOnBlock(class_2680 blockState, float x, float y, float scale) {
        if (blockState.method_26217() == class_2464.field_11455) {
            class_1792 item = null;
            if (blockState.method_26204() instanceof class_2404) {
                item = blockState.method_26227().method_15772().method_15774();
            } else if (blockState.method_26204().method_8389() != class_1802.field_8162) {
                item = blockState.method_26204().method_8389();
            }
            if (item != null) {
                class_1799 itemStack = new class_1799((class_1935)item);
                HashMap<String, String> map = new HashMap<String, String>();
                for (class_2769 property : blockState.method_28501()) {
                    map.put(property.method_11899(), blockState.method_11654(property).toString());
                }
                itemStack.method_57379(class_9334.field_49623, (Object)new class_9275(map));
                this.renderItem(itemStack, x, y, scale, 100.0f);
            }
        }
    }

    public static boolean redirectBlockInfo(List<String> instance, Object e, boolean fluid, class_239 hitResult) {
        if (hitResult instanceof MorphedPlayerHitResult) {
            MorphedPlayerHitResult hit = (MorphedPlayerHitResult)hitResult;
            if (GuiUtils.MC.field_1724.method_31549().field_7477) {
                return instance.add((String)e);
            }
            class_243 position = MorphUtils.getRealBlockPos(hit.getPlayer(), hit.getOffset());
            String x = GuiUtils.formatCoordinate(position.field_1352);
            String y = GuiUtils.formatCoordinate(position.field_1351);
            String z = GuiUtils.formatCoordinate(position.field_1350);
            String st = String.format(Locale.ROOT, "Targeted " + (fluid ? "Fluid" : "Block") + ": %s, %s, %s", x, y, z);
            return instance.add(String.valueOf(class_124.field_1073) + st);
        }
        return instance.add((String)e);
    }

    private static String formatCoordinate(double coordinate) {
        if (coordinate == (double)((int)coordinate)) {
            return String.valueOf((int)coordinate);
        }
        return String.format(Locale.ROOT, "%.3f", coordinate);
    }

    public static boolean isMouseOver(int x, int y, int endX, int endY, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)endX && mouseY >= (double)y && mouseY < (double)endY;
    }

    public static boolean isInBounds(class_768 box, double mouseX, double mouseY) {
        return GuiUtils.isMouseOver(box.method_3321(), box.method_3322(), box.method_3321() + box.method_3319(), box.method_3322() + box.method_3320(), mouseX, mouseY);
    }

    public static void playClickSound() {
        MC.method_1483().method_4873(GuiUtils.getClickSound());
    }

    public static class_1113 getClickSound() {
        return class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f);
    }

    public static void pushHotbarMessage(class_2561 text) {
        GuiUtils.MC.field_1705.method_1758(text, false);
        MC.method_44713().method_37015(text);
    }

    static {
        Matrix4f matrix4f = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-2.41661f, 2.3561945f, 0.0f);
        DIFFUSE_LIGHT_START = matrix4f.transformDirection((Vector3fc)new Vector3f(0.2f, 1.0f, -0.7f).normalize(), new Vector3f());
        DIFFUSE_LIGHT_END = matrix4f.transformDirection((Vector3fc)new Vector3f(-0.2f, 1.0f, 0.7f).normalize(), new Vector3f());
        OVERLAYS.add(new PlayerCrackOverlay());
        OVERLAYS.add(new BlockHeartOverlay());
    }
}

