/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import java.util.function.BiConsumer;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.PlayerMorphedSection;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class InPlayerBlockPos {
    public static final int X_CHUNK_START = 60000000;
    public static final int X_CHUNK_END = 120000000;
    public static final int X_CENTER = 90000000;
    public static final int Y_CHUNK_START = 64;
    public static final InPlayerBlockPos ZERO = InPlayerBlockPos.get(0, 0, 0);
    public final int x;
    public final int y;
    public final int z;

    public static boolean isMorphedPlayerX(double x) {
        return x >= 6.0E7 && x <= 1.2E8;
    }

    public static boolean isMorphPlayerChunk(class_1923 pos) {
        return pos.method_8326() > 60000000 && pos.method_8327() < 120000000;
    }

    private InPlayerBlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isValid() {
        return this.x < 15 && this.x > -15 && this.z < 15 && this.z > -15 && this.y < 31 && this.y >= 0;
    }

    public InPlayerBlockPos offset(int x, int y, int z) {
        return InPlayerBlockPos.get(this.x + x, this.y + y, this.z + z);
    }

    public static class_243 checkOnReal(class_243 vec, @Nullable class_243 detectionCoord) {
        PlayerMorphedSection pos;
        class_1657 player;
        class_243 detectingPos;
        class_243 class_2432 = detectingPos = detectionCoord == null ? vec : detectionCoord;
        if ((InPlayerBlockPos.isMorphedPlayerX(vec.field_1352) || detectionCoord != null) && (player = BlockPosBounds.getPlayerByChunkPos(pos = BlockPosBounds.getPlayerSectionPos(class_2338.method_49638((class_2374)detectingPos)), null)) != null) {
            double d0 = 0.5;
            double y = vec.field_1351 - 64.0;
            double x = vec.field_1352 - (double)(pos.x * 32) - 15.5 - 6.0E7 + d0;
            double z = vec.field_1350 - (double)(pos.z * 32) - 15.5 + d0;
            return MorphUtils.getRealBlockPos(PlayerAccessor.of(player), new class_243(x, y, z));
        }
        return vec;
    }

    public static class_243 checkOnReal(class_243 vec) {
        return InPlayerBlockPos.checkOnReal(vec, null);
    }

    @Nullable
    public class_2338 boundedBlockPos(class_1657 player) {
        PlayerMorphedSection pos;
        if (player != null && (pos = BlockPosBounds.getChunkPosForPlayer(player)) != null) {
            int y = 64 + this.y;
            int x = 60000000 + pos.x * 32 + this.x + 15;
            int z = pos.z * 32 + 15 + this.z;
            return new class_2338(x, y, z);
        }
        return null;
    }

    public static class_238 checkOnReal(class_238 aabb) {
        if (aabb.field_1323 > 6.0E7 || aabb.field_1320 > 6.0E7) {
            class_243 center = aabb.method_1005();
            class_243 min = InPlayerBlockPos.checkOnReal(new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1321), center);
            class_243 max = InPlayerBlockPos.checkOnReal(new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1324), center);
            return new class_238(min, max);
        }
        return aabb;
    }

    public static class_2338 checkOnReal(class_2338 pos) {
        return class_2338.method_49638((class_2374)InPlayerBlockPos.checkOnReal(pos.method_46558()));
    }

    public static InPlayerBlockPos get(int x, int y, int z) {
        return new InPlayerBlockPos(x, y, z);
    }

    public static void check(class_2338 bounded, BiConsumer<PlayerAccessor, InPlayerBlockPos> action, Runnable elseRun, @Nullable Boolean lv) {
        if (bounded != null && action != null && InPlayerBlockPos.isMorphedPlayerX(bounded.method_10263())) {
            PlayerMorphedSection pos = BlockPosBounds.getPlayerSectionPos(bounded);
            class_1657 player = BlockPosBounds.getPlayerByChunkPos(pos, lv);
            if (player != null) {
                int y = bounded.method_10264() - 64;
                int x = bounded.method_10263() - pos.x * 32 - 15 - 60000000;
                int z = bounded.method_10260() - pos.z * 32 - 15;
                action.accept(PlayerAccessor.of(player), new InPlayerBlockPos(x, y, z));
            } else if (elseRun != null) {
                elseRun.run();
            }
        }
    }

    public static void check(class_2338 bounded, BiConsumer<PlayerAccessor, InPlayerBlockPos> action, Runnable elseRun, class_4538 lv) {
        InPlayerBlockPos.check(bounded, action, elseRun, lv.method_8608());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InPlayerBlockPos) {
            InPlayerBlockPos bl = (InPlayerBlockPos)obj;
            return bl.x == this.x && bl.y == this.y && bl.z == this.z;
        }
        return false;
    }

    @Nullable
    public static InPlayerBlockPos parseBlockPos(String input) {
        String[] parts = input.trim().split(" ");
        if (parts.length != 3) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[0]);
            int y = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            return new InPlayerBlockPos(x, y, z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public class_2540 write(class_2540 buffer) {
        buffer.method_53002(this.x);
        buffer.method_53002(this.y);
        buffer.method_53002(this.x);
        return buffer;
    }

    public InPlayerBlockPos(class_2540 buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public String string() {
        return this.x + " " + this.y + " " + this.z;
    }

    public String toString() {
        return "InPlayerBlockPos[x=" + this.x + " y=" + this.y + " z=" + this.z + "]";
    }

    public int hashCode() {
        return (this.x + this.y * 29) * 29 + this.z;
    }
}

