/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.render;

import net.blockomorph.utils.VertexConsumerWrapper;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.render.MorphedPlayerRenderState;
import net.minecraft.class_10017;
import net.minecraft.class_10075;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_898;
import net.minecraft.class_956;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.joml.Vector2d;
import org.joml.Vector3f;

public class MorphedPlayerRenderer {
    private final class_310 mc = class_310.method_1551();
    private final class_776 blockRenderDispatcher = this.mc.method_1541();
    private final class_898 entityDispatcher = this.mc.method_1561();
    private final class_824 blockEntityRenderDispatcher = this.mc.method_31975();
    private final class_4597 crumblBuffer = this.mc.method_22940().method_23001();
    private final class_5819 RANDOM = class_5819.method_43047();

    public boolean submitMorphedState(class_4587 posestack, MorphedPlayerRenderState morphedPlayerRenderState, class_11659 collector, class_12075 cam) {
        if (morphedPlayerRenderState == null) {
            return false;
        }
        MorphedPlayerRenderState.MorphedState morphedState = morphedPlayerRenderState.morphedState;
        if (morphedState instanceof MorphedPlayerRenderState.BlockMorphedState) {
            MorphedPlayerRenderState.BlockMorphedState state = (MorphedPlayerRenderState.BlockMorphedState)morphedState;
            Vector2d vector2d = state.matrixOffset;
            posestack.method_22903();
            posestack.method_22904(vector2d.x, 0.0, vector2d.y);
            for (MorphedPlayerRenderState.BlockInfo block : state.blocks) {
                posestack.method_22903();
                InPlayerBlockPos pos = block.offset;
                posestack.method_46416((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                this.submitMainBlock(false, state.level, block, posestack, collector);
                this.submitBlockEntity(block, posestack, collector, morphedPlayerRenderState.deltaTick, cam);
                this.submitBrake(block, state.level, posestack, collector);
                posestack.method_22909();
            }
            this.submitFrame(state.framedBlock, posestack, collector);
            posestack.method_22909();
            return true;
        }
        morphedState = morphedPlayerRenderState.morphedState;
        if (morphedState instanceof MorphedPlayerRenderState.TntMorphedState) {
            MorphedPlayerRenderState.TntMorphedState state = (MorphedPlayerRenderState.TntMorphedState)morphedState;
            this.submitTnt(state.tntRenderState, posestack, collector, cam);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitTnt(class_10075 state, class_4587 posestack, class_11659 collector, class_12075 cam) {
        try {
            class_956 renderer = (class_956)this.entityDispatcher.method_68832((class_10017)state);
            posestack.method_22903();
            renderer.method_4135(state, posestack, collector, cam);
        }
        catch (Exception exception) {
        }
        finally {
            posestack.method_22909();
        }
    }

    public void submitTranslucentBlocks(MorphedPlayerRenderState.BlockMorphedState state, class_4587 posestack, class_11659 collector) {
        Vector2d vector2d = state.matrixOffset;
        posestack.method_22903();
        posestack.method_22904(vector2d.x, 0.0, vector2d.y);
        for (MorphedPlayerRenderState.BlockInfo block : state.blocks) {
            posestack.method_22903();
            InPlayerBlockPos pos = block.offset;
            posestack.method_46416((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            this.submitMainBlock(true, state.level, block, posestack, collector);
            posestack.method_22909();
        }
        posestack.method_22909();
    }

    private void submitMainBlock(boolean translucent, class_1920 level, MorphedPlayerRenderState.BlockInfo blockInfo, class_4587 posestack, class_11659 collector) {
        posestack.method_22903();
        if (blockInfo.blockState.method_26217() == class_2464.field_11458) {
            this.submitModel(translucent, level, blockInfo, posestack, collector);
        }
        if (blockInfo.needFluidAction) {
            this.submitLiquid(translucent, level, blockInfo, posestack, collector);
        }
        posestack.method_22909();
    }

    private void submitModel(boolean translucent, class_1920 level, MorphedPlayerRenderState.BlockInfo blockInfo, class_4587 posestack, class_11659 collector) {
        class_2680 blockstate = blockInfo.blockState;
        class_2338 keyPos = blockInfo.keyPos;
        class_1921 renderType = class_4696.method_29359((class_2680)blockstate);
        if (translucent != (renderType == class_1921.method_29380())) {
            return;
        }
        collector.method_73483(posestack, renderType, (pose, vertexConsumer) -> {
            class_1087 model = this.blockRenderDispatcher.method_3349(blockstate);
            this.RANDOM.method_43052(blockstate.method_26190(keyPos));
            class_4587 poseStack = new class_4587();
            poseStack.method_23760().method_66521(pose);
            this.blockRenderDispatcher.method_3350().method_3374(level, model.method_68512(this.RANDOM), blockstate, keyPos, poseStack, vertexConsumer, true, class_4608.field_21444);
        });
    }

    private void submitLiquid(boolean translucent, class_1920 level, MorphedPlayerRenderState.BlockInfo blockInfo, class_4587 posestack, class_11659 collector) {
        class_3610 fluidState = blockInfo.blockState.method_26227();
        if (!fluidState.method_15769()) {
            class_2338 pos = blockInfo.keyPos;
            class_11515 layer = class_4696.method_23680((class_3610)fluidState);
            class_1921 renderType = switch (layer) {
                case class_11515.field_60924 -> class_1921.method_23579();
                case class_11515.field_60925 -> class_1921.method_23581();
                case class_11515.field_60926 -> class_1921.method_29380();
                case class_11515.field_60927 -> class_1921.method_29997();
                default -> class_1921.method_23577();
            };
            if (translucent != (renderType == class_1921.method_29380())) {
                return;
            }
            final float xOffset = pos.method_10263() & 0xF;
            final float yOffset = pos.method_10264() & 0xF;
            final float zOffset = pos.method_10260() & 0xF;
            collector.method_73483(posestack, renderType, (pose, vertexConsumer) -> {
                VertexConsumerWrapper vertexConsumerWrapper = new VertexConsumerWrapper(this, vertexConsumer){

                    @Override
                    public class_4588 method_22912(float x, float y, float z) {
                        Vector3f realPos = pose.method_23761().transformPosition(x - xOffset, y - yOffset, z - zOffset, new Vector3f());
                        return super.method_22912(realPos.x(), realPos.y(), realPos.z());
                    }
                };
                ClientLevelAccessor acc = ClientLevelAccessor.of(level);
                try {
                    acc.lockExternalMorphedBlockGetter(true);
                    this.blockRenderDispatcher.method_3352(pos, level, (class_4588)vertexConsumerWrapper, blockInfo.blockState, fluidState);
                    acc.lockExternalMorphedBlockGetter(false);
                }
                catch (class_148 class_1482) {
                    // empty catch block
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitBlockEntity(MorphedPlayerRenderState.BlockInfo blockInfo, class_4587 posestack, class_11659 collector, float deltaTick, class_12075 cam) {
        class_2586 blockEntity = blockInfo.blockEntity;
        if (blockEntity != null) {
            posestack.method_22903();
            try {
                class_827 renderer = this.blockEntityRenderDispatcher.method_3550(blockEntity);
                if (renderer != null) {
                    int k = blockInfo.brakeProgress;
                    class_11683.class_11792 overlay = null;
                    if (k > -1 && k < 10) {
                        overlay = new class_11683.class_11792(k, posestack.method_23760().method_56822());
                    }
                    ClientLevelAccessor acc = ClientLevelAccessor.of((class_1920)blockEntity.method_10997());
                    acc.setSpecialRenderingMode(true);
                    class_11954 state = renderer.method_74335();
                    renderer.method_74331(blockEntity, state, deltaTick, cam.field_63078, overlay);
                    renderer.method_3569(state, posestack, collector, cam);
                    acc.setSpecialRenderingMode(false);
                }
            }
            catch (Exception exception) {
            }
            finally {
                posestack.method_22909();
            }
        }
    }

    private void submitBrake(MorphedPlayerRenderState.BlockInfo blockInfo, class_1920 level, class_4587 posestack, class_11659 collector) {
        int k = blockInfo.brakeProgress;
        if (k > -1 && k < 10) {
            posestack.method_22903();
            collector.method_73483(posestack, (class_1921)class_1921.field_21695, (posestack$pose1, ignored) -> {
                class_4583 vertexconsumer1 = new class_4583(this.crumblBuffer.method_73477((class_1921)class_1088.field_21772.get(k)), posestack$pose1, 1.0f);
                class_4587 poseStack = new class_4587();
                poseStack.method_23760().method_66521(posestack$pose1);
                this.blockRenderDispatcher.method_23071(blockInfo.blockState, blockInfo.keyPos, level, poseStack, (class_4588)vertexconsumer1);
            });
            posestack.method_22909();
        }
    }

    private void submitFrame(class_265 shape, class_4587 posestack, class_11659 collector) {
        if (shape != null) {
            posestack.method_22903();
            int i = (Boolean)this.mc.field_1690.method_64858().method_41753() != false ? -11010079 : class_9848.method_61330((int)102, (int)-16777216);
            collector.method_73483(posestack, (class_1921)class_1921.field_21695, (pose, vertexConsumer) -> {
                class_4587 poseStack = new class_4587();
                poseStack.method_23760().method_66521(pose);
                class_9974.method_62296((class_4587)poseStack, (class_4588)vertexConsumer, (class_265)shape, (double)0.0, (double)0.0, (double)0.0, (int)i);
            });
            posestack.method_22909();
        }
    }
}

