/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.render;

import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.LevelRendererAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.blockomorph.utils.render.MorphedPlayerRenderState;
import net.minecraft.class_10075;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import net.minecraft.class_898;
import net.minecraft.class_956;
import org.joml.Vector2d;

public class MorphedRenderStateExtractor {
    private static final class_898 entityDispatcher = GuiUtils.MC.method_1561();

    public static MorphedPlayerRenderState extractRenderState(PlayerAccessor pl, MorphedPlayerRenderState source, float deltaTick) {
        source.deltaTick = deltaTick;
        Optional pos = pl.player().method_18398();
        pos.ifPresent(blockPos -> {
            source.sleepingPos = blockPos;
        });
        if (pl.isFullActive()) {
            source.morphedState = MorphedRenderStateExtractor.extractBlocks(pl);
        } else if (pl.getTnt() != null) {
            class_956 renderer = (class_956)entityDispatcher.method_3953((class_1297)pl.getTnt());
            MorphedPlayerRenderState.TntMorphedState tntMorphedState = new MorphedPlayerRenderState.TntMorphedState();
            tntMorphedState.tntRenderState = (class_10075)renderer.method_62425((class_1297)pl.getTnt(), deltaTick);
            source.morphedState = tntMorphedState;
        }
        return source;
    }

    public static MorphedPlayerRenderState.BlockMorphedState extractBlocks(PlayerAccessor pl) {
        MorphedPlayerRenderState.BlockMorphedState blockMorphedState = new MorphedPlayerRenderState.BlockMorphedState();
        class_1657 player = pl.player();
        blockMorphedState.level = player.method_73183();
        blockMorphedState.matrixOffset = MorphedRenderStateExtractor.adjustMatrixForPlayer(pl, player);
        InPlayerBlockPos frame = MorphedRenderStateExtractor.getFramedBlock(pl);
        if (frame != null) {
            blockMorphedState.framedBlock = pl.getRenderShape(frame, (class_1657)GuiUtils.MC.field_1724);
        }
        for (Map.Entry<InPlayerBlockPos, BlockInPlayer2> entry : pl.getBlocksData2().entrySet()) {
            MorphedPlayerRenderState.BlockInfo info = new MorphedPlayerRenderState.BlockInfo();
            BlockInPlayer2 block = entry.getValue();
            info.blockState = block.getBlockState();
            info.blockEntity = block.getBlockEntity();
            info.offset = block.getOffset();
            info.keyPos = block.getPos();
            info.needFluidAction = block.shouldDoFluidAction();
            info.renderLight = class_765.method_23687((int)blockMorphedState.level.method_8314(class_1944.field_9282, info.keyPos), (int)blockMorphedState.level.method_8314(class_1944.field_9284, info.keyPos));
            info.brakeProgress = MorphedRenderStateExtractor.getBrakeProgress(player, info.keyPos);
            blockMorphedState.blocks.add(info);
        }
        return blockMorphedState;
    }

    private static Vector2d adjustMatrixForPlayer(PlayerAccessor pl, class_1657 player) {
        InPlayerBlockPos minpos = pl.minPos();
        class_238 hitbox = player.method_5829();
        class_243 playerCenter = player.method_73189();
        double offsetX = hitbox.field_1323 - (playerCenter.field_1352 + (double)minpos.getX());
        double offsetZ = hitbox.field_1321 - (playerCenter.field_1350 + (double)minpos.getZ());
        return new Vector2d(offsetX, offsetZ);
    }

    private static InPlayerBlockPos getFramedBlock(PlayerAccessor pl) {
        class_239 class_2392 = GuiUtils.MC.field_1765;
        if (class_2392 instanceof MorphedPlayerHitResult) {
            MorphedPlayerHitResult hit = (MorphedPlayerHitResult)class_2392;
            if (!GuiUtils.MC.field_1690.field_1842 && hit.getPlayer() == pl) {
                InPlayerBlockPos offset = hit.getOffset();
                if (GuiUtils.MC.field_1724.method_7325()) {
                    return MorphUtils.canOpenMenuIn(pl, offset) ? offset : null;
                }
                if (GuiUtils.MC.field_1761.method_2920() == class_1934.field_9216) {
                    return MorphUtils.isAdventureCanBreak(pl, (class_1657)GuiUtils.MC.field_1724, offset) ? offset : null;
                }
                return offset;
            }
        }
        return null;
    }

    private static int getBrakeProgress(class_1657 player, class_2338 bounded) {
        if (Config.getInstance().getValue("hitReaction", Config.HitReaction.class) != Config.HitReaction.BRAKING) {
            float percentage = player.method_6032() / player.method_6063();
            if ((double)percentage < 0.03) {
                return 9;
            }
            int k = class_3532.method_15386((float)(percentage * 10.0f));
            return 9 - k;
        }
        return MorphedRenderStateExtractor.getBrakeProgress(bounded);
    }

    public static int getBrakeProgress(class_2338 bounded) {
        class_3191 progress;
        LevelRendererAccessor acc = LevelRendererAccessor.of(class_310.method_1551().field_1769);
        SortedSet pos = (SortedSet)acc.getBrakingBlocks().get(bounded.method_10063());
        if (pos != null && (progress = (class_3191)pos.last()) != null) {
            return progress.method_13988();
        }
        return -1;
    }
}

