/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.apache.commons.lang3.function.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class FluidEntitySupportMixin {
    @Shadow
    private class_1937 field_6002;
    @Shadow
    private class_243 field_22467;
    @Shadow
    @Final
    private Set<class_6862<class_3611>> field_25599;
    @Unique
    List<Object> fluidData = new ArrayList<Object>(4);

    @Shadow
    protected abstract void method_5622(class_2680 var1);

    @Shadow
    public abstract class_238 method_5829();

    @Shadow
    public abstract boolean method_5675();

    @Shadow
    public abstract double method_23320();

    @Shadow
    public abstract class_243 method_33571();

    @Inject(at={@At(value="TAIL")}, method={"checkInsideBlocks"})
    private void checkInsideBlocks(CallbackInfo ci) {
        if (Config.getInstance().getValue("entityInside", Boolean.class).booleanValue()) {
            class_238 entityBox = this.method_5829().method_1011((double)1.0E-5f);
            class_1297 self = (class_1297)this;
            List entities = this.field_6002.method_8333(self, entityBox, class_1301.field_6155);
            for (class_1297 entity : entities) {
                PlayerAccessor pl;
                if (!(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive()) continue;
                pl.getBlocksData2InArea(entityBox, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, class_243>)((TriConsumer)(pos, block, realPos) -> {
                    class_2680 blockState = block.getBlockState();
                    if (!blockState.method_26215()) {
                        blockState.method_26178(this.field_6002, block.getPos(), self);
                        this.method_5622(blockState);
                    }
                }));
            }
        }
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getBoundingBox()Lnet/minecraft/world/phys/AABB;")})
    public void calculateInFluid(class_6862<class_3611> tagKey, double d, CallbackInfoReturnable<Boolean> cir) {
        class_238 aabb = this.method_5829().method_1011(0.001);
        this.fluidData.clear();
        List entities = this.field_6002.method_8333((class_1297)this, aabb, class_1301.field_6155);
        AtomicReference<Double> newFluidHeigth = new AtomicReference<Double>(0.0);
        boolean pushedByFluid = this.method_5675();
        AtomicReference<class_243> fluidSpeed = new AtomicReference<class_243>(class_243.field_1353);
        AtomicInteger fluidCount = new AtomicInteger();
        AtomicBoolean finded = new AtomicBoolean(false);
        for (class_1297 entity : entities) {
            PlayerAccessor pl;
            if (!(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive()) continue;
            pl.getBlocksData2InArea(aabb, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, class_243>)((TriConsumer)(pos, block, realPos) -> {
                double fluidHeight;
                class_3610 fluidState;
                if (block.shouldDoFluidAction() && (fluidState = block.getBlockState().method_26227()).method_15767(tagKey) && (fluidHeight = realPos.field_1351 + (double)fluidState.method_15763((class_1922)this.field_6002, block.getPos())) >= aabb.field_1322) {
                    finded.set(true);
                    newFluidHeigth.set(Math.max(fluidHeight - aabb.field_1322, (Double)newFluidHeigth.get()));
                    if (pushedByFluid) {
                        class_243 flowSpeed = fluidState.method_15758((class_1922)this.field_6002, block.getPos());
                        if ((Double)newFluidHeigth.get() < 0.4) {
                            flowSpeed = flowSpeed.method_1021(((Double)newFluidHeigth.get()).doubleValue());
                        }
                        fluidSpeed.set(((class_243)fluidSpeed.get()).method_1019(flowSpeed));
                        fluidCount.incrementAndGet();
                    }
                }
            }));
        }
        this.fluidData.add(finded.get());
        this.fluidData.add(newFluidHeigth.get());
        this.fluidData.add(fluidSpeed.get());
        this.fluidData.add(fluidCount.get());
    }

    @ModifyVariable(method={"updateFluidHeightAndDoFluidPushing"}, at=@At(value="STORE", ordinal=0), ordinal=1)
    private boolean isFinded(boolean yes) {
        return (Boolean)this.fluidData.getFirst();
    }

    @ModifyVariable(method={"updateFluidHeightAndDoFluidPushing"}, at=@At(value="STORE", ordinal=0), ordinal=1)
    private double getFluidHeight(double old0) {
        return (Double)this.fluidData.get(1);
    }

    @ModifyVariable(method={"updateFluidHeightAndDoFluidPushing"}, at=@At(value="STORE", ordinal=0))
    private class_243 getFluidFlow(class_243 vec) {
        return (class_243)this.fluidData.get(2);
    }

    @ModifyVariable(method={"updateFluidHeightAndDoFluidPushing"}, at=@At(value="STORE", ordinal=0), ordinal=6)
    private int getFluidCount(int old0) {
        return (Integer)this.fluidData.get(3);
    }

    @WrapOperation(method={"updateSwimming"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")})
    public class_3610 getRealBlock(class_1937 instance, class_2338 blockPos, Operation<class_3610> original) {
        AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2> fluidState1;
        class_3610 fluidState = (class_3610)original.call(new Object[]{instance, blockPos});
        if (!fluidState.method_15767(class_3486.field_15517) && (fluidState1 = this.getLiquid(this.field_22467)) != null) {
            return fluidState1.getValue().getBlockState().method_26227();
        }
        return fluidState;
    }

    @Inject(method={"updateFluidOnEyes"}, at={@At(value="TAIL")})
    public void getLiquid(CallbackInfo ci) {
        class_3610 fluidState;
        double height;
        BlockInPlayer2 block;
        double y;
        AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2> liquid = this.getLiquid(this.method_33571());
        if (liquid != null && (y = MorphUtils.getRealBlockPos((PlayerAccessor)liquid.getKey(), (InPlayerBlockPos)block.getOffset()).field_1351) + (height = (double)(fluidState = (block = liquid.getValue()).getBlockState().method_26227()).method_15763((class_1922)this.field_6002, block.getPos())) > this.method_23320()) {
            fluidState.method_40181().forEach(tag -> this.field_25599.add((class_6862<class_3611>)tag));
        }
    }

    @Unique
    private AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2> getLiquid(class_243 position) {
        class_1297 self = (class_1297)this;
        AtomicReference reference = new AtomicReference();
        List entities = this.field_6002.method_8333(self, new class_238(class_2338.field_10980).method_997(position.method_1031(-0.5, -0.5, -0.5)), class_1301.field_6155);
        MorphUtils.doBlockInMorphedPlayerOnPos(self, entities, position, (pl, block) -> {
            if (block.shouldDoFluidAction()) {
                reference.set(new AbstractMap.SimpleEntry<PlayerAccessor, BlockInPlayer2>((PlayerAccessor)pl, (BlockInPlayer2)block));
            }
        });
        return (AbstractMap.SimpleEntry)reference.get();
    }
}

