/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.network;

import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ServerBoundBlockMorphPacket
implements BlockMorphPacket {
    public static final String ID = "server_bound_block_morph_packet";
    class_2487 tag;

    private ServerBoundBlockMorphPacket(class_2487 nbt) {
        this.tag = nbt;
    }

    public ServerBoundBlockMorphPacket(class_2540 buf) {
        this.tag = buf.method_10798();
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10794((class_2520)this.tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void handle(class_1657 player) {
        if (player instanceof PlayerAccessor) {
            PlayerAccessor mob = (PlayerAccessor)player;
            if (this.tag == null) {
                throw new IllegalArgumentException("Payload is null!");
            }
            if (this.tag.method_10545("fuse")) {
                mob.setTnt();
                return;
            }
            class_2680 blockstate = class_2512.method_10681((class_7871)player.method_37908().method_45448(class_7924.field_41254), (class_2487)this.tag.method_10562("BlockState"));
            class_2487 nbt = this.tag.method_10573("Tags", 10) ? this.tag.method_10562("Tags") : null;
            this.doMorph(mob, blockstate, nbt);
        }
    }

    private void doMorph(PlayerAccessor player, class_2680 state, class_2487 nbt) {
        Config.ScreenAccess access = MorphUtils.getScreenAccess(player.player());
        if (!access.morph && !player.getBlockState(InPlayerBlockPos.ZERO).method_27852(state.method_26204())) {
            throw new IllegalArgumentException("You not have access to change your blockstate.");
        }
        if (!(access.config || nbt == null && state.method_26204().method_9564().equals(state))) {
            throw new IllegalArgumentException("You not have access to config your block.");
        }
        BannedBlock reason = player.applyBlockMorph(state, nbt, BannedBlock.Source.NETWORK);
        if (reason != null && reason != BannedBlock.ALREADY_MORPHED) {
            throw new IllegalArgumentException(reason.reason());
        }
    }

    public static ServerBoundBlockMorphPacket create(class_2680 state, @Nullable class_2487 tagMorph) {
        class_2487 tag = new class_2487();
        tag.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)state));
        if (tagMorph != null) {
            tag.method_10566("Tags", (class_2520)tagMorph);
        }
        return new ServerBoundBlockMorphPacket(tag);
    }

    public static ServerBoundBlockMorphPacket fuse() {
        class_2487 tag = new class_2487();
        tag.method_10556("fuse", true);
        return new ServerBoundBlockMorphPacket(tag);
    }
}

