/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive;

import java.util.List;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.BooleanTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.PrimitiveTagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_5253;

public abstract class NumericTagRenderer<NUMBER_TAG extends class_2514>
extends PrimitiveTagRenderer<NUMBER_TAG> {
    public static final int INT_COLOR = class_5253.class_5254.method_27764((int)255, (int)89, (int)47, (int)245);
    public static final int LONG_COLOR = class_5253.class_5254.method_27764((int)255, (int)0, (int)137, (int)158);
    public static final int DOUBLE_COLOR = class_5253.class_5254.method_27764((int)255, (int)27, (int)206, (int)62);
    public static final int FLOAT_COLOR = class_5253.class_5254.method_27764((int)255, (int)250, (int)202, (int)32);
    public static final int SHORT_COLOR = class_5253.class_5254.method_27764((int)255, (int)173, (int)0, (int)184);
    public static final int BYTE_COLOR = class_5253.class_5254.method_27764((int)255, (int)178, (int)0, (int)20);
    private final NUMBER_TAG DEFAULT;
    private final int color;

    protected NumericTagRenderer(String tagName, NUMBER_TAG tag, TagRendererContext<NUMBER_TAG> ctx, NUMBER_TAG defaultValue, int backgroundColor) {
        super(tagName, tag, ctx);
        this.valueBox.method_1890(value -> {
            if (value.isEmpty() || value.equals("-")) {
                return true;
            }
            NUMBER_TAG output = this.parseInternal((String)value);
            return output != null;
        });
        this.DEFAULT = defaultValue;
        this.color = backgroundColor;
        this.valueBox.method_1852(tag.method_10702().toString());
    }

    @Override
    public void renderPlate(GuiUtils gui, int number) {
        gui.fill(this.box.method_3321(), this.box.method_3322(), this.box.method_3321() + this.box.method_3319(), this.box.method_3322() + this.box.method_3320(), this.color);
        super.renderPlate(gui, number);
    }

    @Override
    protected void renderLine(GuiUtils gui, int number) {
        this.renderDynamicColorLine(gui);
    }

    @Override
    protected Integer getPlateNumber() {
        return 1;
    }

    @Override
    protected void onValueEntered(String value) {
        NUMBER_TAG tag;
        if (value.isEmpty() || value.equals("-")) {
            this.changeThis(this.DEFAULT);
        }
        if ((tag = this.parseInternal(value)) != null) {
            this.changeThis(tag);
        }
    }

    private NUMBER_TAG parseInternal(String value) {
        try {
            return this.parse(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected abstract NUMBER_TAG parse(String var1) throws NumberFormatException;

    public static class ByteTagRenderer
    extends NumericTagRenderer<class_2481> {
        private static final List<String> BOOLEAN_WORDS = List.of("is", "can", "has", "enable", "active", "power", "disable", "work", "in", "show");

        public ByteTagRenderer(String tagName, class_2481 tag, TagRendererContext<class_2481> ctx) {
            super(tagName, tag, ctx, class_2481.method_23233((byte)0), BYTE_COLOR);
        }

        @Override
        protected class_2481 parse(String value) throws NumberFormatException {
            return class_2481.method_23233((byte)Byte.parseByte(value));
        }

        public BooleanTagRenderer getInterpretationRenderer(Runnable onInterpretationBrake) {
            byte value = ((class_2481)this.getTag()).method_10698();
            if (value == 0 || value == 1) {
                boolean yes = false;
                String name = this.getName().toLowerCase();
                for (String word : BOOLEAN_WORDS) {
                    if (!name.contains(word)) continue;
                    yes = true;
                    break;
                }
                if (yes || name.endsWith("ed")) {
                    return new BooleanTagRenderer(this, this.tagRendererContext.forInterpretation(onInterpretationBrake));
                }
            }
            return null;
        }
    }

    public static class ShortTagRenderer
    extends NumericTagRenderer<class_2516> {
        public ShortTagRenderer(String tagName, class_2516 tag, TagRendererContext<class_2516> ctx) {
            super(tagName, tag, ctx, class_2516.method_23254((short)0), SHORT_COLOR);
        }

        @Override
        protected class_2516 parse(String value) throws NumberFormatException {
            return class_2516.method_23254((short)Short.parseShort(value));
        }
    }

    public static class FloatTagRenderer
    extends NumericTagRenderer<class_2494> {
        public FloatTagRenderer(String tagName, class_2494 tag, TagRendererContext<class_2494> ctx) {
            super(tagName, tag, ctx, class_2494.method_23244((float)0.0f), FLOAT_COLOR);
        }

        @Override
        protected class_2494 parse(String value) throws NumberFormatException {
            return class_2494.method_23244((float)Float.parseFloat(value));
        }
    }

    public static class DoubleTagRenderer
    extends NumericTagRenderer<class_2489> {
        public DoubleTagRenderer(String tagName, class_2489 tag, TagRendererContext<class_2489> ctx) {
            super(tagName, tag, ctx, class_2489.method_23241((double)0.0), DOUBLE_COLOR);
        }

        @Override
        protected class_2489 parse(String value) throws NumberFormatException {
            return class_2489.method_23241((double)Double.parseDouble(value));
        }
    }

    public static class LongTagRenderer
    extends NumericTagRenderer<class_2503> {
        public LongTagRenderer(String tagName, class_2503 tag, TagRendererContext<class_2503> ctx) {
            super(tagName, tag, ctx, class_2503.method_23251((long)0L), LONG_COLOR);
        }

        @Override
        protected class_2503 parse(String value) throws NumberFormatException {
            return class_2503.method_23251((long)Long.parseLong(value));
        }
    }

    public static class IntTagRenderer
    extends NumericTagRenderer<class_2497> {
        public IntTagRenderer(String tagName, class_2497 tag, TagRendererContext<class_2497> ctx) {
            super(tagName, tag, ctx, class_2497.method_23247((int)0), INT_COLOR);
        }

        @Override
        protected class_2497 parse(String value) throws NumberFormatException {
            return class_2497.method_23247((int)Integer.parseInt(value));
        }
    }
}

