/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.ArrayList;
import java.util.List;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public record BannedBlock(String reason, class_2561 text, boolean systemLock) {
    public static final List<BanPredicate> TESTS = new ArrayList<BanPredicate>();
    public static final BannedBlock ALWAYS_ON = new BannedBlock(null, null, true);
    public static final BannedBlock ALREADY_MORPHED = new BannedBlock("You have already been turned into this block.", (class_2561)class_2561.method_43471((String)"blockomorph.bannedBlock.same"));

    public BannedBlock(String reason, class_2561 text) {
        this(reason, text, false);
    }

    @Nullable
    public static BannedBlock isBannedBlock(class_2680 state, @Nullable PlayerAccessor player, Source source) {
        for (BanPredicate predicate : TESTS) {
            BannedBlock reason = predicate.checkBanned(state, player, source);
            if (reason == null) continue;
            if (reason == ALWAYS_ON) {
                return null;
            }
            return reason;
        }
        return null;
    }

    static {
        TESTS.add((state, player, source) -> {
            if (state.method_26215() && (source != Source.NETWORK || player != null && player.getTnt() == null)) {
                return ALWAYS_ON;
            }
            return null;
        });
        TESTS.add((state, player, source) -> {
            if (player != null && source == Source.NETWORK && player.getTnt() != null) {
                return new BannedBlock("No access to morph when TNT is lit!", (class_2561)class_2561.method_43471((String)"blockomorph.bannedBlock.tnt"));
            }
            return null;
        });
        TESTS.add((state, player, source) -> {
            if (state.method_26204().method_36555() < 0.0f && Config.getInstance().getValue("offUnbreakableBlocks", Boolean.class).booleanValue()) {
                return new BannedBlock("Unbreakable blocks not allowed!", (class_2561)class_2561.method_43471((String)"blockomorph.bannedBlock.unbreakable"));
            }
            return null;
        });
        TESTS.add((state, player, source) -> {
            if ((!state.method_51367() || state.method_26217() == class_2464.field_11455) && Config.getInstance().getValue("solidBlocksOnly", Boolean.class).booleanValue()) {
                return new BannedBlock("Not solid blocks not allowed!", (class_2561)class_2561.method_43471((String)"blockomorph.bannedBlock.solid"));
            }
            return null;
        });
        TESTS.add((state, player, source) -> {
            String name = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
            Config cfg = Config.getInstance();
            Config.Mode mode = cfg.getValue("listMode", Config.Mode.class);
            switch (mode) {
                case WHITELIST: {
                    if (cfg.getValue("allowedBlocks", List.class).contains(name)) break;
                    return new BannedBlock("Block " + name + " not allowed because it not in whitelist!", (class_2561)class_2561.method_43471((String)"blockomorph.bannedBlock.whitelist"));
                }
                case BLACKLIST: {
                    if (!cfg.getValue("bannedBlocks", List.class).contains(name)) break;
                    return new BannedBlock("Block " + name + " not allowed because it in blacklist!", (class_2561)class_2561.method_43471((String)"blockomorph.bannedBlock.blacklist"));
                }
            }
            return null;
        });
    }

    @FunctionalInterface
    public static interface BanPredicate {
        public BannedBlock checkBanned(class_2680 var1, @Nullable PlayerAccessor var2, Source var3);
    }

    public static enum Source {
        NETWORK,
        COMMAND,
        SYSTEM;

    }
}

