/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import com.mojang.serialization.DataResult;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.blockomorph.network.BlockMorphPacket;
import net.blockomorph.network.ClientBoundConfigUpdatePacket;
import net.blockomorph.network.MainPacket;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2530;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.minecraft.class_8710;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class MorphUtils {
    public static final class_5321<class_8110> PLAYER_DESTROYED = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)MorphUtils.res("player_destroyed"));
    public static final class_5321<class_8110> PLAYER_DESTROYED_NULL = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)MorphUtils.res("player_destroyed_null"));
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"blockomorph");
    private static final HashMap<class_2960, PacketInfo> handlers = new HashMap();

    public static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static class_2960 res(String path) {
        return class_2960.method_60655((String)"blockomorph", (String)path);
    }

    public static class_2960 vanillaRes(String path) {
        return class_2960.method_60656((String)path);
    }

    public static PacketInfo getHandler(class_2960 id) {
        return handlers.get(id);
    }

    public static void sendServer(BlockMorphPacket packet) {
        ClientPlayNetworking.send((class_8710)new MainPacket(packet));
    }

    public static void sendAll(BlockMorphPacket packet) {
        for (class_3222 p : Config.getServer().method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)new MainPacket(packet));
        }
    }

    public static void sendPlayer(BlockMorphPacket packet, class_3222 pl) {
        ServerPlayNetworking.send((class_3222)pl, (class_8710)new MainPacket(packet));
    }

    public static void registerPacket(String id, Function<class_2540, BlockMorphPacket> bl, boolean client) {
        class_2960 res = class_2960.method_60655((String)"blockomorph", (String)id);
        if (handlers.containsKey(res)) {
            throw new IllegalArgumentException("Packet with Id: " + id + " alredy registered!");
        }
        handlers.put(class_2960.method_60655((String)"blockomorph", (String)id), new PacketInfo(bl, client));
    }

    public static class_243 getRealBlockPos(PlayerAccessor original, InPlayerBlockPos offset) {
        return MorphUtils.getRealBlockPos(original, new class_243((double)offset.x, (double)offset.y, (double)offset.z));
    }

    public static void doBlockInMorphedPlayerOnPos(@Nullable class_1297 self, Iterable<class_1297> entities, class_243 pos, BiConsumer<PlayerAccessor, BlockInPlayer2> action) {
        for (class_1297 entity : entities) {
            PlayerAccessor pl;
            if (entity == self || !(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive() || !entity.method_5829().method_1006(pos)) continue;
            pl.getBlocksData2InArea(new class_238(pos, pos), (TriConsumer<InPlayerBlockPos, BlockInPlayer2, class_243>)((TriConsumer)(blockOffset, block, realPos) -> action.accept(pl, (BlockInPlayer2)block)));
        }
    }

    public static boolean needModedHit(Predicate<Class<?>> predicate) {
        Optional findedClazz;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).projectile && (findedClazz = STACK_WALKER.walk(stackFrameStream -> stackFrameStream.skip(1L).filter(frame -> predicate.test(frame.getDeclaringClass())).findFirst().map(StackWalker.StackFrame::getDeclaringClass))).isPresent()) {
            return !class_1676.class.isAssignableFrom((Class)findedClazz.get());
        }
        return true;
    }

    public static Predicate<String> blockPredicate() {
        return value -> {
            DataResult result = class_2960.method_29186((String)value);
            if (result.result().isPresent()) {
                return class_7923.field_41175.method_10250((class_2960)result.result().get());
            }
            return false;
        };
    }

    public static class_243 getRealBlockPos(PlayerAccessor original, class_243 offset) {
        class_238 aabb = original.player().method_5829();
        InPlayerBlockPos minPos = original.minPos();
        double deltaX = offset.field_1352 - (double)minPos.getX();
        double deltaY = offset.field_1351 - (double)minPos.getY();
        double deltaZ = offset.field_1350 - (double)minPos.getZ();
        double globalX = aabb.field_1323 + deltaX;
        double globalY = aabb.field_1322 + deltaY;
        double globalZ = aabb.field_1321 + deltaZ;
        return new class_243(globalX, globalY, globalZ);
    }

    public static void distanceTo(class_243 from, class_243 to, boolean sqr, double offset, DoubleConsumer action) {
        if (InPlayerBlockPos.isMorphedPlayerX(from.field_1352) || InPlayerBlockPos.isMorphedPlayerX(to.field_1352) && action != null) {
            from = InPlayerBlockPos.checkOnReal(from);
            to = InPlayerBlockPos.checkOnReal(to);
            double d0 = from.field_1352 + offset - to.field_1352;
            double d1 = from.field_1351 + offset - to.field_1351;
            double d2 = from.field_1350 + offset - to.field_1350;
            double result = d0 * d0 + d1 * d1 + d2 * d2;
            if (!sqr) {
                result = Math.sqrt(result);
            }
            action.accept(result);
        }
    }

    public static void executeMorphedBlockShapeUpdate(class_1936 level, class_2350 direction, class_2680 state, class_2338 offsetted, class_2338 origin, int flags, int distance, class_2680 external) {
        class_2680 blockstate1 = external.method_26191(direction, state, level, offsetted, origin);
        class_2248.method_9611((class_2680)external, (class_2680)blockstate1, (class_1936)level, (class_2338)offsetted, (int)flags, (int)distance);
    }

    public static class_243 getCetneredRealBlockPos(PlayerAccessor original, InPlayerBlockPos offset) {
        class_243 vec = MorphUtils.getRealBlockPos(original, offset);
        return new class_243(vec.field_1352 + 0.5, vec.field_1351 + 0.5, vec.field_1350 + 0.5);
    }

    public static boolean isAdventureCanBreak(PlayerAccessor pl, class_1657 attacker, InPlayerBlockPos hitPart) {
        BlockInPlayer2 block = pl.getBlocksData2().get(hitPart);
        if (block != null) {
            class_2694 blockinworld = new class_2694((class_4538)pl.player().method_37908(), block.getPos(), true);
            class_1799 itemstack = attacker.method_6047();
            return !itemstack.method_7960() && (itemstack.method_57373(blockinworld) || itemstack.method_57357(blockinworld));
        }
        return false;
    }

    public static boolean needRejectUse(class_1937 lv, class_3965 block) {
        if (InPlayerBlockPos.isMorphedPlayerX(block.method_17777().method_10263())) {
            class_2680 state = lv.method_8320(block.method_17777());
            Config.UseMode mode = Config.getInstance().getValue("useMode", Config.UseMode.class);
            switch (mode) {
                case DISABLED: {
                    return true;
                }
                case VANILLA: {
                    class_2960 res = class_7923.field_41175.method_10221((Object)state.method_26204());
                    return !res.method_12836().equals("minecraft");
                }
            }
        }
        return false;
    }

    public static class_1838 checkOnRealIfOut(class_1838 ctx, class_1799 stack) {
        Config.PlaceMode mode;
        if (stack.method_7909() instanceof class_1747 && InPlayerBlockPos.isMorphedPlayerX(ctx.method_8037().method_10263()) && (mode = Config.getInstance().getValue("placeMode", Config.PlaceMode.class)) == Config.PlaceMode.OUT) {
            class_243 realHit = InPlayerBlockPos.checkOnReal(ctx.method_17698());
            realHit = MorphUtils.toDirection(realHit, ctx.method_8038());
            class_3965 hit = new class_3965(realHit, ctx.method_8038(), class_2338.method_49638((class_2374)realHit), ctx.method_17699());
            return new class_1838(ctx.method_8045(), ctx.method_8036(), ctx.method_20287(), ctx.method_8041(), hit);
        }
        return ctx;
    }

    private static class_243 toDirection(class_243 vec, class_2350 dir) {
        class_2382 step = dir.method_10163();
        double x = switch (step.method_10263()) {
            case 1 -> Math.ceil(vec.field_1352) + 1.0E-7;
            case -1 -> Math.floor(vec.field_1352) - 1.0E-7;
            default -> vec.field_1352;
        };
        double y = switch (step.method_10264()) {
            case 1 -> Math.ceil(vec.field_1351) + 1.0E-7;
            case -1 -> Math.floor(vec.field_1351) - 1.0E-7;
            default -> vec.field_1351;
        };
        double z = switch (step.method_10260()) {
            case 1 -> Math.ceil(vec.field_1350) + 1.0E-7;
            case -1 -> Math.floor(vec.field_1350) - 1.0E-7;
            default -> vec.field_1350;
        };
        return new class_243(x, y, z);
    }

    public static void onJoin(class_3222 player) {
        MorphUtils.sendPlayer(new ClientBoundConfigUpdatePacket(Config.getInstance()), player);
        PlayerAccessor.of((class_1657)player).sendAllContentToPlayer(player);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean canOpenMenuIn(PlayerAccessor pl, InPlayerBlockPos offset) {
        BlockInPlayer2 block = pl.getBlocksData2().get(offset);
        if (block != null) {
            class_3908 pr = block.getBlockState().method_26196(pl.player().method_37908(), block.getPos());
            return pr != null;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean canOpenConfig() {
        class_310 mc = class_310.method_1551();
        return mc.field_1724 != null && mc.field_1724.method_5687(2) && Config.getInstance().getValue("canOperatorModifyConfig", Boolean.class) != false;
    }

    public static Config.ScreenAccess getScreenAccess(class_1657 player) {
        if (player != null && player.method_5687(2)) {
            return Config.ScreenAccess.ALL;
        }
        return Config.getInstance().getValue("screenAccess", Config.ScreenAccess.class);
    }

    public static void onRightClick(class_1657 localPlayer, class_1268 interactionHand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> cir) {
        Config.PlaceMode mode;
        if (localPlayer.method_5998(interactionHand).method_7909() instanceof class_1747 && (mode = Config.getInstance().getValue("placeMode", Config.PlaceMode.class)) == Config.PlaceMode.DISABLED && InPlayerBlockPos.isMorphedPlayerX(blockHitResult.method_17777().method_10263())) {
            cir.setReturnValue((Object)class_1269.field_5811);
        }
    }

    public static boolean onPlayerAttacked(class_1309 attacked, class_1282 damage, float amount) {
        if (attacked instanceof PlayerAccessor) {
            boolean allowed;
            PlayerAccessor pl = (PlayerAccessor)attacked;
            if (damage.method_5526() instanceof class_1657 ? Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand : damage.method_5526() instanceof class_1676 && Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).projectile) {
                return false;
            }
            boolean noTnt = pl.getTnt() == null;
            boolean tntBlock = pl.getBlockState(InPlayerBlockPos.ZERO).method_26204() instanceof class_2530;
            boolean tntDamage = damage.method_49708(class_8111.field_42332) || damage.method_49708(class_8111.field_42331);
            boolean bl = allowed = damage.method_49708(class_8111.field_44869) || damage.method_49708(class_8111.field_42347);
            if (pl.isActive()) {
                if (allowed || !tntBlock && tntDamage) {
                    MorphUtils.destroy(pl, damage.method_5529());
                } else if (tntBlock && tntDamage && noTnt) {
                    pl.setTnt();
                    class_1541 tnt = pl.getTnt();
                    if (tnt != null) {
                        tnt.method_6967(tnt.method_6969() / 2);
                    }
                }
                return !damage.method_49708(PLAYER_DESTROYED) && !damage.method_49708(PLAYER_DESTROYED_NULL);
            }
        }
        return false;
    }

    public static void destroy(PlayerAccessor mob_pl, @Nullable class_1297 attacker) {
        class_1657 mob = (class_1657)mob_pl;
        class_6880.class_6883 damage = mob.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(attacker == null ? PLAYER_DESTROYED_NULL : PLAYER_DESTROYED);
        mob.method_5643(new class_1282((class_6880)damage, attacker), Float.MAX_VALUE);
    }

    public record PacketInfo(Function<class_2540, BlockMorphPacket> packet, boolean isClient) {
    }
}

