/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import net.blockomorph.network.ClientBoundBlockPosBoundPacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.PlayerMorphedSection;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class BlockPosBounds {
    private static File FILE;
    public static final int MAX_PLAYER_CHUNKS = 1875000;
    private static final class_5819 random;
    public static final HashMap<PlayerMorphedSection, class_1657> CACHE;
    public static final HashMap<PlayerMorphedSection, class_1657> CLIENT_CACHE;
    private static final HashMap<UUID, PlayerMorphedSection> BOUNDS;
    private static final HashMap<UUID, PlayerMorphedSection> CLIENT_BOUNDS;

    public static void boundPlayer(class_1657 player) {
        if (player instanceof class_3222) {
            UUID uuid = player.method_5667();
            if (!BOUNDS.containsKey(uuid)) {
                PlayerMorphedSection pos = BlockPosBounds.getChunkPos();
                BOUNDS.put(uuid, pos);
                BlockPosBounds.save();
            }
            CACHE.put(BOUNDS.get(uuid), player);
        }
    }

    private static PlayerMorphedSection getChunkPos() {
        int z;
        int x;
        PlayerMorphedSection pos;
        while (BOUNDS.containsValue(pos = new PlayerMorphedSection(x = random.method_43048(1875000), z = random.method_43048(1875000)))) {
        }
        return pos;
    }

    @Nullable
    public static PlayerMorphedSection getChunkPosForPlayer(class_1657 player) {
        if (player.method_37908().field_9236) {
            return CLIENT_BOUNDS.get(player.method_5667());
        }
        return BOUNDS.get(player.method_5667());
    }

    public static PlayerMorphedSection getPlayerSectionPos(class_2338 bounded) {
        int blockZ = bounded.method_10260();
        int blockX = bounded.method_10263();
        int shiftedZ = blockZ;
        int shiftedX = blockX - 60000000;
        int sectorZ = shiftedZ / 32;
        int sectorX = shiftedX / 32;
        return new PlayerMorphedSection(sectorX, sectorZ);
    }

    @Nullable
    public static class_1657 getPlayerByChunkPos(PlayerMorphedSection pos, @Nullable Boolean client) {
        HashMap<PlayerMorphedSection, class_1657> cash = client != null ? (client != false ? CLIENT_CACHE : CACHE) : (Config.getServer() == null ? CLIENT_CACHE : CACHE);
        class_1657 pl = cash.get(pos);
        if (pl == null) {
            return null;
        }
        if (pl.method_31481()) {
            cash.remove(pos);
            pl = null;
        }
        return pl;
    }

    private static void initFile() {
        if (Config.getServer() != null) {
            FILE = new File(Config.getServer().method_27050(class_5218.field_24188).normalize().toFile(), "/data/blockomorph.dat");
        }
    }

    public static void load() {
        class_2487 tg;
        BlockPosBounds.initFile();
        if (FILE == null || !FILE.exists()) {
            return;
        }
        try {
            tg = class_2507.method_30613((Path)FILE.toPath(), (class_2505)class_2505.method_53898());
        }
        catch (IOException ex) {
            MorphUtils.LOGGER.error("Unable to read PLAYER-BLOCKPOS mappings.", (Throwable)ex);
            return;
        }
        for (String key : tg.method_10541()) {
            BOUNDS.put(UUID.fromString(key), new PlayerMorphedSection(tg.method_10537(key)));
        }
    }

    private static void save() {
        if (FILE == null) {
            return;
        }
        class_2487 tg = new class_2487();
        BOUNDS.forEach((uuid, chunkPos) -> tg.method_10544(uuid.toString(), chunkPos.toLong()));
        try {
            class_2507.method_30614((class_2487)tg, (Path)FILE.toPath());
        }
        catch (IOException ex) {
            MorphUtils.LOGGER.error("Unable to save PLAYER-BLOCKPOS mappings.", (Throwable)ex);
        }
    }

    public static void onLevelUnload(class_1936 lv) {
        MinecraftServer sv = lv.method_8503();
        if (sv != null && !sv.method_3816()) {
            BOUNDS.clear();
            CACHE.clear();
            Config.setServer(null);
        }
        CLIENT_BOUNDS.clear();
        CLIENT_CACHE.clear();
    }

    public static void onJoin(class_1657 entity) {
        BlockPosBounds.boundPlayer(entity);
        PlayerMorphedSection pos = BlockPosBounds.getChunkPosForPlayer(entity);
        if (pos != null) {
            MorphUtils.sendPlayer(new ClientBoundBlockPosBoundPacket(pos, entity, false), (class_3222)entity);
        }
    }

    public static void handleBlockPosBound(ClientBoundBlockPosBoundPacket packet) {
        if (packet.delete) {
            class_1657 old = CLIENT_CACHE.remove(packet.pos);
            if (old != null) {
                CLIENT_BOUNDS.remove(old.method_5667());
            }
        } else {
            class_1657 pl = packet.getPlayer();
            if (pl != null) {
                CLIENT_BOUNDS.put(pl.method_5667(), packet.pos);
                CLIENT_CACHE.put(packet.pos, pl);
            }
        }
    }

    static {
        random = class_5819.method_43047();
        CACHE = new HashMap();
        CLIENT_CACHE = new HashMap();
        BOUNDS = new HashMap();
        CLIENT_BOUNDS = new HashMap();
    }
}

