/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morph;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.blockomorph.screens.morph.AbstractMorphScreen;
import net.blockomorph.screens.morph.TabManager;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.SavedBlock;
import net.minecraft.class_1113;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9275;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BlocksManager {
    protected static final class_5321<class_1761> ALLOWED_TAB_KEY = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)GuiUtils.res("allowed_blocks"));
    protected static final HashMap<class_5321<class_1761>, List<SavedBlock>> ALL_TAB_CONTENTS = new HashMap();
    protected final List<SavedBlock> renderableBlocks = new ArrayList<SavedBlock>(16){

        @Override
        public SavedBlock get(int index) {
            if (index >= this.size() || index < 0) {
                return null;
            }
            return (SavedBlock)super.get(index);
        }
    };
    protected static List<class_2248> ALL_BLOCKS;
    private static class_7699 FEATURE_FLAGS;
    private static class_7225.class_7874 HOLDER;
    public final ScrollerManager<SavedBlock> scrollerManager;
    private final AbstractMorphScreen parentScreen;

    public BlocksManager(AbstractMorphScreen screen) {
        this.parentScreen = screen;
        this.scrollerManager = new ScrollerManager<SavedBlock>(() -> screen.getLeftPos() + 158, () -> screen.getTopPos() + 16, 142, 4, 4, this.renderableBlocks, null);
    }

    public void render(GuiUtils gui, AbstractMorphScreen.OnRenderingFrame onRendering) {
        int size = 36;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                class_2586 blockEntity;
                SavedBlock block = this.renderableBlocks.get(y * 4 + x);
                if (block == null) continue;
                class_2248 class_22482 = block.getState().method_26204();
                if (class_22482 instanceof class_2343) {
                    class_2343 ent = (class_2343)class_22482;
                    v0 = ent.method_10123(GuiUtils.AIR, block.getState());
                } else {
                    v0 = blockEntity = null;
                }
                if (blockEntity != null) {
                    blockEntity.method_31662((class_1937)GuiUtils.MC.field_1687);
                    if (block.getTag() != null) {
                        blockEntity.method_58690(block.getTag(), (class_7225.class_7874)this.parentScreen.getPlayer().player().method_56673());
                    }
                }
                gui.renderBlockInGui(block.getState(), blockEntity, this.parentScreen.getLeftPos() + 42 + x * size, this.parentScreen.getTopPos() + 42 + y * size, 20.0f);
                gui.renderAdditionalOnBlock(block.getState(), this.parentScreen.getLeftPos() + 20 + x * size, this.parentScreen.getTopPos() + 25 + y * size, 30.0f);
                int blockX = x;
                int blockY = y;
                gui.renderInDepthIfNeededAfterBlockRendering(() -> onRendering.render(block, this.parentScreen.getLeftPos() + 10 + blockX * size, this.parentScreen.getTopPos() + 15 + blockY * size));
            }
        }
        this.scrollerManager.renderScroller(gui);
    }

    @Nullable
    public SavedBlock getBlockAtPosition(double x, double y) {
        return this.renderableBlocks.get(this.findBlockIndex(x, y));
    }

    public int findBlockIndex(double mouseX, double mouseY) {
        int size = 36;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int blockY;
                int blockX = this.parentScreen.getLeftPos() + 10 + x * size;
                if (!GuiUtils.isMouseOver(blockX, blockY = this.parentScreen.getTopPos() + 15 + y * size, blockX + size - 1, blockY + size, mouseX, mouseY)) continue;
                return y * 4 + x;
            }
        }
        return -1;
    }

    public List<class_1761> sortTabsIfItemsIsBlocks() {
        class_746 player = (class_746)this.parentScreen.getPlayer();
        class_7699 set = player.field_3944.method_45735();
        class_5455 holder = player.method_37908().method_30349();
        if (!set.equals((Object)FEATURE_FLAGS) || HOLDER != holder) {
            ALL_TAB_CONTENTS.clear();
            ALL_BLOCKS = class_7923.field_41175.method_10220().filter(block -> block.method_45382(set)).toList();
            this.putContentTabs(set);
            this.putSearchTab();
            this.putUnsortableTab();
        }
        this.putSavedTab();
        this.putAllowedTab();
        FEATURE_FLAGS = set;
        HOLDER = holder;
        return class_7923.field_44687.method_10220().map(tab -> {
            List<SavedBlock> list;
            class_5321<class_1761> key = TabManager.getKeyFromTab(tab);
            if (tab.method_47312() == class_1761.class_7916.field_41052 && key != class_7706.field_41063 && (list = ALL_TAB_CONTENTS.get(key)) != null && !list.isEmpty()) {
                return tab;
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public void searchBlocks(String searchName) {
        TabManager tabs = this.parentScreen.TAB_MANAGER;
        if (tabs.hasSearchBar()) {
            if (searchName.isEmpty()) {
                tabs.selectTab(TabManager.selectedTab);
            } else {
                List<SavedBlock> list = ALL_TAB_CONTENTS.get(TabManager.getKeyFromTab(TabManager.selectedTab));
                if (list != null) {
                    this.scrollerManager.setScrollOffset(0.0f);
                    List<SavedBlock> blocks = list.stream().filter(block -> {
                        String name = block.getName() != null ? block.getName() : block.getState().method_26204().method_9518().getString();
                        return name.toLowerCase().contains(searchName.toLowerCase());
                    }).toList();
                    this.scrollerManager.setMainList(blocks);
                    this.scrollerManager.refreshList();
                }
            }
        }
    }

    public boolean mouseClicked(double x, double y, AbstractMorphScreen.OnBlockClick click) {
        SavedBlock block = this.parentScreen.BLOCKS_MANAGER.getBlockAtPosition(x, y);
        if (block != null) {
            class_1113 sound = click.click(block, this.parentScreen.BLOCKS_MANAGER.findBlockIndex(x, y), TabManager.getSelectedTab(), TabManager.getTabPage());
            if (sound != null) {
                GuiUtils.MC.method_1483().method_4873(sound);
            }
            return true;
        }
        return this.scrollerManager.mouseClicked(x, y);
    }

    protected void putContentTabs(class_7699 set) {
        class_7923.field_44687.method_29722().forEach(entry -> {
            class_5321 key = (class_5321)entry.getKey();
            class_1761 tab = (class_1761)entry.getValue();
            if (tab.method_47312() == class_1761.class_7916.field_41052) {
                List<SavedBlock> blocks = tab.method_47313().stream().map(item -> {
                    class_1747 block;
                    class_1792 patt0$temp = item.method_7909();
                    if (patt0$temp instanceof class_1747 && (block = (class_1747)patt0$temp).method_45382(set)) {
                        return new SavedBlock(this.prepareBlockStateTag(block.method_7711().method_9564(), (class_1799)item), this.getTagForBlockEntity((class_1799)item), null);
                    }
                    return null;
                }).filter(Objects::nonNull).toList();
                ALL_TAB_CONTENTS.put((class_5321<class_1761>)key, blocks);
            }
        });
    }

    @Nullable
    private class_2487 getTagForBlockEntity(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49611, (Object)class_9279.field_49302);
        if (!customData.method_57458()) {
            return customData.method_57461();
        }
        return null;
    }

    private class_2680 prepareBlockStateTag(class_2680 blockState, class_1799 item) {
        class_9275 properties = (class_9275)item.method_58695(class_9334.field_49623, (Object)class_9275.field_49284);
        if (!properties.method_57414()) {
            return properties.method_57415(blockState);
        }
        return blockState;
    }

    protected void putSearchTab() {
        ALL_TAB_CONTENTS.put((class_5321<class_1761>)class_7706.field_40200, ALL_BLOCKS.stream().map(block -> new SavedBlock(block.method_9564(), null, null)).toList());
    }

    protected void putUnsortableTab() {
        ArrayList newList = new ArrayList();
        ALL_BLOCKS.forEach(block -> {
            boolean contains = false;
            block0: for (Map.Entry<class_5321<class_1761>, List<SavedBlock>> entry : ALL_TAB_CONTENTS.entrySet()) {
                if (entry.getKey() == class_7706.field_40200) continue;
                List<SavedBlock> list = entry.getValue();
                for (SavedBlock block2 : list) {
                    if (block2.getState() == null || block2.getState().method_26204() != block) continue;
                    contains = true;
                    continue block0;
                }
            }
            if (!contains && !newList.contains(block)) {
                newList.add(block);
            }
        });
        List<SavedBlock> old = ALL_TAB_CONTENTS.get(class_7706.field_41063);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (old != null) {
            builder.addAll(old);
        }
        builder.addAll(newList.stream().map(block -> new SavedBlock(block.method_9564(), null, null)).toList());
        ALL_TAB_CONTENTS.put((class_5321<class_1761>)class_7706.field_41063, (List<SavedBlock>)builder.build());
    }

    protected void putSavedTab() {
        ALL_TAB_CONTENTS.put((class_5321<class_1761>)class_7706.field_40199, AbstractMorphScreen.SAVED_BLOCK_MANAGER.get().values().stream().toList());
    }

    protected void putAllowedTab() {
        ALL_TAB_CONTENTS.put(ALLOWED_TAB_KEY, ALL_BLOCKS.stream().map(block -> {
            BannedBlock reason = BannedBlock.isBannedBlock(block.method_9564(), this.parentScreen.getPlayer(), BannedBlock.Source.SYSTEM);
            if (reason == null || reason.systemLock()) {
                return new SavedBlock(block.method_9564(), null, null);
            }
            return null;
        }).filter(Objects::nonNull).toList());
    }

    protected void updateAllowedBlocks() {
        this.putAllowedTab();
        TabManager tabs = this.parentScreen.TAB_MANAGER;
        tabs.putAllowedTabIfNeed();
        if (TabManager.selectedTab == TabManager.ALLOWED_TAB) {
            if (tabs.SPECIAL_TABS.contains(TabManager.ALLOWED_TAB)) {
                tabs.selectTab(TabManager.ALLOWED_TAB);
            } else {
                tabs.selectTab(class_7706.method_47328());
            }
        }
    }
}

