/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.blockomorph.screens.AbstractScreen;
import net.blockomorph.screens.morphConfig.nbtEditor.NbtPath;
import net.blockomorph.screens.morphConfig.nbtEditor.TagTypes;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.AbstractInterpritationTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ListenerEditBox;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.screens.utils.SpriteImageButton;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_7413;
import net.minecraft.class_7871;
import net.minecraft.class_8029;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public abstract class NbtEditorScreen
extends AbstractScreen {
    private static final ScrollerManager.CustomBarData SCOLLER = new ScrollerManager.CustomBarData(GuiUtils.res("textures/screens/nbt_scroller.png"), 7, 15);
    public static final class_2960 BUTTONS_SPRITE = GuiUtils.res("textures/screens/nbt_buttons.png");
    public static final class_2960 LOCK_IMAGE = GuiUtils.res("textures/screens/nbt_lock.png");
    public static final int BUTTON_SPRITE_LENGTH = 46;
    public static final int BUTTON_SPRITE_HEIGHT = 43;
    private static final int MAX_PLATES_COUNT = 7;
    private boolean initialized;
    private final BiConsumer<String, Boolean> onEntering = (tagName, intr) -> this.enterInTag(this.path.append((String)tagName), (boolean)intr);
    private class_2487 editingTag;
    private final Runnable onTagEdited;
    private class_342 tagBox;
    private class_4185 pathExit;
    private class_4185 addButton;
    private class_4185 restoreButton;
    private int internalBoxX;
    private int internalBoxY;
    protected final int internalBoxLength = 173;
    protected final int internalBoxHeigth = 159;
    private final List<RenderableTag<?>> renderables = new ArrayList<RenderableTag<?>>(7){

        @Override
        public boolean add(RenderableTag<?> renderableTag) {
            boolean result = super.add(renderableTag);
            NbtEditorScreen.this.reinitDeleteButtons();
            return result;
        }

        @Override
        public void clear() {
            super.clear();
            NbtEditorScreen.this.reinitDeleteButtons();
        }
    };
    private final ScrollerManager<RenderableTag<?>> scrollerManager;
    private NbtPath path = new NbtPath.RootNbtPath();
    private TagRenderer<?> currentEnteredTag;
    private TagEditingOverlay overlay;
    private final Consumer<TagEditingOverlay> onTagReceived;
    private final List<SpriteImageButton> deleteButtons = new ArrayList<SpriteImageButton>(7);
    private String parseError;
    private boolean editorLocked;

    protected NbtEditorScreen() {
        super("nbt_editor_screen", new class_8029(204, 191));
        this.scrollerManager = new ScrollerManager(() -> this.leftPos + 181, () -> this.topPos + 41, 138, 1, 7, this.renderables, SCOLLER);
        this.onTagEdited = () -> {
            this.tagBox.method_1852(this.editingTag.toString());
            this.onTagEdited(this.editingTag.method_10553());
        };
        this.onTagReceived = this::setOverlay;
    }

    public void setNewTag(class_2487 tag) {
        if (!this.initialized) {
            return;
        }
        this.overlay = null;
        if (tag != null) {
            this.editingTag = tag.method_10553();
            this.tagBox.method_1852(this.editingTag.toString());
            if (!this.editorLocked) {
                TagRenderer<?> renderer = this.getTagByPath();
                if (renderer == null || !renderer.canEnterInTag()) {
                    this.path = new NbtPath.RootNbtPath();
                }
                this.initList(false);
            }
        } else {
            this.editingTag = null;
            this.scrollerManager.setMainList(new ArrayList());
            this.scrollerManager.setScrollOffset(0.0f);
            this.scrollerManager.refreshList();
            this.tagBox.method_1852("");
            this.pathExit.field_22764 = false;
        }
        this.parseError = null;
    }

    private void setOverlay(TagEditingOverlay tagEditor) {
        this.overlay = tagEditor;
        if (tagEditor != null) {
            tagEditor.init(this.field_22789, this.field_22790, this::setOverlay);
        }
    }

    protected abstract void onTagEdited(class_2487 var1);

    protected int getWaitingColor() {
        return class_9848.method_61324((int)255, (int)198, (int)198, (int)198);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float tick) {
        void var6_11;
        super.method_25394(guiGraphics, mouseX, mouseY, tick);
        if (this.editingTag == null) {
            this.gui.fill(this.leftPos + 4, this.topPos + 4, this.leftPos + this.imageLength - 4, this.topPos + this.imageHeight - 4, this.getWaitingColor());
            int x = this.leftPos + this.imageLength / 2;
            int n = this.topPos + this.imageHeight / 2;
            this.gui.drawCenteredString((class_2561)class_2561.method_43471((String)"blockomorph.gui.nbtEditor.waitingTag"), x, n, -1, true);
            this.gui.drawCenteredString((class_2561)class_2561.method_43470((String)class_7413.method_43449((long)class_156.method_658())), x, n + 10, -8355712, true);
            return;
        }
        for (class_4185 class_41852 : this.deleteButtons) {
            class_41852.method_25394(guiGraphics, mouseX, mouseY, tick);
        }
        int i = 0;
        Object var6_10 = null;
        for (RenderableTag<?> tag : this.renderables) {
            tag.render(this.gui, i * 20);
            ++i;
            if (var6_11 != null) continue;
            class_2561 class_25612 = tag.getTooltip(this.gui);
        }
        this.renderError();
        if (this.overlay != null) {
            this.gui.renderInDepthIfNeededAfterBlockRendering(() -> {
                this.gui.blurScreen(this.field_22789, this.field_22790, 190);
                this.overlay.render(this.gui);
            });
        } else if (var6_11 != null) {
            this.gui.renderTooltip((class_2561)var6_11, mouseX, mouseY);
        }
    }

    private void renderError() {
        if (this.parseError != null) {
            int y = this.topPos + this.imageHeight;
            if (this.field_22793.method_1727(this.parseError) > this.field_22789) {
                int textLength = this.field_22793.method_1727(this.parseError);
                int x2 = -(textLength - this.field_22789);
                this.gui.fill(0, y, this.field_22789, y + 11, Integer.MIN_VALUE);
                this.gui.drawString((class_2561)class_2561.method_43470((String)this.parseError).method_27692(class_124.field_1061), x2, y + 2, -1, true);
            } else {
                this.gui.drawCenteredStringWithAdditional((class_2561)class_2561.method_43470((String)this.parseError).method_27692(class_124.field_1061), this.field_22789 / 2, y + 2, -1, false, (x, length) -> this.gui.fill(x - 1, y, x + length + 1, y + 11, Integer.MIN_VALUE));
            }
        }
    }

    public void setEditorLocked(boolean yes) {
        this.editorLocked = yes;
        if (yes) {
            this.path = new NbtPath.RootNbtPath();
            this.pathExit.field_22764 = false;
            this.scrollerManager.setMainList(new ArrayList());
            this.scrollerManager.setScrollOffset(0.0f);
            this.scrollerManager.refreshList();
        } else {
            this.enterInTag(new NbtPath.RootNbtPath(), false);
        }
        this.addButton.field_22764 = !yes;
        this.restoreButton.field_22764 = yes && this.editingTag != null;
    }

    public void setError(String errorMessage) {
        this.parseError = errorMessage;
    }

    public boolean method_25402(double mouseX, double mouseY, int type) {
        if (this.editingTag == null) {
            return false;
        }
        if (this.overlay != null) {
            return this.overlay.method_25402(mouseX, mouseY, type);
        }
        if (type == 0) {
            if (this.forEachTag(renderer -> renderer.mouseClicked(mouseX, mouseY))) {
                this.tagBox.method_25365(false);
                return true;
            }
            for (class_4185 class_41852 : this.deleteButtons) {
                if (!class_41852.method_25402(mouseX, mouseY, type)) continue;
                this.tagBox.method_25365(false);
                return true;
            }
        }
        this.tagBox.method_25365(this.tagBox.method_25405(mouseX, mouseY));
        if (super.method_25402(mouseX, mouseY, type)) {
            return true;
        }
        return this.scrollerManager.mouseClicked(mouseX, mouseY);
    }

    public boolean method_25403(double mouseX, double mouseY, int type, double mouseXOffset, double mouseYOffset) {
        if (this.editingTag == null) {
            return false;
        }
        if (this.overlay != null) {
            return this.overlay.method_25403(mouseX, mouseY, type, mouseXOffset, mouseYOffset);
        }
        if (this.scrollerManager.mouseDragged(mouseY)) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, type, mouseXOffset, mouseYOffset);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double yWheelOffset) {
        if (this.editingTag == null) {
            return false;
        }
        if (this.overlay != null) {
            return this.overlay.method_25401(mouseX, mouseY, 0.0, yWheelOffset);
        }
        if (this.forEachTag(renderer -> renderer.mouseScrolled(mouseX, mouseY, yWheelOffset))) {
            return true;
        }
        return this.scrollerManager.mouseScrolled(yWheelOffset);
    }

    public boolean method_25406(double mouseX, double mouseY, int type) {
        if (this.editingTag == null) {
            return false;
        }
        this.scrollerManager.disableScrollWork();
        if (this.overlay != null) {
            this.overlay.method_25406(mouseX, mouseY, type);
        }
        return super.method_25406(mouseX, mouseY, type);
    }

    public boolean method_25400(char character, int mods) {
        if (this.editingTag == null) {
            return false;
        }
        if (this.overlay != null) {
            return this.overlay.method_25400(character, mods);
        }
        if (this.forEachTag(renderer -> renderer.charTyped(character, mods))) {
            return true;
        }
        return super.method_25400(character, mods);
    }

    public boolean method_25404(int key, int scancode, int mods) {
        if (this.editingTag == null) {
            if (key == 256 && this.method_25422()) {
                this.method_25419();
                return true;
            }
            return false;
        }
        if (this.overlay != null) {
            if (key == 256) {
                this.onTagReceived.accept(null);
                return true;
            }
            return this.overlay.method_25404(key, scancode, mods);
        }
        if (this.forEachTag(renderer -> renderer.keyPressed(key, scancode, mods))) {
            return true;
        }
        return super.method_25404(key, scancode, mods);
    }

    private boolean forEachTag(Function<RenderableTag<?>, Boolean> action) {
        for (RenderableTag<?> renderer : this.renderables) {
            if (!action.apply(renderer).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderMenu() {
        int color = this.path.isEmpty() ? class_9848.method_61324((int)255, (int)84, (int)84, (int)84) : this.currentEnteredTag.getFrameColor();
        this.gui.fill(this.internalBoxX, this.internalBoxY, this.internalBoxX + this.internalBoxLength, this.internalBoxY + this.internalBoxHeigth, color);
        super.renderMenu();
        this.scrollerManager.renderScroller(this.gui);
        this.gui.drawString((class_2561)class_2561.method_43470((String)this.path.getVisualString()), this.internalBoxX + 11, this.internalBoxY + 5, -1, false);
        if (this.editorLocked) {
            this.gui.blitMonoImage(LOCK_IMAGE, this.internalBoxX, this.internalBoxY, this.internalBoxLength, this.internalBoxHeigth);
        }
    }

    private void parseTagboxInput(String value) {
        if (this.editingTag == null) {
            return;
        }
        if (!value.equals(this.editingTag.toString())) {
            try {
                this.editingTag = class_2522.method_67315((String)value);
                this.setEditorLocked(false);
                this.onTagEdited(this.editingTag.method_10553());
                this.parseError = null;
            }
            catch (CommandSyntaxException e) {
                this.parseError = e.getMessage();
                this.setEditorLocked(true);
            }
        } else {
            this.parseError = null;
            if (this.editorLocked) {
                this.setEditorLocked(false);
            }
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.internalBoxX = this.leftPos + 23;
        this.internalBoxY = this.topPos + 26;
        if (!this.initialized) {
            this.tagBox = new ListenerEditBox(this.field_22793, 0, 0, 129, 19, this.method_25440(), this::parseTagboxInput, ListenerEditBox.EDITBOX_BORDER_SPRITE);
            this.tagBox.method_1880(32000);
        }
        this.tagBox.method_48229(this.leftPos + 23, this.topPos + 5);
        this.method_37063((class_364)this.tagBox);
        if (!this.initialized) {
            this.addButton = new SpriteImageButton(0, 0, 16, 16, BUTTONS_SPRITE, b -> {
                TagEditingOverlay addOverlay = this.currentEnteredTag.getTagAddOverlay();
                if (addOverlay != null) {
                    this.setOverlay(addOverlay);
                }
            }, null, false, 0, 0, 46, 43);
        }
        this.addButton.method_48229(this.leftPos + 177, this.topPos + 6);
        this.method_37063((class_364)this.addButton);
        if (!this.initialized) {
            class_5250 text = class_2561.method_43471((String)"blockomorph.gui.nbtEditor.restore");
            int textWidth = this.field_22793.method_27525((class_5348)text);
            this.restoreButton = class_4185.method_46430((class_2561)text, b -> {
                this.tagBox.method_1852(this.editingTag.toString());
                this.setEditorLocked(false);
                this.parseError = null;
            }).method_46437(textWidth + 6, 20).method_46431();
            this.restoreButton.field_22764 = false;
            this.method_37063((class_364)this.restoreButton);
        }
        this.restoreButton.method_48229(this.internalBoxX + this.internalBoxLength / 2 - this.restoreButton.method_25368() / 2, this.internalBoxY + 112);
        if (!this.initialized) {
            this.pathExit = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<--"), button -> this.enterInTag(this.path.back(), false)).method_46437(22, 9).method_46431();
            this.pathExit.field_22764 = false;
        }
        this.pathExit.method_48229(this.internalBoxX + 146, this.internalBoxY + 4);
        this.method_37063((class_364)this.pathExit);
        if (this.initialized) {
            this.reinitDeleteButtons();
        }
        if (this.overlay != null) {
            this.overlay.init(this.field_22789, this.field_22790, this::setOverlay);
        }
        this.initialized = true;
    }

    public void enterInTag(NbtPath path, boolean intr) {
        this.path = path;
        this.initList(intr);
    }

    @Nullable
    private TagRenderer<?> getTagByPath() {
        class_2487 root = this.editingTag;
        String previousName = "root";
        for (String tagName : this.path.constructPath(new ArrayList<String>())) {
            class_2520 child;
            TagRenderer<class_2487> renderer = TagTypes.getRendererForTag(previousName, root, new TagRendererContext(this.provider(), this.onEntering, this.onTagEdited, this.onTagReceived, this::softEnteredTagRebuild));
            if (renderer != null && (child = renderer.tryWalk(tagName)) != null) {
                root = child;
                previousName = tagName;
                continue;
            }
            return null;
        }
        return TagTypes.getRendererForTag(previousName, root, new TagRendererContext(this.provider(), this.onEntering, this.onTagEdited, this.onTagReceived, this::softEnteredTagRebuild));
    }

    private void initList(boolean interpretationEnd) {
        TagRenderer<?> rootRenderer = this.getTagByPath();
        if (rootRenderer == null) {
            throw new IllegalArgumentException("Illegal path: " + String.valueOf(this.path) + " for tag: " + String.valueOf(this.editingTag));
        }
        if (interpretationEnd) {
            rootRenderer = Objects.requireNonNullElse(rootRenderer.getInterpretationRenderer(null), rootRenderer);
        }
        if (rootRenderer.canEnterInTag()) {
            this.currentEnteredTag = rootRenderer;
            ArrayList renderableTags = new ArrayList();
            for (TagRenderer<?> renderer : rootRenderer.getEnteringTags()) {
                renderableTags.add(new RenderableTag(renderer));
            }
            this.scrollerManager.setMainList(renderableTags.stream().filter(RenderableTag::isValid).toList());
            this.scrollerManager.setScrollOffset(0.0f);
            this.scrollerManager.refreshList();
            this.pathExit.field_22764 = !this.path.isEmpty();
            return;
        }
        throw new IllegalArgumentException("Tag: " + rootRenderer.getTag().method_23258().method_23259() + " no enterable!");
    }

    private void softEnteredTagRebuild(HashMap<String, String> mappings) {
        List<String> nonInterpretation = Objects.requireNonNull(this.scrollerManager.getMainList()).stream().map(renderableTag -> {
            if (renderableTag.interpretationDisabled) {
                return (String)mappings.get(renderableTag.mainRenderer.getName());
            }
            return null;
        }).filter(Objects::nonNull).toList();
        ArrayList renderableTags = new ArrayList();
        for (TagRenderer<?> renderer : this.currentEnteredTag.getEnteringTags()) {
            RenderableTag tag = new RenderableTag(renderer);
            renderableTags.add(tag);
            if (!nonInterpretation.contains(tag.mainRenderer.getName())) continue;
            tag.disableInterpretation.run();
        }
        this.scrollerManager.setMainList(renderableTags.stream().filter(RenderableTag::isValid).toList());
        if (this.scrollerManager.getMainList().size() <= 7) {
            this.scrollerManager.setScrollOffset(0.0f);
        }
        this.scrollerManager.refreshList();
    }

    private void reinitDeleteButtons() {
        this.deleteButtons.clear();
        int i = 0;
        for (RenderableTag<?> tag : this.renderables) {
            this.deleteButtons.add(new SpriteImageButton(this.leftPos + 5, this.topPos + 42 + i * 20, 16, 16, BUTTONS_SPRITE, b -> {
                String name = tag.mainRenderer.getName();
                this.currentEnteredTag.deleteTag(name);
            }, null, false, 16, 0, 46, 43));
            ++i;
        }
    }

    private class_7871.class_7872 provider() {
        return GuiUtils.MC.field_1687 != null ? GuiUtils.MC.field_1687.method_30349() : class_5455.field_40585;
    }

    private class RenderableTag<T extends class_2520> {
        TagRenderer<T> mainRenderer;
        boolean interpretationDisabled;
        Runnable disableInterpretation;

        private RenderableTag(TagRenderer<T> renderer) {
            this.mainRenderer = renderer;
            if (this.mainRenderer != null) {
                this.disableInterpretation = () -> {
                    renderer.forceTagChange(this.mainRenderer.getTag());
                    this.mainRenderer = renderer;
                    this.interpretationDisabled = true;
                };
                AbstractInterpritationTagRenderer<T> additionalRenderer = renderer.getInterpretationRenderer(this.disableInterpretation);
                if (additionalRenderer != null) {
                    this.mainRenderer = additionalRenderer;
                }
            }
        }

        public boolean isValid() {
            return this.mainRenderer != null;
        }

        public void render(GuiUtils gui, int yOffset) {
            this.mainRenderer.getBox().method_35779(NbtEditorScreen.this.internalBoxX + 10, NbtEditorScreen.this.internalBoxY + 14 + yOffset);
            this.mainRenderer.renderTag(gui);
        }

        @Nullable
        public class_2561 getTooltip(GuiUtils gui) {
            return this.mainRenderer.getTooltip(gui);
        }

        public boolean mouseClicked(double mouseX, double mouseY) {
            return this.mainRenderer.mouseClicked(mouseX, mouseY);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double yOffsetWheel) {
            return this.mainRenderer.mouseScrolled(mouseX, mouseY, yOffsetWheel);
        }

        public boolean keyPressed(int key, int scancode, int mods) {
            return this.mainRenderer.keyPressed(key, scancode, mods);
        }

        public boolean charTyped(char character, int mods) {
            return this.mainRenderer.charTyped(character, mods);
        }
    }
}

