/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.blockomorph.screens.morphConfig.nbtEditor.TagTypes;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.AbstractInterpritationTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.BlockStateTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagAddingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9848;

public class CompoundTagRenderer
extends TagRenderer<class_2487> {
    private static final int BUTTON_SIZE = 16;
    private boolean hovered;

    public CompoundTagRenderer(String tagName, class_2487 tag, TagRendererContext<class_2487> ctx) {
        super(tagName, tag, ctx);
    }

    @Override
    public void render(GuiUtils gui) {
        int x = this.box.method_3321() + (this.hasName() ? 61 : this.box.method_3319() - 3 - 16);
        int y = this.box.method_3322() + 2;
        this.hovered = GuiUtils.isMouseOver(x, y, x + 16, y + 16, gui.getMouseX(), gui.getMouseY());
        gui.blit(TAGS_SPRITE, x, y, 144.0f, this.hovered ? 16.0f : 0.0f, 16, 16, 194, 200);
    }

    @Override
    public boolean canEnterInTag() {
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY) {
        if (this.hovered) {
            this.enterInTag();
            GuiUtils.playClickSound();
            return true;
        }
        return false;
    }

    @Override
    public int getFrameColor() {
        return class_9848.method_61324((int)255, (int)210, (int)166, (int)132);
    }

    @Override
    public List<TagRenderer<?>> getEnteringTags() {
        ArrayList renderers = new ArrayList();
        for (String key : ((class_2487)this.getTag()).method_10541()) {
            class_2520 tag = ((class_2487)this.getTag()).method_10580(key);
            if (tag == null) {
                throw new NullPointerException();
            }
            renderers.add(TagTypes.getRendererForTag(key, tag, this.tagRendererContext.withTagUpdateListener(newTag -> ((class_2487)this.getTag()).method_10566(key, newTag))));
        }
        return renderers;
    }

    @Override
    public class_2520 tryWalk(String nameElementInThisTag) {
        return ((class_2487)this.getTag()).method_10580(nameElementInThisTag);
    }

    @Override
    protected Integer getPlateNumber() {
        return 2;
    }

    @Override
    public TagEditingOverlay getTagAddOverlay() {
        return new TagAddingOverlay<class_2520>(Objects::nonNull, (name, tag) -> {
            ((class_2487)this.getTag()).method_10566(name, tag);
            this.signalChange();
        }, () -> "Tag name", null, true, TagTypes.getRegisteredTags());
    }

    @Override
    public void deleteTag(String name) {
        ((class_2487)this.getTag()).method_10551(name);
        this.signalChange();
    }

    private void signalChange() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String tagName : ((class_2487)this.getTag()).method_10541()) {
            map.put(tagName, tagName);
        }
        this.tagRendererContext.onSoftRebuildRequested().accept(map);
        this.tagRendererContext.onMainTagEdited().run();
    }

    @Override
    public AbstractInterpritationTagRenderer<class_2487> getInterpretationRenderer(Runnable onInterpretationBrake) {
        class_2487 self = (class_2487)this.getTag();
        if (self.method_10545("Name")) {
            if (self.method_10545("Properties") && self.method_10546() == 2) {
                return this.getBlockStateRenderer(onInterpretationBrake);
            }
            if (MorphUtils.blockPredicate().test(self.method_68564("Name", "")) && self.method_10546() == 1) {
                return this.getBlockStateRenderer(onInterpretationBrake);
            }
        }
        return null;
    }

    private BlockStateTagRenderer getBlockStateRenderer(Runnable onInterpretationBrake) {
        return new BlockStateTagRenderer(this, this.tagRendererContext.forInterpretation(onInterpretationBrake));
    }
}

