/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.overlay;

import net.blockomorph.screens.overlay.Overlay;
import net.blockomorph.screens.utils.FogLiquidModifier;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_1058;
import net.minecraft.class_1657;
import net.minecraft.class_2404;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class BlockHeartOverlay
implements Overlay {
    private static final class_2960 BAR_IMAGE = GuiUtils.res("textures/screens/icons.png");
    private static final class_2960 HEART_INNER = GuiUtils.res("textures/screens/empty_heart_inner.png");
    private static final class_2960 HEART_OUT = GuiUtils.res("textures/screens/empty_heart_out.png");
    private static final class_2960 HEART_OUT_ABS = GuiUtils.res("textures/screens/empty_heart_abs.png");

    @Override
    public void render(GuiUtils gui, int screenWidth, int screenHeight) {
        PlayerAccessor player;
        class_746 class_7462 = GuiUtils.MC.field_1724;
        if (class_7462 instanceof PlayerAccessor && (player = (PlayerAccessor)class_7462).isActive() && GuiUtils.MC.field_1761 != null && GuiUtils.MC.field_1761.method_2908()) {
            switch (Config.getInstance().getValue("hitReaction", Config.HitReaction.class)) {
                case MELEE: 
                case PROJECTILES: 
                case FULL_PVP: {
                    this.renderBlockHearts(player, gui, screenWidth, screenHeight);
                    break;
                }
                case BRAKING: {
                    this.renderBlockSharps(player, gui, screenWidth, screenHeight);
                    break;
                }
            }
        }
    }

    private void renderBlockSharps(PlayerAccessor player, GuiUtils gui, int screenWidth, int screenHeight) {
        int progress = player.getBiggestProgress();
        int x = screenWidth / 2 - 90;
        int y = screenHeight - 38;
        gui.blit(BAR_IMAGE, x - 1, y - 1, 0.0f, progress == 9 ? 9.0f : 0.0f, 81, 9, 81, 18);
        TextureData data = TextureData.get(player);
        for (int i = 0; i < 10; ++i) {
            if (i >= 9 - progress) continue;
            gui.renderFromSpriteClass(data.sprite, x + i * 8, y, 7, 7, data.tint);
        }
    }

    private void renderBlockHearts(PlayerAccessor player, GuiUtils gui, int screenWidth, int screenHeight) {
        int x = screenWidth / 2 - 91;
        int y = screenHeight - 39;
        TextureData data = TextureData.get(player);
        class_1657 realPlayer = player.player();
        int hpCount = class_3532.method_15386((float)realPlayer.method_6032());
        int maxHpCount = class_3532.method_15386((float)realPlayer.method_6063());
        int absHp = class_3532.method_15386((float)realPlayer.method_6067());
        int maxHearts = class_3532.method_15386((float)((float)maxHpCount / 2.0f)) + class_3532.method_15386((float)((float)absHp / 2.0f));
        int yCount = 0;
        int xCount = 0;
        int currentHp = 0;
        boolean absHearts = false;
        for (int i = 0; i < maxHearts; ++i) {
            Boolean bool = (hpCount -= 2) >= 0 ? Boolean.valueOf(false) : (hpCount == -1 ? Boolean.valueOf(true) : null);
            this.renderOneHeart(gui, x + xCount * 8, y - yCount * 10, data.sprite, bool, data.tint, absHearts);
            if (!absHearts && (currentHp += 2) >= maxHpCount) {
                hpCount = absHp;
                absHearts = true;
            }
            if (++xCount != 10) continue;
            xCount = 0;
            ++yCount;
        }
    }

    private void renderOneHeart(GuiUtils gui, int x, int y, class_1058 sprite, @Nullable Boolean half, int alphaOverlay, boolean absHeart) {
        gui.blitMonoImage(HEART_INNER, x, y, 9, 9);
        if (half != null) {
            gui.enableScrissors(x + 1, y + 1, x + 8 + (half != false ? -3 : 0), y + 6);
            gui.renderFromSpriteClass(sprite, x + 1, y + 1, 7, 7, alphaOverlay);
            gui.disableScrissors();
            gui.enableScrissors(x + 3, y + 6, x + 6 + (half != false ? -1 : 0), y + 8);
            gui.renderFromSpriteClass(sprite, x + 1, y + 1, 7, 7, alphaOverlay);
            gui.disableScrissors();
        }
        gui.blitMonoImage(absHeart ? HEART_OUT_ABS : HEART_OUT, x, y, 9, 9);
    }

    private record TextureData(class_1058 sprite, int tint) {
        static TextureData get(PlayerAccessor player) {
            class_1058 sprite = GuiUtils.blockRenderer.method_3349(player.getBlockState(InPlayerBlockPos.ZERO)).method_68511();
            BlockInPlayer2 block = player.getBlocksData2().get(InPlayerBlockPos.ZERO);
            Integer tint = block != null && block.getBlockState().method_26204() instanceof class_2404 ? FogLiquidModifier.getPlatformFluidTint(GuiUtils.MC.field_1724.method_37908(), block) : null;
            return new TextureData(sprite, tint != null ? 0xFF000000 | tint : -1);
        }
    }
}

