/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import net.blockomorph.screens.overlay.BlockHeartOverlay;
import net.blockomorph.screens.overlay.Overlay;
import net.blockomorph.screens.overlay.PlayerCrackOverlay;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.minecraft.class_1041;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_765;
import net.minecraft.class_768;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_9275;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GuiUtils {
    public static final class_2338 AIR = new class_2338(0, 500, 0);
    public static final class_310 MC = class_310.method_1551();
    public static final List<Overlay> OVERLAYS = new ArrayList<Overlay>();
    private static final Vector3f DIFFUSE_LIGHT_START;
    private static final Vector3f DIFFUSE_LIGHT_END;
    public static final class_4597.class_4598 bufferSource;
    public static final class_776 blockRenderer;
    public static final class_824 blockEntityRenderer;
    private class_10444 scratchItemStackRenderState;
    private class_332 GUI;
    private int mouseX;
    private int mouseY;
    private float tick;
    private class_327 font;

    public static class_2960 res(String path) {
        return MorphUtils.res(path);
    }

    public static class_2960 vanillaRes(String path) {
        return MorphUtils.vanillaRes(path);
    }

    public void setGuiGraphics(class_332 gui, class_327 font, int mouseX, int mouseY, float tick) {
        this.GUI = gui;
        this.font = font;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tick = tick;
        this.scratchItemStackRenderState = new class_10444();
    }

    public class_332 getGuiGraphics() {
        return this.GUI;
    }

    public class_327 getFont() {
        return this.font;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public float getTick() {
        return this.tick;
    }

    public void blit(class_2960 resourceLocation, int x, int y, float u, float v, int uvMaxX, int uvMaxY, int maxX, int maxY) {
        this.GUI.method_25290(class_1921::method_62277, resourceLocation, x, y, u, v, uvMaxX, uvMaxY, maxX, maxY);
    }

    public void blitMonoImage(class_2960 resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.blit(resourceLocation, x, y, 0.0f, 0.0f, maxSizeX, maxSizeY, maxSizeX, maxSizeY);
    }

    public void renderTooltip(class_2561 text, int mouseX, int mouseY) {
        this.renderTooltip(List.of(text), mouseX, mouseY);
    }

    public void renderTooltip(List<class_2561> texts, int mouseX, int mouseY) {
        this.GUI.method_51434(this.font, texts, mouseX, mouseY);
    }

    public void renderSprite(class_2960 resourceLocation, int x, int y, int maxSizeX, int maxSizeY) {
        this.GUI.method_52706(class_1921::method_62277, resourceLocation, x, y, maxSizeX, maxSizeY);
    }

    public void renderFromSpriteClass(class_1058 sprite, int x, int y, int maxSizeX, int maxSizeY, int color) {
        this.GUI.method_52710(class_1921::method_62277, sprite, x, y, maxSizeX, maxSizeY, color);
    }

    public void drawString(class_2561 text, int x, int y, int color, boolean useShadow) {
        this.GUI.method_51439(this.font, text, x, y, color, useShadow);
    }

    public void drawCenteredString(class_2561 text, int xCenter, int y, int color, boolean useShadow) {
        int x = xCenter - this.font.method_1727(text.getString()) / 2;
        this.drawString(text, x, y, color, useShadow);
    }

    public void drawCenteredStringWithAdditional(class_2561 text, int xCenter, int y, int color, boolean useShadow, BiConsumer<Integer, Integer> additional) {
        int length = this.font.method_1727(text.getString());
        int x = xCenter - length / 2;
        additional.accept(x, length);
        this.drawString(text, x, y, color, useShadow);
    }

    public void fill(int x, int y, int endX, int endY, int color) {
        this.GUI.method_25294(x, y, endX, endY, color);
    }

    public void blurScreen(int width, int height, int alpha) {
        this.fill(0, 0, width, height, class_9848.method_61324((int)alpha, (int)77, (int)77, (int)77));
    }

    public void enableScrissors(int x, int y, int endX, int endY) {
        this.GUI.method_44379(x, y, endX, endY);
    }

    public void disableScrissors() {
        this.GUI.method_44380();
    }

    public void renderItem(class_1799 item, float x, float y, float scale, float zDepth) {
        if (scale == 1.0f) {
            scale = 16.0f;
        }
        class_4587 pose = this.GUI.method_51448();
        pose.method_22903();
        MC.method_65386().method_65598(this.scratchItemStackRenderState, item, class_811.field_4317, (class_1937)GuiUtils.MC.field_1687, (class_1309)GuiUtils.MC.field_1724, 0);
        pose.method_46416(x + 8.0f, y + 8.0f, 150.0f + zDepth);
        pose.method_22905(scale, -scale, scale);
        this.doMainRenderingItem(pose);
        pose.method_22909();
    }

    public void renderInDepthIfNeededAfterBlockRendering(Runnable rendering) {
        class_4587 stack = this.GUI.method_51448();
        stack.method_22903();
        stack.method_46416(0.0f, 0.0f, 300.0f);
        rendering.run();
        stack.method_22909();
    }

    public static void renderOverlay(class_332 gui, float delta) {
        GuiUtils guiUtils = new GuiUtils();
        guiUtils.setGuiGraphics(gui, GuiUtils.MC.field_1772, -100, -100, delta);
        class_1041 window = class_310.method_1551().method_22683();
        if (GuiUtils.MC.field_1687 != null) {
            OVERLAYS.forEach(overlay -> overlay.render(guiUtils, window.method_4486(), window.method_4502()));
        }
    }

    private void doMainRenderingItem(class_4587 stack) {
        boolean bl;
        boolean bl2 = bl = !this.scratchItemStackRenderState.method_65608();
        if (bl) {
            this.GUI.method_51452();
            class_308.method_24210();
        }
        this.scratchItemStackRenderState.method_65604(stack, (class_4597)bufferSource, 0xF000F0, class_4608.field_21444);
        this.GUI.method_51452();
        if (bl) {
            class_308.method_24211();
        }
    }

    public void renderBlockInGui(class_2680 blockState, @Nullable class_2586 blockEntity, float x, float y, float scale) {
        class_4587 stack = this.GUI.method_51448();
        stack.method_22903();
        stack.method_46416(x, y, 100.0f);
        stack.method_22905(scale, -scale, scale);
        stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(30.0f));
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-135.0f));
        this.renderBlock(stack, blockState, blockEntity != null ? blockEntity.method_11016() : AIR);
        RenderSystem.setShaderLights((Vector3f)DIFFUSE_LIGHT_START, (Vector3f)DIFFUSE_LIGHT_END);
        this.renderBlockEntity(stack, blockEntity);
        stack.method_22909();
    }

    private void renderBlock(class_4587 stack, class_2680 blockState, class_2338 pos) {
        class_5819 random = class_5819.method_43049((long)blockState.method_26190(pos));
        if (blockState.method_26217() != class_2464.field_11455) {
            List list = blockRenderer.method_3349(blockState).method_68512(random);
            class_1921 renderType = class_4696.method_29359((class_2680)blockState);
            ClientLevelAccessor acc = ClientLevelAccessor.of((class_1937)GuiUtils.MC.field_1687);
            acc.setSpecialRenderingMode(true);
            blockRenderer.method_3350().method_3374((class_1920)GuiUtils.MC.field_1687, list, blockState, pos, stack, bufferSource.getBuffer(renderType), false, class_4608.field_21444);
            acc.setSpecialRenderingMode(false);
        }
    }

    public void renderAdditionalOnBlock(class_2680 blockState, float x, float y, float scale) {
        if (blockState.method_26217() == class_2464.field_11455) {
            class_1792 item = null;
            if (blockState.method_26204() instanceof class_2404) {
                item = blockState.method_26227().method_15772().method_15774();
            } else if (blockState.method_26204().method_8389() != class_1802.field_8162) {
                item = blockState.method_26204().method_8389();
            }
            if (item != null) {
                class_1799 itemStack = new class_1799((class_1935)item);
                HashMap<String, String> map = new HashMap<String, String>();
                for (class_2769 property : blockState.method_28501()) {
                    map.put(property.method_11899(), blockState.method_11654(property).toString());
                }
                itemStack.method_57379(class_9334.field_49623, (Object)new class_9275(map));
                this.renderItem(itemStack, x, y, scale, 100.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends class_2586> void renderBlockEntity(class_4587 stack, T blockEntity) {
        class_827 renderer;
        if (blockEntity != null && (renderer = blockEntityRenderer.method_3550(blockEntity)) != null) {
            ClientLevelAccessor acc = ClientLevelAccessor.of((class_1937)GuiUtils.MC.field_1687);
            try {
                class_4184 cam = class_310.method_1551().method_31975().field_4344;
                acc.setSpecialRenderingMode(true);
                renderer.method_3569(blockEntity, this.tick, stack, (class_4597)bufferSource, class_765.method_23687((int)15, (int)15), class_4608.field_21444, cam.method_19326());
            }
            catch (Exception exception) {
            }
            finally {
                acc.setSpecialRenderingMode(false);
            }
        }
    }

    public static boolean isMouseOver(int x, int y, int endX, int endY, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)endX && mouseY >= (double)y && mouseY < (double)endY;
    }

    public static boolean isInBounds(class_768 box, double mouseX, double mouseY) {
        return GuiUtils.isMouseOver(box.method_3321(), box.method_3322(), box.method_3321() + box.method_3319(), box.method_3322() + box.method_3320(), mouseX, mouseY);
    }

    public static void playClickSound() {
        MC.method_1483().method_4873(GuiUtils.getClickSound());
    }

    public static class_1113 getClickSound() {
        return class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f);
    }

    public static void pushHotbarMessage(class_2561 text) {
        GuiUtils.MC.field_1705.method_1758(text, false);
        MC.method_44713().method_37015(text);
    }

    static {
        bufferSource = MC.method_22940().method_23000();
        blockRenderer = MC.method_1541();
        blockEntityRenderer = MC.method_31975();
        Matrix4f matrix4f = new Matrix4f().scaling(1.0f, -1.0f, 1.0f).rotateYXZ(1.0821041f, 3.2375858f, 0.0f).rotateYXZ(-2.41661f, 2.3561945f, 0.0f);
        DIFFUSE_LIGHT_START = matrix4f.transformDirection((Vector3fc)new Vector3f(0.2f, 1.0f, -0.7f).normalize(), new Vector3f());
        DIFFUSE_LIGHT_END = matrix4f.transformDirection((Vector3fc)new Vector3f(-0.2f, 1.0f, 0.7f).normalize(), new Vector3f());
        OVERLAYS.add(new PlayerCrackOverlay());
        OVERLAYS.add(new BlockHeartOverlay());
    }
}

