/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Predicate;
import net.blockomorph.screens.config.renderers.BlockListConfigRenderer;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BlockListConfig
extends ConfigInstance<List<String>> {
    private static BlockListConfigRenderer RENDERER;
    private final ListOptionContext context;

    public BlockListConfig(String name, List<String> initialValue, boolean canOperatorModify, @Nullable class_2561 tip, ListOptionContext ctx) {
        super(name, initialValue, canOperatorModify, tip);
        this.context = ctx;
    }

    @Override
    public void readFromStorage(JsonElement option) {
        for (JsonElement el : option.getAsJsonArray()) {
            ((List)this.value).add(el.getAsString());
        }
    }

    @Override
    public JsonElement getDataForStorage() {
        JsonArray jsonArray = new JsonArray();
        for (String item : (List)this.value) {
            jsonArray.add(item);
        }
        return jsonArray;
    }

    @Override
    public void readFromNetwork(class_2540 buf) {
        ((List)this.value).clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String element = buf.method_19772();
            ((List)this.value).add(element);
        }
    }

    @Override
    public void writeToNetwork(class_2540 buf) {
        buf.method_53002(((List)this.value).size());
        for (String element : (List)this.value) {
            buf.method_10814(element);
        }
    }

    public class_2960 getFrameTexture() {
        return this.context.frame;
    }

    @Override
    public void parseFromUser(String value) {
        String action;
        String[] parts = value.split(" ", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid input format: " + value);
        }
        String element = parts[1];
        switch (action = parts[0]) {
            case "+": {
                if (this.context.allowedAddValue != null && this.context.allowedAddValue.test(element)) {
                    if (((List)this.value).contains(element)) break;
                    ((List)this.value).add(element);
                    break;
                }
                this.throwError(action, element);
            }
            case "-": {
                if (this.context.allowedRemoveValue != null && this.context.allowedRemoveValue.test(element)) {
                    ((List)this.value).remove(element);
                    break;
                }
                this.throwError(action, element);
            }
            case "r": {
                if (this.context.canClear) {
                    ((List)this.value).clear();
                    break;
                }
                this.throwError(action, element);
            }
            default: {
                throw new IllegalArgumentException("Invalid action: " + action);
            }
        }
    }

    private void throwError(String option, String value) {
        throw new IllegalArgumentException("Invalid action: " + option + " for value: " + value);
    }

    @Override
    public LiteralArgumentBuilder<class_2168> buildArgument(LiteralArgumentBuilder<class_2168> optionNameArgument, class_7157 context, class_2170.class_5364 environment) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)optionNameArgument.then(this.end((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)"add"), false, context))).then(this.end((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)"remove"), true, context))).then(class_2170.method_9247((String)"clear").executes(args -> {
            ((List)this.value).clear();
            Config.getInstance().writeAndSend();
            ((class_2168)args.getSource()).method_9226(() -> class_2561.method_43469((String)"blockomorph.commands.option_change.list.clear", (Object[])new Object[]{this.name}), true);
            return 1;
        }));
    }

    private LiteralArgumentBuilder<class_2168> end(LiteralArgumentBuilder<class_2168> actionString, boolean remove, class_7157 ctx) {
        return (LiteralArgumentBuilder)actionString.then(class_2170.method_9244((String)"value", (ArgumentType)class_7733.method_45603((class_7157)ctx, (class_5321)class_7924.field_41254)).executes(args -> {
            class_5250 end;
            String name = class_7733.method_45602((CommandContext)args, (String)"value", (class_5321)class_7924.field_41254).method_40237().method_29177().toString();
            if (remove) {
                end = class_2561.method_43469((String)"blockomorph.commands.option_change.list.remove", (Object[])new Object[]{name, this.name});
                ((List)this.value).remove(name);
            } else {
                if (!((List)this.value).contains(name)) {
                    ((List)this.value).add(name);
                }
                end = class_2561.method_43469((String)"blockomorph.commands.option_change.list.add", (Object[])new Object[]{name, this.name});
            }
            Config.getInstance().writeAndSend();
            ((class_2168)args.getSource()).method_9226(() -> BlockListConfig.lambda$end$2((class_2561)end), true);
            return 1;
        }));
    }

    @Override
    public Command<class_2168> buildGetter() {
        return args -> {
            ((class_2168)args.getSource()).method_9226(() -> class_2561.method_43469((String)"blockomorph.commands.option_get.list", (Object[])new Object[]{this.name, ((List)this.value).size(), ((List)this.value).toString()}), true);
            return 1;
        };
    }

    public BlockListConfigRenderer getRenderer() {
        if (RENDERER == null) {
            RENDERER = new BlockListConfigRenderer();
        }
        return RENDERER;
    }

    private static /* synthetic */ class_2561 lambda$end$2(class_2561 end) {
        return end;
    }

    public record ListOptionContext(class_2960 frame, @Nullable Predicate<String> allowedAddValue, @Nullable Predicate<String> allowedRemoveValue, boolean canClear) {
    }
}

