/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonElement;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.blockomorph.screens.config.ConfigRenderer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigInstance<T> {
    private final List<DataFixer<T>> fixers = new ArrayList<DataFixer<T>>();
    protected final String name;
    protected T value;
    private final class_2561 tip;
    private final boolean canOperatorModify;

    protected ConfigInstance(String name, T initialValue, boolean canOperatorModify, @Nullable class_2561 tip) {
        this.name = name;
        this.value = initialValue;
        this.tip = tip;
        this.canOperatorModify = canOperatorModify;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public class_2561 getTooltip() {
        return this.tip;
    }

    public abstract void readFromStorage(JsonElement var1);

    public abstract JsonElement getDataForStorage();

    public abstract void parseFromUser(String var1);

    public abstract void readFromNetwork(class_2540 var1);

    public abstract void writeToNetwork(class_2540 var1);

    public boolean canEditedByOperators() {
        return this.canOperatorModify;
    }

    public abstract LiteralArgumentBuilder<class_2168> buildArgument(LiteralArgumentBuilder<class_2168> var1, class_7157 var2, class_2170.class_5364 var3);

    public Command<class_2168> buildGetter() {
        return args -> {
            ((class_2168)args.getSource()).method_9226(() -> class_2561.method_43469((String)"blockomorph.commands.option_get.default", (Object[])new Object[]{this.name, this.value.toString()}), true);
            return 1;
        };
    }

    public List<ConfigInstance<?>> getEnterableInstances() {
        return List.of();
    }

    public abstract ConfigRenderer<?> getRenderer();

    public T setValue(T value) {
        this.value = value;
        return this.value;
    }

    public boolean trySetValue(ConfigInstance<?> instance) {
        try {
            this.value = instance.value;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final void fixOldData(JsonElement element, Runnable rewriteStart) {
        for (DataFixer<T> fixer : this.fixers) {
            T value = fixer.fix(this, element, rewriteStart);
            if (value == null) continue;
            this.value = value;
        }
    }

    public final ConfigInstance<T> boundDataFixer(DataFixer<T> fixer) {
        this.fixers.add(fixer);
        return this;
    }

    public T getValue() {
        return this.value;
    }

    @FunctionalInterface
    public static interface DataFixer<VALUE> {
        public VALUE fix(ConfigInstance<VALUE> var1, JsonElement var2, Runnable var3);
    }
}

