/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.coords;

import java.util.Objects;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.jetbrains.annotations.Nullable;

public class PlayerMorphedSection {
    public static final int MAX_SIZE = 31;
    public static final int FOR_TWO_CHUNKS = 32;
    public final int x;
    public final int z;

    public PlayerMorphedSection(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public PlayerMorphedSection(long encoded) {
        this.x = (int)encoded;
        this.z = (int)(encoded >> 32);
    }

    @Nullable
    public static class_1657 getPlayerByChunkPos(class_1923 real, @Nullable Boolean client) {
        if (!InPlayerBlockPos.isMorphPlayerChunk(real)) {
            return null;
        }
        class_2338 bounded = new class_2338((class_2382)real.method_35231(7, 0, 7));
        PlayerMorphedSection section = BlockPosBounds.getPlayerSectionPos(bounded);
        return BlockPosBounds.getPlayerByChunkPos(section, client);
    }

    public long toLong() {
        return class_1923.method_8331((int)this.x, (int)this.z);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PlayerMorphedSection) {
            PlayerMorphedSection section = (PlayerMorphedSection)obj;
            return section.x == this.x && section.z == this.z;
        }
        return false;
    }

    public String toString() {
        return "PlayerMorphedSection[" + this.x + ", " + this.z + "]";
    }
}

