/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.hit;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.ClipContextAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3959;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class PlayerHitResult {
    public static final Predicate<class_1297> NOT_MORPHED_PLAYER = entity -> {
        PlayerAccessor pl;
        return !(entity instanceof PlayerAccessor) || !(pl = (PlayerAccessor)entity).isFullActive();
    };
    private static final class_238 CUBE = class_259.method_1077().method_1107();

    @Nullable
    public static MorphedPlayerHitResult calculateMorphedPlayerHitResult(class_1937 lv, @Nullable class_1297 looker, class_243 eyePosition, class_243 reachVector, class_3959.class_3960 mode, class_3959.class_242 fluidMode) {
        class_238 areaBetweenAndReachEnd = new class_238(eyePosition, reachVector);
        List entities = lv.method_8335(looker, areaBetweenAndReachEnd);
        AtomicReference result = new AtomicReference();
        AtomicReference<Double> distanceToPartOfBlock = new AtomicReference<Double>((Double)Double.MAX_VALUE);
        for (class_1297 entity : entities) {
            PlayerAccessor mob;
            if (!(entity instanceof PlayerAccessor) || !(mob = (PlayerAccessor)entity).isFullActive()) continue;
            mob.getBlocksData2InArea(areaBetweenAndReachEnd, (TriConsumer<InPlayerBlockPos, BlockInPlayer2, class_243>)((TriConsumer)(offset, block, offsetPosInWorld) -> {
                for (class_238 partBlockShape : PlayerHitResult.getBoxesList(lv, offsetPosInWorld, block, mode, fluidMode, looker)) {
                    class_243 res;
                    double dist;
                    Optional partHitResult = partBlockShape.method_992(eyePosition, reachVector);
                    if (!partHitResult.isPresent() || !((dist = eyePosition.method_1022(res = (class_243)partHitResult.get())) < (Double)distanceToPartOfBlock.get()) && !PlayerHitResult.isMainBlock((MorphedPlayerHitResult)((Object)((Object)result.get())), res, offsetPosInWorld)) continue;
                    distanceToPartOfBlock.set(dist);
                    class_2350 dir = PlayerHitResult.calculateHitDirection(res, partBlockShape);
                    if (dir == null) continue;
                    class_243 inBlockOffset = new class_243(res.method_10216() - offsetPosInWorld.field_1352, res.method_10214() - offsetPosInWorld.field_1351, res.method_10215() - offsetPosInWorld.field_1350);
                    result.set(MorphedPlayerHitResult.of(mob, offset, dir, inBlockOffset.field_1352 == (double)((int)inBlockOffset.field_1352) || inBlockOffset.field_1351 == (double)((int)inBlockOffset.field_1351) || inBlockOffset.field_1350 == (double)((int)inBlockOffset.field_1350), inBlockOffset, res));
                }
            }));
        }
        return (MorphedPlayerHitResult)((Object)result.get());
    }

    private static List<class_238> getBoxesList(class_1937 lv, class_243 offsetPosInWorld, BlockInPlayer2 block, class_3959.class_3960 mode, class_3959.class_242 fluidMode, @Nullable class_1297 looker) {
        class_265 blockShape = mode.get(block.getBlockState(), (class_1922)lv, block.getPos(), looker != null ? class_3726.method_16195((class_1297)looker) : class_3726.method_16194());
        blockShape = blockShape.method_1096(offsetPosInWorld.field_1352, offsetPosInWorld.field_1351, offsetPosInWorld.field_1350);
        ArrayList<class_238> boxes = new ArrayList<class_238>(blockShape.method_1090());
        class_3610 fluidState = block.getBlockState().method_26227();
        if (block.shouldDoFluidAction() && fluidMode.method_17751(fluidState)) {
            class_265 fluidShape = fluidState.method_17776((class_1922)lv, block.getPos());
            fluidShape = fluidShape.method_1096(offsetPosInWorld.field_1352, offsetPosInWorld.field_1351, offsetPosInWorld.field_1350);
            boxes.addAll(fluidShape.method_1090());
        }
        return boxes;
    }

    private static boolean isMainBlock(MorphedPlayerHitResult oldHit, class_243 newVec, class_243 newBlockOffsetInWorld) {
        return oldHit != null && oldHit.getRealLocation().equals((Object)newVec) && PlayerHitResult.containsAABB(CUBE.method_997(newBlockOffsetInWorld), newVec);
    }

    private static class_2350 calculateHitDirection(class_243 hitVec, class_238 boundingBox) {
        double xDist = Math.min(Math.abs(hitVec.field_1352 - boundingBox.field_1323), Math.abs(hitVec.field_1352 - boundingBox.field_1320));
        double yDist = Math.min(Math.abs(hitVec.field_1351 - boundingBox.field_1322), Math.abs(hitVec.field_1351 - boundingBox.field_1325));
        double zDist = Math.min(Math.abs(hitVec.field_1350 - boundingBox.field_1321), Math.abs(hitVec.field_1350 - boundingBox.field_1324));
        if (xDist < yDist && xDist < zDist) {
            return hitVec.field_1352 < boundingBox.method_1005().field_1352 ? class_2350.field_11039 : class_2350.field_11034;
        }
        if (yDist < xDist && yDist < zDist) {
            return hitVec.field_1351 < boundingBox.method_1005().field_1351 ? class_2350.field_11033 : class_2350.field_11036;
        }
        return hitVec.field_1350 < boundingBox.method_1005().field_1350 ? class_2350.field_11043 : class_2350.field_11035;
    }

    private static boolean containsAABB(class_238 ab, class_243 tr) {
        double tolerance = 1.0E-7;
        double d = tr.field_1352;
        double e = tr.field_1351;
        double f = tr.field_1350;
        return d >= ab.field_1323 - tolerance && d <= ab.field_1320 + tolerance && e >= ab.field_1322 - tolerance && e <= ab.field_1325 + tolerance && f >= ab.field_1321 - tolerance && f <= ab.field_1324 + tolerance;
    }

    public static void checkHitResult(class_243 oldHitPos, class_3959 ctx, Consumer<MorphedPlayerHitResult> ifGood) {
        class_3727 context;
        class_1297 looker;
        class_3726 collisionContext = ClipContextAccessor.of(ctx).getContext();
        if (collisionContext instanceof class_3727 && (looker = (context = (class_3727)collisionContext).method_32480()) != null) {
            class_243 start = ctx.method_17750();
            MorphedPlayerHitResult hit = PlayerHitResult.calculateMorphedPlayerHitResult(looker.method_37908(), looker, start, ctx.method_17747(), ClipContextAccessor.of(ctx).getMode(), ClipContextAccessor.of(ctx).getFluidMode());
            if (hit != null && start.method_1022(hit.getRealLocation()) < start.method_1022(oldHitPos)) {
                ifGood.accept(hit);
            }
        }
    }
}

