/*
 * Decompiled with CFR 0.152.
 */
package io.silvicky.peace.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.silvicky.peace.StateSaver;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1311;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2277;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class Peace {
    public static final String TYPE = "type";
    public static final String RADIUS = "radius";
    public static final String CENTER = "center";
    public static final String DIMENSION = "dimension";
    public static final SimpleCommandExceptionType ERR_TYPE = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid mob type!"));
    public static final SimpleCommandExceptionType ERR_POS = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid position!"));
    public static final SimpleCommandExceptionType ERR_DIMENSION = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid dimension!"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"peace").requires(source -> source.method_9259(2))).executes(context -> Peace.help((class_2168)context.getSource()))).then(class_2170.method_9244((String)TYPE, (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)RADIUS, (ArgumentType)LongArgumentType.longArg()).executes(ctx -> Peace.updatePeace(StringArgumentType.getString((CommandContext)ctx, (String)TYPE), LongArgumentType.getLong((CommandContext)ctx, (String)RADIUS), (class_2168)ctx.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CENTER, (ArgumentType)class_2277.method_9737()).executes(ctx -> Peace.updatePeace(StringArgumentType.getString((CommandContext)ctx, (String)TYPE), LongArgumentType.getLong((CommandContext)ctx, (String)RADIUS), class_2277.method_9736((CommandContext)ctx, (String)CENTER), (class_2168)ctx.getSource()))).then(class_2170.method_9244((String)DIMENSION, (ArgumentType)class_2181.method_9288()).executes(ctx -> Peace.updatePeace(StringArgumentType.getString((CommandContext)ctx, (String)TYPE), LongArgumentType.getLong((CommandContext)ctx, (String)RADIUS), class_2277.method_9736((CommandContext)ctx, (String)CENTER), class_2181.method_9289((CommandContext)ctx, (String)DIMENSION), (class_2168)ctx.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(ctx -> Peace.listPeace(null, null, (class_2168)ctx.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)TYPE, (ArgumentType)StringArgumentType.string()).executes(ctx -> Peace.listPeace(StringArgumentType.getString((CommandContext)ctx, (String)TYPE), null, (class_2168)ctx.getSource()))).then(class_2170.method_9244((String)DIMENSION, (ArgumentType)class_2181.method_9288()).executes(ctx -> Peace.listPeace(StringArgumentType.getString((CommandContext)ctx, (String)TYPE), class_2181.method_9289((CommandContext)ctx, (String)DIMENSION), (class_2168)ctx.getSource()))))).then(class_2170.method_9244((String)DIMENSION, (ArgumentType)class_2181.method_9288()).executes(ctx -> Peace.listPeace(null, class_2181.method_9289((CommandContext)ctx, (String)DIMENSION), (class_2168)ctx.getSource())))));
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Usage: /peace <type> <radius> [<center>] [<dimension>]"), false);
        source.method_9226(() -> class_2561.method_43470((String)"Disable mob spawn in a sphere."), false);
        source.method_9226(() -> class_2561.method_43470((String)"Set radius to negative to remove a rule."), false);
        return 1;
    }

    public static int updatePeace(String type, long radius, class_2168 source) throws CommandSyntaxException {
        return Peace.updatePeace(type, radius, source.method_9222(), source.method_9225(), source);
    }

    public static int updatePeace(String type, long radius, class_243 center, class_2168 source) throws CommandSyntaxException {
        return Peace.updatePeace(type, radius, center, source.method_9225(), source);
    }

    public static class_1311 getSpawnGroup(String type) {
        if (type == null) {
            return null;
        }
        for (class_1311 i : class_1311.values()) {
            if (!i.method_6133().equals(type)) continue;
            return i;
        }
        return null;
    }

    public static class_2382 v3dToV3i(class_243 vec3d) {
        return new class_2382((int)Math.floor(vec3d.field_1352), (int)Math.floor(vec3d.field_1351), (int)Math.floor(vec3d.field_1350));
    }

    public static class_243 v3iToV3d(class_2382 vec3i) {
        return new class_243((double)vec3i.method_10263() + 0.5, (double)vec3i.method_10264() + 0.5, (double)vec3i.method_10260() + 0.5);
    }

    public static String v3iToString(class_2382 vec3i) {
        return vec3i.method_10263() + "," + vec3i.method_10264() + "," + vec3i.method_10260();
    }

    public static class_2382 stringToV3i(String s) {
        String[] t = s.split(",");
        if (t.length < 3) {
            throw new NumberFormatException(s);
        }
        return new class_2382(Integer.parseInt(t[0]), Integer.parseInt(t[1]), Integer.parseInt(t[2]));
    }

    public static int updatePeace(String type, long radius, class_243 center, class_3218 dimension, class_2168 source) throws CommandSyntaxException {
        HashMap<class_1311, HashMap<class_2382, Long>> mp2;
        if (center == null) {
            throw ERR_POS.create();
        }
        if (dimension == null) {
            throw ERR_DIMENSION.create();
        }
        class_1311 spawnGroup = Peace.getSpawnGroup(type);
        if (spawnGroup == null) {
            throw ERR_TYPE.create();
        }
        HashMap<class_2960, HashMap<class_1311, HashMap<class_2382, Long>>> mp = StateSaver.getServerState((MinecraftServer)dimension.method_8503()).mp;
        if (!mp.containsKey(dimension.method_27983().method_29177())) {
            mp.put(dimension.method_27983().method_29177(), new HashMap());
        }
        if (!(mp2 = mp.get(dimension.method_27983().method_29177())).containsKey(spawnGroup)) {
            mp2.put(spawnGroup, new HashMap());
        }
        HashMap<class_2382, Long> mp3 = mp2.get(spawnGroup);
        class_2382 center2 = Peace.v3dToV3i(center);
        if (radius < 0L) {
            mp3.remove(center2);
        } else {
            mp3.put(center2, radius);
        }
        source.method_9226(() -> class_2561.method_43470((String)"Done."), false);
        return 1;
    }

    public static int listPeace(String type, class_3218 dimension, class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Current peace ranges:"), false);
        class_1311 spawnGroup = Peace.getSpawnGroup(type);
        HashMap<class_2960, HashMap<class_1311, HashMap<class_2382, Long>>> mp = StateSaver.getServerState((MinecraftServer)source.method_9211()).mp;
        for (Map.Entry<class_2960, HashMap<class_1311, HashMap<class_2382, Long>>> entry : mp.entrySet()) {
            if (dimension != null && !entry.getKey().equals((Object)dimension.method_27983().method_29177())) continue;
            for (Map.Entry<class_1311, HashMap<class_2382, Long>> entry1 : entry.getValue().entrySet()) {
                if (spawnGroup != null && !entry1.getKey().equals((Object)spawnGroup)) continue;
                for (Map.Entry<class_2382, Long> entry2 : entry1.getValue().entrySet()) {
                    source.method_9226(() -> class_2561.method_43470((String)(String.valueOf(entry.getKey()) + " " + ((class_1311)entry1.getKey()).method_15434() + " " + String.valueOf(entry2.getKey()) + " " + String.valueOf(entry2.getValue()))), false);
                }
            }
        }
        return 1;
    }
}

