/*
 * Decompiled with CFR 0.152.
 */
package com.nenio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.nenio.StackManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.FMLPaths;

public final class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("stackmanager_items.json");
    private static final int FORMAT_VERSION = 1;
    private static volatile boolean DISCOVERY_MODE = false;
    private static final Map<Item, Integer> RUNTIME_OVERRIDES = new IdentityHashMap<Item, Integer>();
    private static Data DATA = new Data();
    private static final int NETWORK_CAP = 99;

    public static int networkCap() {
        return 99;
    }

    public static void bootstrap() {
        Map<String, Integer> discovered = ConfigManager.discoverAllItemsWithDefaultStacks();
        Data onDisk = ConfigManager.readIfExists();
        Data merged = ConfigManager.merge(onDisk, discovered);
        ConfigManager.write(merged);
        DATA = merged;
        ConfigManager.rebuildRuntimeCache();
    }

    public static ReloadStats reloadAndReport() {
        Map<String, Integer> discovered = ConfigManager.discoverAllItemsWithDefaultStacks();
        Data onDisk = ConfigManager.readIfExists();
        HashSet<String> before = onDisk != null && onDisk.items != null ? new HashSet<String>(onDisk.items.keySet()) : Collections.emptySet();
        Data merged = ConfigManager.merge(onDisk, discovered);
        int added = 0;
        for (String k : merged.items.keySet()) {
            if (before.contains(k)) continue;
            ++added;
        }
        ConfigManager.write(merged);
        DATA = merged;
        ConfigManager.rebuildRuntimeCache();
        return new ReloadStats(merged.items.size(), added);
    }

    public static int size() {
        return ConfigManager.DATA.items.size();
    }

    public static boolean isDiscoveryMode() {
        return DISCOVERY_MODE;
    }

    public static Integer getOverrideFor(Item item) {
        return RUNTIME_OVERRIDES.get(item);
    }

    private static void rebuildRuntimeCache() {
        RUNTIME_OVERRIDES.clear();
        for (Map.Entry<String, Integer> e : ConfigManager.DATA.items.entrySet()) {
            Item item;
            ResourceLocation id = ResourceLocation.tryParse((String)e.getKey());
            if (id == null || (item = BuiltInRegistries.ITEM.containsKey(id) ? (Item)BuiltInRegistries.ITEM.getValue(id) : null) == null) continue;
            RUNTIME_OVERRIDES.put(item, ConfigManager.clamp(e.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> discoverAllItemsWithDefaultStacks() {
        record Pair(ResourceLocation id, Item item) {
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Item item : BuiltInRegistries.ITEM) {
            list.add(new Pair(BuiltInRegistries.ITEM.getKey((Object)item), item));
        }
        list.sort(Comparator.comparing(p -> p.id().getNamespace()).thenComparing(p -> p.id().getPath()));
        LinkedHashMap<String, Integer> out = new LinkedHashMap<String, Integer>();
        DISCOVERY_MODE = true;
        try {
            for (Pair p2 : list) {
                int def = new ItemStack((ItemLike)p2.item()).getMaxStackSize();
                out.put(p2.id().toString(), def);
            }
        }
        finally {
            DISCOVERY_MODE = false;
        }
        return out;
    }

    private static Data merge(Data onDisk, Map<String, Integer> discovered) {
        Data result = new Data();
        result.formatVersion = 1;
        if (onDisk != null && onDisk.items != null) {
            result.items.putAll(onDisk.items);
        }
        for (Map.Entry<String, Integer> e : discovered.entrySet()) {
            result.items.putIfAbsent(e.getKey(), e.getValue());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Data readIfExists() {
        if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader r = Files.newBufferedReader(CONFIG_PATH);){
            Data d = (Data)GSON.fromJson((Reader)r, Data.class);
            if (d == null) {
                Data data2 = null;
                return data2;
            }
            if (d.items == null) {
                d.items = new LinkedHashMap();
            }
            Data data = d;
            return data;
        }
        catch (IOException e) {
            StackManager.LOGGER.error("Failed to read config file: {}", (Object)CONFIG_PATH, (Object)e);
            return null;
        }
    }

    private static void write(Data d) {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)d, (Appendable)w);
            }
        }
        catch (IOException e) {
            StackManager.LOGGER.error("Failed to save config file: {}", (Object)CONFIG_PATH, (Object)e);
        }
    }

    private static int clamp(int v) {
        return Math.max(1, Math.min(99, v));
    }

    public static SetResult setAndSave(ResourceLocation id, int value) {
        Item it = BuiltInRegistries.ITEM.get(id).map(Holder::value).orElse(null);
        if (it == null || BuiltInRegistries.ITEM.getKey((Object)it).equals((Object)BuiltInRegistries.ITEM.getDefaultKey())) {
            return new SetResult(false, null, value);
        }
        int clamped = ConfigManager.clamp(value);
        if (ConfigManager.DATA.items == null) {
            ConfigManager.DATA.items = new LinkedHashMap();
        }
        String key = id.toString();
        Integer prev = ConfigManager.DATA.items.put(key, clamped);
        RUNTIME_OVERRIDES.put(it, clamped);
        ConfigManager.write(DATA);
        return new SetResult(true, prev, clamped);
    }

    public static SetResult setToDefaultAndSave(ResourceLocation id) {
        int def;
        Item it = BuiltInRegistries.ITEM.get(id).map(Holder::value).orElse(null);
        if (it == null || BuiltInRegistries.ITEM.getKey((Object)it).equals((Object)BuiltInRegistries.ITEM.getDefaultKey())) {
            return new SetResult(false, null, -1);
        }
        DISCOVERY_MODE = true;
        try {
            def = new ItemStack((ItemLike)it).getMaxStackSize();
        }
        finally {
            DISCOVERY_MODE = false;
        }
        int clamped = ConfigManager.clamp(def);
        if (ConfigManager.DATA.items == null) {
            ConfigManager.DATA.items = new LinkedHashMap();
        }
        String key = id.toString();
        Integer prev = ConfigManager.DATA.items.put(key, clamped);
        RUNTIME_OVERRIDES.put(it, clamped);
        ConfigManager.write(DATA);
        return new SetResult(true, prev, clamped);
    }

    static final class Data {
        @SerializedName(value="formatVersion")
        int formatVersion = 1;
        @SerializedName(value="items")
        LinkedHashMap<String, Integer> items = new LinkedHashMap();

        Data() {
        }
    }

    public static final class ReloadStats {
        public final int total;
        public final int added;

        public ReloadStats(int total, int added) {
            this.total = total;
            this.added = added;
        }
    }

    public static final class SetResult {
        public final boolean ok;
        public final Integer prevValue;
        public final int newValue;

        SetResult(boolean ok, Integer prevValue, int newValue) {
            this.ok = ok;
            this.prevValue = prevValue;
            this.newValue = newValue;
        }
    }
}

