/*
 * Decompiled with CFR 0.152.
 */
package com.nenio;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.nenio.ConfigManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public final class StackManagerCommands {
    private StackManagerCommands() {
    }

    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stackmanager").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"reload").executes(ctx -> {
            ConfigManager.ReloadStats stats = ConfigManager.reloadAndReport();
            String msg = "StackManager: Reloaded. Entries=" + stats.total + ", newly added=" + stats.added + ".";
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)msg), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests((c, b) -> SharedSuggestionProvider.suggestResource((Iterable)BuiltInRegistries.ITEM.keySet(), (SuggestionsBuilder)b)).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9999)).executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.getId((CommandContext)ctx, (String)"item");
            int value = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            ConfigManager.SetResult res = ConfigManager.setAndSave(id, value);
            String msg = res.ok ? "Set " + String.valueOf(id) + " -> " + res.newValue + (String)(res.prevValue == null ? " (new entry)" : " (was " + res.prevValue + ")") : "Item not found: " + String.valueOf(id);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)msg), true);
            return res.ok ? 1 : 0;
        })))).then(Commands.literal((String)"default").executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.getId((CommandContext)ctx, (String)"item");
            ConfigManager.SetResult res = ConfigManager.setToDefaultAndSave(id);
            String msg = res.ok ? "Reset " + String.valueOf(id) + " to default -> " + res.newValue + (String)(res.prevValue == null ? " (new entry)" : " (was " + res.prevValue + ")") : "Item not found: " + String.valueOf(id);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)msg), true);
            return res.ok ? 1 : 0;
        }))));
    }
}

