/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.mixin;

import com.nenio.ConfigManager;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Slot.class}, priority=3000)
public abstract class StackManagerSlotMixin {
    @Shadow
    public abstract ItemStack getItem();

    @Inject(method={"getMaxStackSize(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void stackmanager$setFinalLimit(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (ConfigManager.isDiscoveryMode() || stack == null || stack.isEmpty()) {
            return;
        }
        Integer override = ConfigManager.getOverrideFor(stack.getItem());
        if (override != null) {
            int cap = Math.min(Math.max(1, override), ConfigManager.networkCap());
            if (cir.getReturnValueI() != cap) {
                cir.setReturnValue((Object)cap);
            }
        } else {
            if (cir.getReturnValueI() < 1) {
                cir.setReturnValue((Object)1);
            }
            if (cir.getReturnValueI() > ConfigManager.networkCap()) {
                cir.setReturnValue((Object)ConfigManager.networkCap());
            }
        }
    }

    @Inject(method={"getMaxStackSize()I"}, at={@At(value="RETURN")}, cancellable=true)
    private void stackmanager$raiseEmptySlotCeiling(CallbackInfoReturnable<Integer> cir) {
        if (ConfigManager.isDiscoveryMode()) {
            return;
        }
        ItemStack current = this.getItem();
        if (!current.isEmpty()) {
            Integer override = ConfigManager.getOverrideFor(current.getItem());
            if (override != null) {
                int cap = Math.min(Math.max(1, override), ConfigManager.networkCap());
                if (cap > cir.getReturnValueI()) {
                    cir.setReturnValue((Object)cap);
                }
            } else {
                int v = Math.max(1, Math.min(cir.getReturnValueI(), ConfigManager.networkCap()));
                if (v != cir.getReturnValueI()) {
                    cir.setReturnValue((Object)v);
                }
            }
        } else {
            int cap = ConfigManager.networkCap();
            if (cir.getReturnValueI() < cap) {
                cir.setReturnValue((Object)cap);
            }
        }
    }
}

