/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.mixin;

import com.nenio.ConfigManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class}, priority=3000)
public abstract class StackManagerItemStackMixin {
    @Shadow
    public abstract Item getItem();

    @Inject(method={"getMaxStackSize"}, at={@At(value="RETURN")}, cancellable=true)
    private void stackmanager$setFinal(CallbackInfoReturnable<Integer> cir) {
        if (ConfigManager.isDiscoveryMode()) {
            return;
        }
        Integer v = ConfigManager.getOverrideFor(this.getItem());
        if (v != null) {
            int cap = Math.min(v, ConfigManager.networkCap());
            cir.setReturnValue((Object)Math.max(1, cap));
        }
    }
}

