/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.mixin;

import com.nenio.ConfigManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class}, priority=3000)
public abstract class StackManagerItemStackCountClampMixin {
    @Shadow
    public abstract Item getItem();

    @Inject(method={"getCount"}, at={@At(value="RETURN")}, cancellable=true)
    private void stackmanager$clampCount(CallbackInfoReturnable<Integer> cir) {
        if (ConfigManager.isDiscoveryMode()) {
            return;
        }
        int v = cir.getReturnValueI();
        int cap = ConfigManager.networkCap();
        Integer override = ConfigManager.getOverrideFor(this.getItem());
        if (override != null) {
            cap = Math.min(cap, Math.max(1, override));
        }
        if (v > cap) {
            cir.setReturnValue((Object)cap);
        }
    }
}

