/*
 * Decompiled with CFR 0.152.
 */
package com.dbrighthd.regexmod.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class RegexCache {
    private static final Map<String, Pattern> REGEX_CACHE = new ConcurrentHashMap<String, Pattern>();

    private RegexCache() {
    }

    public static Pattern getOrCompilePattern(String regex, int flags) {
        String key = flags + ":" + regex;
        return REGEX_CACHE.computeIfAbsent(key, k -> Pattern.compile(regex, flags));
    }

    public static void clear() {
        REGEX_CACHE.clear();
    }
}

