/*
 * Decompiled with CFR 0.152.
 */
package com.dbrighthd.regexmod.selector;

import com.dbrighthd.regexmod.cache.StringPool;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10439;
import net.minecraft.class_10451;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class RegexModelSelector<T>
implements class_10451.class_10722<T> {
    private static final int MAX_DYNAMIC_MATCHES = 2048;
    private final Map<String, class_10439> dynamicCache = new LinkedHashMap<String, class_10439>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, class_10439> eldest) {
            return this.size() > 2048;
        }
    };
    private final Object2ObjectOpenHashMap<T, class_10439> exactMatches;
    private final List<Pair<Pattern, class_10439>> regexCases;
    private final class_10439 fallback;

    public RegexModelSelector(Object2ObjectOpenHashMap<T, class_10439> exactMatches, List<Pair<Pattern, class_10439>> regexCases, class_10439 fallback) {
        this.exactMatches = exactMatches;
        this.regexCases = regexCases;
        this.fallback = fallback;
    }

    public class_10439 get(T value, class_638 world) {
        class_10439 m = (class_10439)this.exactMatches.get(value);
        if (m != this.fallback) {
            return m;
        }
        String s = null;
        if (value instanceof class_2561) {
            class_2561 tv = (class_2561)value;
            s = tv.getString();
        } else if (value instanceof class_2960) {
            class_2960 id = (class_2960)value;
            s = id.toString();
        } else if (value instanceof String) {
            String str;
            s = str = (String)value;
        }
        s = StringPool.canonical(s);
        if (s == null) {
            return this.fallback;
        }
        class_10439 cached = this.dynamicCache.get(s);
        if (cached != null) {
            return cached;
        }
        for (Pair<Pattern, class_10439> rc : this.regexCases) {
            if (!((Pattern)rc.getFirst()).matcher(s).matches()) continue;
            this.dynamicCache.put(s, (class_10439)rc.getSecond());
            return (class_10439)rc.getSecond();
        }
        this.dynamicCache.put(s, this.fallback);
        return this.fallback;
    }
}

