/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.su5ed.somnia.SomniaConfig;
import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import dev.su5ed.somnia.util.FatigueDisplayPosition;
import dev.su5ed.somnia.util.ScreenPosition;
import dev.su5ed.somnia.util.SideEffectStage;
import dev.su5ed.somnia.util.SpeedColor;
import java.text.DecimalFormat;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;

public class ClientSleepHandler {
    public static final ClientSleepHandler INSTANCE = new ClientSleepHandler();
    private static final DecimalFormat FATIGUE_FORMAT = new DecimalFormat("0.00");
    private static final DecimalFormat MULTIPLIER_FORMAT = new DecimalFormat("0.0");
    private static final ItemStack CLOCK = new ItemStack((ItemLike)Items.CLOCK);
    private final Minecraft mc = Minecraft.getInstance();
    private final Deque<Double> speedValues = new LinkedBlockingDeque<Double>();
    public long sleepStartTime = -1L;
    private boolean muted;
    private double previousVolume;

    public void addSpeedValue(double speed) {
        this.speedValues.add(speed);
        if (this.speedValues.size() > 5) {
            this.speedValues.removeFirst();
        }
    }

    @SubscribeEvent
    public void clientTick(ClientTickEvent.Post event) {
        if (this.mc.player != null) {
            if (this.mc.player.isSleeping() && ((Boolean)SomniaConfig.COMMON.muteSoundWhenSleeping.get()).booleanValue() && !this.muted) {
                this.muted = true;
                OptionInstance option = this.mc.options.getSoundSourceOptionInstance(SoundSource.MASTER);
                this.previousVolume = (Double)option.get();
                option.set((Object)0.0);
            } else if (this.muted) {
                this.muted = false;
                this.mc.options.getSoundSourceOptionInstance(SoundSource.MASTER).set((Object)this.previousVolume);
            }
        }
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        this.sleepStartTime = -1L;
        this.speedValues.clear();
    }

    public void renderGuiOverlay(GuiGraphics guiGraphics, DeltaTracker tracker) {
        if (!(this.mc.screen == null || this.mc.screen instanceof PauseScreen || this.mc.player != null && this.mc.player.isSleeping())) {
            return;
        }
        Fatigue fatigue = (Fatigue)this.mc.player.getCapability(CapabilityFatigue.INSTANCE);
        if (fatigue != null) {
            double fatigueAmount = fatigue.getFatigue();
            if (((Boolean)SomniaConfig.COMMON.enableFatigue.get()).booleanValue() && !this.mc.player.isCreative() && !this.mc.player.isSpectator() && !this.mc.options.hideGui && (this.mc.player.isSleeping() || ((Boolean)SomniaConfig.COMMON.fatigueSideEffects.get()).booleanValue() || fatigueAmount <= (double)((Integer)SomniaConfig.COMMON.minimumFatigueToSleep.get()).intValue())) {
                this.renderFatigueDisplay(guiGraphics, fatigueAmount);
            }
        }
    }

    @SubscribeEvent
    public void screenRenderPost(ScreenEvent.Render.Post event) {
        Fatigue fatigue;
        Screen screen = event.getScreen();
        if (screen instanceof InBedChatScreen && ((Boolean)SomniaConfig.CLIENT.somniaGui.get()).booleanValue() && !this.speedValues.isEmpty() && (fatigue = (Fatigue)this.mc.player.getCapability(CapabilityFatigue.INSTANCE)) != null) {
            double currentSpeed = this.speedValues.getLast();
            if (currentSpeed != 0.0) {
                if (this.sleepStartTime == -1L) {
                    this.sleepStartTime = this.mc.player.level().getGameTime();
                }
            } else {
                this.sleepStartTime = -1L;
            }
            if (this.mc.screen != null && fatigue.getWakeTime() != -1L && currentSpeed != 0.0) {
                this.renderSleepOverlay(event.getGuiGraphics(), this.mc.screen, fatigue, currentSpeed);
            }
        }
    }

    private void renderFatigueDisplay(GuiGraphics guigraphics, double fatigue) {
        FatigueDisplayPosition pos;
        FatigueDisplayPosition fatigueDisplayPosition = pos = this.mc.player.isSleeping() ? FatigueDisplayPosition.BOTTOM_RIGHT : (FatigueDisplayPosition)((Object)SomniaConfig.CLIENT.fatigueDisplayPos.get());
        if (pos != FatigueDisplayPosition.NONE) {
            String str = String.valueOf(SpeedColor.WHITE.color) + ((Boolean)SomniaConfig.CLIENT.simpleFatigueDisplay.get() != false ? SideEffectStage.getSideEffectStageDescription(fatigue) : I18n.get((String)"somnia.gui.fatigue", (Object[])new Object[]{FATIGUE_FORMAT.format(fatigue)}));
            int width = this.mc.font.width(str);
            int scaledWidth = this.mc.getWindow().getGuiScaledWidth();
            int scaledHeight = this.mc.getWindow().getGuiScaledHeight();
            Font font = this.mc.font;
            int n = pos.getX(scaledWidth, width);
            Objects.requireNonNull(this.mc.font);
            guigraphics.drawString(font, str, n, pos.getY(scaledHeight, 9), Integer.MIN_VALUE, false);
        }
    }

    private void renderSleepOverlay(GuiGraphics guiGraphics, Screen screen, Fatigue fatigue, double currentSpeed) {
        long wakeTime = fatigue.getWakeTime();
        double sleepDuration = this.mc.level.getGameTime() - this.sleepStartTime;
        double remaining = wakeTime - this.sleepStartTime;
        double progress = sleepDuration / remaining;
        int width = screen.width - 40;
        this.renderProgressBar(guiGraphics, width, progress);
        ScreenPosition displayETASleep = (ScreenPosition)((Object)SomniaConfig.CLIENT.displayETASleep.get());
        if (displayETASleep != ScreenPosition.NONE) {
            int offsetX = displayETASleep == ScreenPosition.CENTER ? screen.width / 2 - 80 : (displayETASleep == ScreenPosition.RIGHT ? width - 160 : 0);
            this.renderScaledString(guiGraphics, offsetX + 20, String.format("%sx%s", SpeedColor.getColorForSpeed((double)currentSpeed).color, MULTIPLIER_FORMAT.format(currentSpeed)));
            double average = this.speedValues.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).summaryStatistics().getAverage();
            long eta = Math.round((remaining - sleepDuration) / (average * 20.0));
            this.renderScaledString(guiGraphics, offsetX + 80, this.getETAString(eta));
        }
        this.renderClock(guiGraphics, width);
    }

    private String getETAString(long totalSeconds) {
        long etaSeconds = totalSeconds % 60L;
        long etaMinutes = (totalSeconds - etaSeconds) / 60L;
        return String.format(String.valueOf(SpeedColor.WHITE.color) + "(%s:%s)", (etaMinutes < 10L ? "0" : "") + etaMinutes, (etaSeconds < 10L ? "0" : "") + etaSeconds);
    }

    private void renderProgressBar(GuiGraphics poseStack, int width, double progress) {
        this.doRenderProgressBar(poseStack, Gui.EXPERIENCE_BAR_PROGRESS_SPRITE, width, 1.0, 0.2f);
        this.doRenderProgressBar(poseStack, Gui.EXPERIENCE_BAR_PROGRESS_SPRITE, width, progress, 1.0f);
    }

    private void doRenderProgressBar(GuiGraphics guiGraphics, ResourceLocation sprite, int width, double progress, float alpha) {
        TextureAtlasSprite textureAtlasSprite = Minecraft.getInstance().getGuiSprites().getSprite(sprite);
        int amount = (int)(progress * (double)width);
        int x = 20;
        while (amount > 0) {
            ClientSleepHandler.blit(guiGraphics, textureAtlasSprite, x, 10, 0, 0, Math.min(amount, 180), 5, 1.0f, 1.0f, 1.0f, alpha);
            amount -= 180;
            x += 180;
        }
    }

    private void renderScaledString(GuiGraphics guiGraphics, int x, String str) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, 20.0f, 0.0f);
        poseStack.scale(1.5f, 1.5f, 1.0f);
        guiGraphics.drawString(this.mc.font, str, 0, 0, Integer.MIN_VALUE);
        poseStack.popPose();
    }

    private void renderClock(GuiGraphics guiGraphics, int width) {
        int x;
        switch ((ScreenPosition)((Object)SomniaConfig.CLIENT.somniaGuiClockPosition.get())) {
            case LEFT: {
                int n = 40;
                break;
            }
            case CENTER: {
                int n = width / 2;
                break;
            }
            case RIGHT: {
                int n = width - 40;
                break;
            }
            default: {
                int n = x = -1;
            }
        }
        if (x != -1) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)x, 35.0f, 0.0f);
            poseStack.scale(4.0f, 4.0f, 1.0f);
            guiGraphics.renderItem(CLOCK, 0, 0);
            poseStack.popPose();
        }
    }

    private static void blit(GuiGraphics guiGraphics, TextureAtlasSprite sprite, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight, float red, float green, float blue, float alpha) {
        float f = sprite.getU1() - sprite.getU0();
        float maxU = sprite.getU0() + f * ((float)uWidth / 180.0f);
        guiGraphics.innerBlit(sprite.atlasLocation(), x, x + uWidth, y, y + vHeight, 0, sprite.getU0(), maxU, sprite.getV0(), sprite.getV1(), red, green, blue, alpha);
    }
}

