/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia;

import dev.su5ed.somnia.ClientSetup;
import dev.su5ed.somnia.ClientSleepHandler;
import dev.su5ed.somnia.SomniaConfig;
import dev.su5ed.somnia.SomniaObjects;
import dev.su5ed.somnia.compat.Compat;
import dev.su5ed.somnia.network.SomniaNetwork;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="somnia")
public class SomniaAwoken {
    public static final String MODID = "somnia";
    public static final Logger LOGGER = LogManager.getLogger();

    public SomniaAwoken(IEventBus bus, Dist dist) {
        bus.addListener(this::setup);
        bus.addListener(SomniaObjects::registerCapabilities);
        NeoForge.EVENT_BUS.addListener(SomniaObjects::registerCommands);
        if (dist.isClient()) {
            bus.addListener(ClientSetup::registerGuiOverlays);
            NeoForge.EVENT_BUS.register((Object)ClientSleepHandler.INSTANCE);
        }
        bus.addListener(SomniaNetwork::registerMessages);
        SomniaObjects.register(bus);
        ModLoadingContext context = ModLoadingContext.get();
        ModContainer container = context.getActiveContainer();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SomniaConfig.COMMON_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SomniaConfig.CLIENT_SPEC);
    }

    private void setup(FMLCommonSetupEvent event) {
        ModList modList = ModList.get();
        Compat.comfortsLoaded = modList.isLoaded("comforts");
        Compat.curiosLoaded = modList.isLoaded("curios");
        Compat.darkUtilsLoaded = modList.isLoaded("darkutils");
    }
}

