/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import dev.su5ed.somnia.network.SomniaNetwork;
import dev.su5ed.somnia.network.client.FatigueUpdatePacket;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public final class SomniaCommand {
    public static final Set<UUID> OVERRIDES = new HashSet<UUID>();
    public static final int PERMISSION_LEVEL = 3;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"somnia").requires(src -> src.hasPermission(3))).then(Commands.literal((String)"fatigue").then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> SomniaCommand.setFatigue(DoubleArgumentType.getDouble((CommandContext)ctx, (String)"amount"), ((CommandSourceStack)ctx.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(ctx -> SomniaCommand.setFatigue(DoubleArgumentType.getDouble((CommandContext)ctx, (String)"amount"), EntityArgument.getPlayer((CommandContext)ctx, (String)"target")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"override").then(Commands.literal((String)"add").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(ctx -> SomniaCommand.addOverride(EntityArgument.getPlayer((CommandContext)ctx, (String)"target")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(ctx -> SomniaCommand.removeOverride(EntityArgument.getPlayer((CommandContext)ctx, (String)"target")))))).then(Commands.literal((String)"list").executes(SomniaCommand::listOverrides))));
    }

    private static int setFatigue(double amount, ServerPlayer player) {
        Fatigue fatigue = (Fatigue)player.getCapability(CapabilityFatigue.INSTANCE);
        if (fatigue != null) {
            fatigue.setFatigue(amount);
            SomniaNetwork.sendToClient(new FatigueUpdatePacket(fatigue.getFatigue()), player);
        }
        return 1;
    }

    private static int addOverride(ServerPlayer player) {
        if (!OVERRIDES.add(player.getUUID())) {
            player.displayClientMessage((Component)Component.literal((String)"Override already exists"), true);
        }
        return 1;
    }

    private static int removeOverride(ServerPlayer target) {
        OVERRIDES.remove(target.getUUID());
        return 1;
    }

    private static int listOverrides(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        List<String> overrides = OVERRIDES.stream().map(arg_0 -> ((Level)sender.level()).getPlayerByUUID(arg_0)).filter(Objects::nonNull).map(player -> player.getName().getString()).toList();
        MutableComponent chatComponent = Component.literal((String)(!overrides.isEmpty() ? String.join((CharSequence)", ", overrides) : "Nothing to see here..."));
        sender.displayClientMessage((Component)chatComponent, false);
        return 1;
    }

    private SomniaCommand() {
    }
}

