/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia;

import dev.su5ed.somnia.api.ReplenishingItem;
import dev.su5ed.somnia.util.FatigueDisplayPosition;
import dev.su5ed.somnia.util.ScreenPosition;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class SomniaConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON;
    public static final ClientConfig CLIENT;

    private SomniaConfig() {
    }

    static {
        Pair commonPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)commonPair.getLeft();
        COMMON_SPEC = (ModConfigSpec)commonPair.getRight();
        Pair clientPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)clientPair.getLeft();
        CLIENT_SPEC = (ModConfigSpec)clientPair.getRight();
    }

    public static final class CommonConfig {
        public final ModConfigSpec.BooleanValue enableFatigue;
        public final ModConfigSpec.DoubleValue fatigueRate;
        public final ModConfigSpec.DoubleValue fatigueReplenishRate;
        public final ModConfigSpec.BooleanValue fatigueSideEffects;
        public final ModConfigSpec.ConfigValue<Integer> minimumFatigueToSleep;
        public final ModConfigSpec.ConfigValue<List<? extends List<Object>>> sideEffectStages;
        public final ModConfigSpec.ConfigValue<List<? extends List<Object>>> replenishingItems;
        public final ModConfigSpec.DoubleValue delta;
        public final ModConfigSpec.DoubleValue minMultiplier;
        public final ModConfigSpec.DoubleValue maxMultiplier;
        public final ModConfigSpec.BooleanValue fading;
        public final ModConfigSpec.BooleanValue ignoreMonsters;
        public final ModConfigSpec.BooleanValue muteSoundWhenSleeping;
        public final ModConfigSpec.BooleanValue sleepWithArmor;
        public final ModConfigSpec.ConfigValue<String> wakeTimeSelectItem;
        public final ModConfigSpec.BooleanValue forceWakeUp;
        public final ModConfigSpec.BooleanValue disableCreatureSpawning;
        public final ModConfigSpec.IntValue enterSleepStart;
        public final ModConfigSpec.IntValue enterSleepEnd;
        public final ModConfigSpec.IntValue validSleepStart;
        public final ModConfigSpec.IntValue validSleepEnd;

        public CommonConfig(ModConfigSpec.Builder builder) {
            builder.push("fatigue");
            this.enableFatigue = builder.comment("Master fatigue system override. Setting this to false will disable all fatigue-related logic as well as all config options in this category.").define("enableFatigue", true);
            this.fatigueRate = builder.comment("Fatigue is incremented by this number every tick").defineInRange("fatigueRate", 0.00208, 0.0, 1.0);
            this.fatigueReplenishRate = builder.comment("Fatigue is decreased by this number every tick while you sleep").defineInRange("fatigueReplenishRate", 0.00833, 0.0, 1.0);
            this.fatigueSideEffects = builder.comment("Enables fatigue side effects").define("fatigueSideEffects", true);
            this.minimumFatigueToSleep = builder.comment("The required amount of fatigue to sleep").define("minimumFatigueToSleep", (Object)20);
            this.sideEffectStages = builder.comment("Definitions of each side effect stage in order: min fatigue (int), max fatigue (int), effect name (resource location), duration (int), amplifier (int). For a permanent effect, set the duration to -1.").defineList("sideEffectStages", List.of(List.of(Integer.valueOf(70), Integer.valueOf(80), "minecraft:nausea", Integer.valueOf(150), Integer.valueOf(0)), List.of(Integer.valueOf(80), Integer.valueOf(90), "minecraft:slowness", Integer.valueOf(300), Integer.valueOf(2)), List.of(Integer.valueOf(90), Integer.valueOf(95), "minecraft:poison", Integer.valueOf(200), Integer.valueOf(1)), List.of(Integer.valueOf(95), Integer.valueOf(100), "minecraft:nausea", Integer.valueOf(-1), Integer.valueOf(3))), obj -> obj instanceof List);
            this.replenishingItems = builder.comment("Definitions of fatigue replenishing items. Each list consist of an item registry name, the amount of fatigue it replenishes, and optionally a fatigue rate modifier").defineList("replenishingItems", List.of(List.of("coffeespawner:coffee", Integer.valueOf(10)), List.of("coffeespawner:coffee_milk", Integer.valueOf(10)), List.of("coffeespawner:coffee_sugar", Integer.valueOf(15)), List.of("coffeespawner:coffee_milk_sugar", Integer.valueOf(15))), obj -> obj instanceof List);
            builder.pop();
            builder.push("logic");
            this.delta = builder.comment("If the time difference (mc) between multiplied ticking is greater than this, the simulation multiplier is lowered. Otherwise, it's increased. Lowering this number might slow down simulation and improve performance. Don't mess around with it if you don't know what you're doing.").defineInRange("delta", 50.0, 1.0, 50.0);
            this.minMultiplier = builder.worldRestart().comment("Minimum tick speed multiplier, activated during sleep").defineInRange("minMultiplier", 1.0, 1.0, 100.0);
            this.maxMultiplier = builder.worldRestart().comment("Maximum tick speed multiplier, activated during sleep").defineInRange("maxMultiplier", 100.0, 1.0, 100.0);
            builder.pop();
            builder.push("options");
            this.fading = builder.comment("Slightly slower sleep start/end").define("fading", true);
            this.ignoreMonsters = builder.comment("Let the player sleep even when there are monsters nearby").define("ignoreMonsters", false);
            this.muteSoundWhenSleeping = builder.comment("Deafens you while you're asleep. Mob sounds are confusing with the world sped up").define("muteSoundWhenSleeping", false);
            this.sleepWithArmor = builder.comment("Allows you to sleep with armor equipped").define("sleepWithArmor", false);
            this.wakeTimeSelectItem = builder.comment("The item used to select wake time. Use an empty string to disable, or an asterisk ('*') to enable at all times.").define("wakeTimeSelectItem", (Object)"minecraft:clock");
            this.forceWakeUp = builder.comment("Force the player to wake up when fatigue reaches 0").define("forceWakeUp", false);
            builder.pop();
            builder.push("performance");
            this.disableCreatureSpawning = builder.comment("Disables mob spawning while you sleep").define("disableCreatureSpawning", false);
            builder.pop();
            builder.push("timings");
            this.enterSleepStart = builder.comment("Specifies the start of the period in which the player can enter sleep").defineInRange("enterSleepStart", 0, 0, 24000);
            this.enterSleepEnd = builder.comment("Specifies the end of the period in which the player can enter sleep").defineInRange("enterSleepEnd", 24000, 0, 24000);
            this.validSleepStart = builder.comment("Specifies the start of the valid sleep period").defineInRange("validSleepStart", 0, 0, 24000);
            this.validSleepEnd = builder.comment("Specifies the end of the valid sleep period").defineInRange("validSleepEnd", 24000, 0, 24000);
            builder.pop();
        }

        public List<ReplenishingItem> getReplenishingItems() {
            return ((List)this.replenishingItems.get()).stream().map(list -> {
                Item item = CommonConfig.getModItem((String)list.get(0));
                double replenishedFatigue = Double.parseDouble(list.get(1).toString());
                double fatigueRateModifier = list.size() > 2 ? Double.parseDouble(list.get(2).toString()) : (Double)this.fatigueRate.get();
                return new ReplenishingItem(item, replenishedFatigue, fatigueRateModifier);
            }).filter(replenishingItem -> replenishingItem.item() != null).toList();
        }

        public boolean isWakeTimeSelectionItem(ItemStack stack) {
            String matcher = (String)this.wakeTimeSelectItem.get();
            return !matcher.isEmpty() && (matcher.equals("*") || !stack.isEmpty() && BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().equals(matcher));
        }

        private static Item getModItem(String registryName) {
            return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)registryName));
        }
    }

    public static final class ClientConfig {
        public final ModConfigSpec.EnumValue<FatigueDisplayPosition> fatigueDisplayPos;
        public final ModConfigSpec.BooleanValue simpleFatigueDisplay;
        public final ModConfigSpec.EnumValue<ScreenPosition> displayETASleep;
        public final ModConfigSpec.BooleanValue somniaGui;
        public final ModConfigSpec.EnumValue<ScreenPosition> somniaGuiClockPosition;
        public final ModConfigSpec.BooleanValue disableRendering;

        public ClientConfig(ModConfigSpec.Builder builder) {
            builder.push("fatigue");
            this.fatigueDisplayPos = builder.comment("The fatigue counter's position").defineEnum("fatigueDisplayPos", (Enum)FatigueDisplayPosition.BOTTOM_RIGHT);
            this.simpleFatigueDisplay = builder.comment("Simplifies the numerical fatigue counter to words").define("simpleFatigueDisplay", false);
            this.displayETASleep = builder.comment("The ETA and multiplier display position in Somnia's sleep gui.").defineEnum("displayETASleep", (Enum)ScreenPosition.LEFT);
            builder.pop();
            builder.push("options");
            this.somniaGui = builder.comment("Provides an enhanced sleeping gui").define("somniaGui", true);
            this.somniaGuiClockPosition = builder.comment("The display position of the clock in somnia's enhanced sleeping gui.").defineEnum("somniaGuiClockPosition", (Enum)ScreenPosition.RIGHT);
            builder.pop();
            builder.push("performance");
            this.disableRendering = builder.comment("Disable rendering while you're asleep").define("disableRendering", false);
            builder.pop();
        }
    }
}

