/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia;

import dev.su5ed.somnia.SomniaConfig;
import dev.su5ed.somnia.SomniaObjects;
import dev.su5ed.somnia.api.SomniaAPI;
import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import dev.su5ed.somnia.compat.Compat;
import dev.su5ed.somnia.network.SomniaNetwork;
import dev.su5ed.somnia.network.client.FatigueUpdatePacket;
import dev.su5ed.somnia.network.client.OpenGUIPacket;
import dev.su5ed.somnia.util.SideEffectStage;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="somnia")
public final class SomniaEventHandler {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!((Boolean)SomniaConfig.COMMON.enableFatigue.get()).booleanValue() || player.level().isClientSide || !player.isAlive() || player.isCreative() || player.isSpectator() && !player.isSleeping()) {
            return;
        }
        Fatigue props = (Fatigue)player.getCapability(CapabilityFatigue.INSTANCE);
        if (props != null) {
            boolean isSleeping = props.sleepOverride() || player.isSleeping();
            double fatigueRate = (Double)SomniaConfig.COMMON.fatigueRate.get();
            double fatigueReplenishRate = (Double)SomniaConfig.COMMON.fatigueReplenishRate.get();
            double fatigue = props.getFatigue();
            double extraFatigueRate = props.getExtraFatigueRate();
            double replenishedFatigue = props.getReplenishedFatigue();
            if (fatigueRate > 0.0) {
                if (isSleeping) {
                    double share = fatigueReplenishRate / fatigueRate;
                    double replenish = fatigueReplenishRate * share;
                    fatigue -= fatigueReplenishRate;
                    extraFatigueRate -= fatigueRate / replenishedFatigue / 10.0;
                    replenishedFatigue -= replenish;
                } else {
                    MobEffectInstance insomnia;
                    double adjustedRate = fatigueRate;
                    MobEffectInstance wakefulness = player.getEffect(SomniaObjects.AWAKENING_EFFECT);
                    if (wakefulness != null) {
                        adjustedRate -= wakefulness.getAmplifier() == 0 ? adjustedRate / 4.0 : adjustedRate / 3.0;
                    }
                    if ((insomnia = player.getEffect(SomniaObjects.INSOMNIA_EFFECT)) != null) {
                        adjustedRate += insomnia.getAmplifier() == 0 ? adjustedRate / 2.0 : adjustedRate;
                    }
                    fatigue += adjustedRate + props.getExtraFatigueRate();
                }
            }
            fatigue = Mth.clamp((double)fatigue, (double)0.0, (double)100.0);
            replenishedFatigue = Mth.clamp((double)replenishedFatigue, (double)0.0, (double)100.0);
            if (extraFatigueRate < 0.0) {
                extraFatigueRate = 0.0;
            }
            props.setFatigue(fatigue);
            props.setReplenishedFatigue(replenishedFatigue);
            props.setExtraFatigueRate(extraFatigueRate);
            if (props.updateFatigueCounter()) {
                SomniaNetwork.sendToClient(new FatigueUpdatePacket(fatigue), (ServerPlayer)player);
                if (((Boolean)SomniaConfig.COMMON.fatigueSideEffects.get()).booleanValue()) {
                    int lastSideEffectStage = props.getSideEffectStage();
                    SideEffectStage[] stages = SideEffectStage.getSideEffectStages();
                    SideEffectStage firstStage = stages[0];
                    if (fatigue < (double)firstStage.minFatigue()) {
                        props.setSideEffectStage(-1);
                    }
                    for (SideEffectStage stage : stages) {
                        boolean permanent;
                        boolean bl = permanent = stage.duration() < 0;
                        if (!(fatigue >= (double)stage.minFatigue()) || !(fatigue <= (double)stage.maxFatigue())) continue;
                        props.setSideEffectStage(stage.minFatigue());
                        if (!permanent && lastSideEffectStage >= stage.minFatigue()) continue;
                        player.addEffect(new MobEffectInstance(stage.getEffect(), permanent ? 150 : stage.duration(), stage.amplifier()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (!level.isClientSide) {
            BlockPos pos = event.getPos();
            BlockState state = level.getBlockState(pos);
            Player player = event.getEntity();
            ItemStack stack = player.getInventory().getSelected();
            if (state.hasProperty((Property)HorizontalDirectionalBlock.FACING) && Compat.isBed(state, pos, (LevelAccessor)level, (LivingEntity)player) && ((ServerPlayer)player).bedInRange(pos, (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)) && SomniaConfig.COMMON.isWakeTimeSelectionItem(stack)) {
                SomniaNetwork.sendToClient(OpenGUIPacket.INSTANCE, (ServerPlayer)player);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUseItem(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        UseAnim action = stack.getUseAnimation();
        if (((Boolean)SomniaConfig.COMMON.enableFatigue.get()).booleanValue() && (action == UseAnim.EAT || action == UseAnim.DRINK)) {
            Item item = stack.getItem();
            Stream.concat(SomniaConfig.COMMON.getReplenishingItems().stream(), SomniaAPI.getReplenishingItems().stream()).filter(replenishingItem -> replenishingItem.item() == item).findFirst().ifPresent(replenishingItem -> Optional.ofNullable((Fatigue)event.getEntity().getCapability(CapabilityFatigue.INSTANCE)).ifPresent(props -> {
                double fatigue = props.getFatigue();
                double replenishedFatigue = props.getReplenishedFatigue();
                double fatigueToReplenish = Math.min(fatigue, replenishingItem.replenishedFatigue());
                double newFatigue = replenishedFatigue + fatigueToReplenish;
                props.setReplenishedFatigue(newFatigue);
                double baseMultiplier = replenishingItem.fatigueRateModifier();
                double multiplier = newFatigue * 4.0 * (Double)SomniaConfig.COMMON.fatigueRate.get();
                props.setExtraFatigueRate(props.getExtraFatigueRate() + baseMultiplier * multiplier);
                props.setFatigue(fatigue - fatigueToReplenish);
                props.maxFatigueCounter();
            }));
        }
    }

    private SomniaEventHandler() {
    }
}

