/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia;

import com.mojang.brigadier.CommandDispatcher;
import dev.su5ed.somnia.SomniaCommand;
import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import dev.su5ed.somnia.capability.FatigueStore;
import dev.su5ed.somnia.effect.AwakeningEffect;
import dev.su5ed.somnia.effect.InsomniaEffect;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public final class SomniaObjects {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((Registry)BuiltInRegistries.MOB_EFFECT, (String)"somnia");
    private static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((Registry)BuiltInRegistries.POTION, (String)"somnia");
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"somnia");
    public static final Holder<MobEffect> AWAKENING_EFFECT = MOB_EFFECTS.register("awakening", AwakeningEffect::new);
    public static final Holder<MobEffect> INSOMNIA_EFFECT = MOB_EFFECTS.register("insomnia", InsomniaEffect::new);
    public static final Holder<Potion> AWAKENING_POTION = POTIONS.register("awakening", () -> new Potion("awakening", new MobEffectInstance[]{new MobEffectInstance(AWAKENING_EFFECT, 2400)}));
    public static final Holder<Potion> LONG_AWAKENING_POTION = POTIONS.register("long_awakening", () -> new Potion("awakening", new MobEffectInstance[]{new MobEffectInstance(AWAKENING_EFFECT, 3600)}));
    public static final Holder<Potion> STRONG_AWAKENING_POTION = POTIONS.register("strong_awakening", () -> new Potion("awakening", new MobEffectInstance[]{new MobEffectInstance(AWAKENING_EFFECT, 2400, 1)}));
    public static final Holder<Potion> INSOMNIA_POTION = POTIONS.register("insomnia", () -> new Potion("insomnia", new MobEffectInstance[]{new MobEffectInstance(INSOMNIA_EFFECT, 1800)}));
    public static final Holder<Potion> LONG_INSOMNIA_POTION = POTIONS.register("long_insomnia", () -> new Potion("insomnia", new MobEffectInstance[]{new MobEffectInstance(INSOMNIA_EFFECT, 3000)}));
    public static final Holder<Potion> STRONG_INSOMNIA_POTION = POTIONS.register("strong_insomnia", () -> new Potion("insomnia", new MobEffectInstance[]{new MobEffectInstance(INSOMNIA_EFFECT, 1800, 1)}));
    public static final Supplier<AttachmentType<FatigueStore>> FATIGUE_ATTACHMENT = ATTACHMENT_TYPES.register("fatigue_store", () -> AttachmentType.builder(FatigueStore::new).serialize(FatigueStore.CODEC).copyOnDeath().build());

    static void register(IEventBus bus) {
        MOB_EFFECTS.register(bus);
        POTIONS.register(bus);
        ATTACHMENT_TYPES.register(bus);
    }

    static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(CapabilityFatigue.INSTANCE, EntityType.PLAYER, (player, unused) -> (Fatigue)player.getData(FATIGUE_ATTACHMENT));
    }

    static void registerCommands(RegisterCommandsEvent event) {
        SomniaCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder b = event.getBuilder();
        SomniaObjects.addBrewingRecipe(b, (Holder<Potion>)Potions.NIGHT_VISION, Items.GLISTERING_MELON_SLICE, AWAKENING_POTION);
        SomniaObjects.addBrewingRecipe(b, (Holder<Potion>)Potions.LONG_NIGHT_VISION, Items.GLISTERING_MELON_SLICE, LONG_AWAKENING_POTION);
        SomniaObjects.addBrewingRecipe(b, (Holder<Potion>)Potions.NIGHT_VISION, Items.BLAZE_POWDER, STRONG_AWAKENING_POTION);
        SomniaObjects.addBrewingRecipe(b, AWAKENING_POTION, Items.FERMENTED_SPIDER_EYE, INSOMNIA_POTION);
        SomniaObjects.addBrewingRecipe(b, LONG_AWAKENING_POTION, Items.FERMENTED_SPIDER_EYE, LONG_INSOMNIA_POTION);
        SomniaObjects.addBrewingRecipe(b, STRONG_AWAKENING_POTION, Items.FERMENTED_SPIDER_EYE, STRONG_INSOMNIA_POTION);
    }

    private static void addBrewingRecipe(PotionBrewing.Builder b, Holder<Potion> input, Item ingredient, Holder<Potion> output) {
        ItemStack outputStack = PotionContents.createItemStack((Item)Items.POTION, output);
        b.addRecipe(Ingredient.of((ItemStack[])new ItemStack[]{PotionContents.createItemStack((Item)Items.POTION, input)}), Ingredient.of((ItemLike[])new ItemLike[]{ingredient}), outputStack);
    }

    private SomniaObjects() {
    }
}

