/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.acceleration;

import dev.su5ed.somnia.SomniaConfig;
import dev.su5ed.somnia.acceleration.AccelerationManager;
import dev.su5ed.somnia.acceleration.AccelerationState;
import dev.su5ed.somnia.network.SomniaNetwork;
import dev.su5ed.somnia.network.client.PlayerWakeUpPacket;
import dev.su5ed.somnia.network.client.SpeedUpdatePacket;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class AccelerationHandler {
    public final ServerLevel level;
    private final double minMultiplier;
    private final double maxMultiplier;
    private AccelerationState state;
    private int timer;
    private double multiplier;

    public AccelerationHandler(ServerLevel level) {
        this.minMultiplier = (Double)SomniaConfig.COMMON.minMultiplier.get();
        this.maxMultiplier = (Double)SomniaConfig.COMMON.maxMultiplier.get();
        this.multiplier = this.minMultiplier;
        this.level = level;
    }

    public boolean isActive() {
        return this.state == AccelerationState.SIMULATING;
    }

    public void tickEnd() {
        if (this.timer++ % 10 == 0) {
            this.state = this.getNewState();
        }
        if (this.state == AccelerationState.SIMULATING) {
            this.accelerateTicks();
        }
    }

    private AccelerationState getNewState() {
        AccelerationState state = AccelerationState.forLevel(this.level);
        if (this.state == AccelerationState.SIMULATING && state == AccelerationState.UNAVAILABLE) {
            this.wakeUpPlayers();
        } else if (state == AccelerationState.SIMULATING || state == AccelerationState.WAITING) {
            SomniaNetwork.sendToDimension(new SpeedUpdatePacket(state == AccelerationState.SIMULATING ? this.multiplier : 0.0), this.level);
        }
        return state;
    }

    private void accelerateTicks() {
        int count = (int)this.multiplier;
        long startMillis = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            this.tickLevel();
        }
        long deltaMillis = System.currentTimeMillis() - startMillis;
        double tickLength = (double)deltaMillis / (double)count;
        double accelerationRatio = (Double)SomniaConfig.COMMON.delta.get() / (double)AccelerationManager.getActiveHandlers();
        double available = (accelerationRatio - (double)deltaMillis) / tickLength / 5.0;
        this.multiplier = Mth.clamp((double)(this.multiplier + available), (double)this.minMultiplier, (double)this.maxMultiplier);
    }

    private void tickLevel() {
        MinecraftServer server = this.level.getServer();
        ClientboundSetTimePacket packet = new ClientboundSetTimePacket(this.level.getGameTime(), this.level.getDayTime(), this.level.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT));
        server.getPlayerList().broadcastAll((Packet)packet, this.level.dimension());
        EventHooks.fireLevelTickPre((Level)this.level, () -> ((MinecraftServer)server).haveTime());
        List.copyOf(this.level.players()).forEach(ServerPlayer::doTick);
        this.level.tick(() -> ((MinecraftServer)server).haveTime());
        EventHooks.fireLevelTickPost((Level)this.level, () -> ((MinecraftServer)server).haveTime());
    }

    private void wakeUpPlayers() {
        this.level.players().stream().filter(LivingEntity::isSleeping).forEach(player -> {
            SomniaNetwork.sendToClient(PlayerWakeUpPacket.INSTANCE, player);
            String key = "somnia.status." + this.state.name().toLowerCase(Locale.ROOT);
            player.displayClientMessage((Component)Component.translatable((String)key), true);
        });
    }
}

