/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.acceleration;

import dev.su5ed.somnia.SomniaAwoken;
import dev.su5ed.somnia.acceleration.AccelerationHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="somnia")
public final class AccelerationManager {
    public static final List<AccelerationHandler> HANDLERS = new ArrayList<AccelerationHandler>();

    public static int getActiveHandlers() {
        return (int)HANDLERS.stream().filter(AccelerationHandler::isActive).count();
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            SomniaAwoken.LOGGER.info("Registering acceleration handler for loading world");
            HANDLERS.add(new AccelerationHandler(serverLevel));
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            HANDLERS.stream().filter(handler -> handler.level == serverLevel).findFirst().ifPresent(handler -> {
                SomniaAwoken.LOGGER.info("Removing acceleration handler for unloading world!");
                HANDLERS.remove(handler);
            });
        }
    }

    @SubscribeEvent
    public static void onTickEnd(ServerTickEvent.Post event) {
        HANDLERS.forEach(AccelerationHandler::tickEnd);
    }
}

