/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.somnia.capability;

import dev.su5ed.somnia.capability.CapabilityFatigue;
import dev.su5ed.somnia.capability.Fatigue;
import dev.su5ed.somnia.network.SomniaNetwork;
import dev.su5ed.somnia.network.client.FatigueUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="somnia")
public final class CapabilitySync {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilitySync.sync((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilitySync.sync((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        CapabilitySync.sync((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Fatigue fatigue = (Fatigue)event.getEntity().getCapability(CapabilityFatigue.INSTANCE);
        if (fatigue != null) {
            fatigue.setFatigue(0.0);
            fatigue.setReplenishedFatigue(0.0);
            fatigue.setExtraFatigueRate(0.0);
        }
    }

    private static void sync(ServerPlayer player) {
        Fatigue fatigue = (Fatigue)player.getCapability(CapabilityFatigue.INSTANCE);
        if (fatigue != null) {
            SomniaNetwork.sendToClient(new FatigueUpdatePacket(fatigue.getFatigue()), player);
        }
    }

    private CapabilitySync() {
    }
}

